/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import com.google.common.collect.ImmutableList;
import gregtech.api.covers.CoverRegistry;
import gregtech.api.enums.SoundResource;
import gregtech.api.interfaces.IItemBehaviour;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.items.MetaBaseItem;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import gregtech.common.items.behaviors.BehaviourNone;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class BehaviourCoverTool
extends BehaviourNone {
    public static final IItemBehaviour<MetaBaseItem> INSTANCE = new BehaviourCoverTool();
    private static final String NBT_COVER_ID = "mCoverId";
    private static final String NBT_COVER_DATA = "mCoverData";
    private final String mTooltip = GTLanguageManager.addStringLocalization("gt.behaviour.cover_copy_paste", "Can copy/paste cover data.");

    @Override
    public boolean shouldInterruptBlockActivation(EntityPlayer player, TileEntity tileEntity, ForgeDirection side) {
        return tileEntity instanceof ICoverable;
    }

    @Override
    public boolean onItemUse(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int ordinalSide, float hitX, float hitY, float hitZ) {
        if (aWorld.func_147438_o(aX, aY, aZ) instanceof ICoverable) {
            ForgeDirection side = ForgeDirection.getOrientation((int)ordinalSide);
            return this.onItemUseFirst(aItem, aStack, aPlayer, aWorld, aX, aY, aZ, side, hitX, hitY, hitZ);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onItemUseFirst(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, ForgeDirection side, float hitX, float hitY, float hitZ) {
        block8: {
            void var18_25;
            double useCost;
            block7: {
                block9: {
                    ICoverable coverable;
                    Cover targetCover;
                    NBTTagCompound tNBT;
                    block10: {
                        if (aWorld.field_72995_K) {
                            return false;
                        }
                        tNBT = aStack.func_77978_p();
                        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
                        boolean isCopyMode = aPlayer.func_70093_af();
                        double d = useCost = isCopyMode ? 100.0 : 25.0;
                        if (tNBT == null || !(aPlayer instanceof EntityPlayerMP) || !aItem.canUse(aStack, useCost)) break block8;
                        targetCover = BehaviourCoverTool.getTargetCover(tTileEntity, side, hitX, hitY, hitZ);
                        if (!(tTileEntity instanceof ICoverable)) break block9;
                        coverable = (ICoverable)tTileEntity;
                        if (targetCover == CoverRegistry.NO_COVER) break block9;
                        if (!isCopyMode) break block10;
                        if (targetCover.allowsCopyPasteTool()) {
                            List<String> list = BehaviourCoverTool.getCopyText(targetCover, aX, aY, aZ, aWorld.field_73011_w.field_76574_g);
                            this.writeChatsToNBT(list, tNBT);
                            this.saveCoverToNBT(targetCover, tNBT);
                            break block7;
                        } else {
                            ImmutableList immutableList = ImmutableList.of((Object)"Copy unavailable for this cover type");
                        }
                        break block7;
                    }
                    int copiedCoverId = tNBT.func_74762_e(NBT_COVER_ID);
                    if (copiedCoverId == 0) {
                        ImmutableList immutableList = ImmutableList.of((Object)"Please Copy a Valid Cover First.");
                        break block7;
                    } else if (targetCover.getCoverID() == copiedCoverId) {
                        coverable.updateAttachedCover(copiedCoverId, targetCover.getSide(), tNBT.func_74775_l(NBT_COVER_DATA));
                        ImmutableList immutableList = ImmutableList.of((Object)"Cover Data Pasted.");
                        break block7;
                    } else {
                        ImmutableList immutableList = ImmutableList.of((Object)"Not Matched Cover.");
                    }
                    break block7;
                }
                ImmutableList immutableList = ImmutableList.of((Object)"No Cover Found.");
            }
            this.sendChatsToPlayer((List<String>)var18_25, aPlayer);
            aItem.discharge(aStack, useCost, Integer.MAX_VALUE, true, false, false);
            GTUtility.doSoundAtClient(SoundResource.IC2_TOOLS_OD_SCANNER, 1, 1.0f, (double)aX, (double)aY, (double)aZ);
        }
        return aPlayer instanceof EntityPlayerMP;
    }

    private static Cover getTargetCover(TileEntity tileEntity, ForgeDirection side, float hitX, float hitY, float hitZ) {
        if (tileEntity instanceof ICoverable) {
            ICoverable coverable = (ICoverable)tileEntity;
            Cover coverAtSide = coverable.getCoverAtSide(side);
            if (coverAtSide != CoverRegistry.NO_COVER) {
                return coverAtSide;
            }
            return coverable.getCoverAtSide(GTUtility.determineWrenchingSide(side, hitX, hitY, hitZ));
        }
        return CoverRegistry.NO_COVER;
    }

    @NotNull
    private static List<String> getCopyText(@NotNull Cover targetCover, int aX, int aY, int aZ, int dimensionId) {
        ArrayList<String> chats = new ArrayList<String>();
        chats.add(EnumChatFormatting.STRIKETHROUGH + "-----" + EnumChatFormatting.RESET + " X: " + EnumChatFormatting.AQUA + GTUtility.formatNumbers(aX) + EnumChatFormatting.RESET + " Y: " + EnumChatFormatting.AQUA + GTUtility.formatNumbers(aY) + EnumChatFormatting.RESET + " Z: " + EnumChatFormatting.AQUA + GTUtility.formatNumbers(aZ) + EnumChatFormatting.RESET + " D: " + EnumChatFormatting.AQUA + dimensionId + EnumChatFormatting.RESET + " " + EnumChatFormatting.STRIKETHROUGH + "-----");
        ForgeDirection tSide = targetCover.getSide();
        chats.add("Block Side: " + EnumChatFormatting.AQUA + tSide.name() + EnumChatFormatting.RESET);
        String coverDisplayName = targetCover.asItemStack().func_82833_r();
        chats.add("Cover Type: " + EnumChatFormatting.GREEN + coverDisplayName + EnumChatFormatting.RESET);
        return chats;
    }

    private void saveCoverToNBT(Cover cover, NBTTagCompound aNBT) {
        aNBT.func_74768_a(NBT_COVER_ID, cover.getCoverID());
        aNBT.func_74782_a(NBT_COVER_DATA, (NBTBase)cover.writeToNBT(new NBTTagCompound()));
    }

    private void writeChatsToNBT(@NotNull List<String> chats, @NotNull NBTTagCompound aNBT) {
        int tSize = chats.size();
        aNBT.func_74768_a("dataLinesCount", tSize);
        for (int i = 0; i < tSize; ++i) {
            aNBT.func_74778_a("dataLines" + i, chats.get(i));
        }
    }

    private void sendChatsToPlayer(@NotNull List<String> chats, @NotNull EntityPlayer aPlayer) {
        for (String chat : chats) {
            GTUtility.sendChatToPlayer(aPlayer, chat);
        }
    }

    @Override
    public List<String> getAdditionalToolTips(MetaBaseItem aItem, List<String> aList, ItemStack aStack) {
        try {
            NBTTagCompound tNBT = aStack.func_77978_p();
            int tSize = tNBT.func_74762_e("dataLinesCount");
            if (tSize < 1) {
                throw new Exception();
            }
            aList.add(EnumChatFormatting.BLUE + "Stored Cover Data:");
            for (int i = 0; i < tSize; ++i) {
                aList.add(EnumChatFormatting.RESET + tNBT.func_74779_i("dataLines" + i));
            }
        }
        catch (Exception e) {
            aList.add(this.mTooltip);
        }
        return aList;
    }
}

