/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.gtnewhorizon.gtnhlib.util.map.ItemStackMap;
import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.fluid.IFluidStore;
import gregtech.api.interfaces.tileentity.IVoidable;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.util.OutputHatchWrapper;
import gregtech.common.tileentities.machines.MTEHatchOutputME;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class VoidProtectionHelper {
    private IVoidable machine;
    private boolean protectExcessItem;
    private boolean protectExcessFluid;
    private int maxParallel = 1;
    private boolean isItemFull;
    private boolean isFluidFull;
    private ItemStack[] itemOutputs;
    private FluidStack[] fluidOutputs;
    private boolean built;
    private double chanceMultiplier = 1.0;
    private Function<Integer, Integer> chanceGetter = i -> 10000;

    public VoidProtectionHelper setMachine(IVoidable machine) {
        return this.setMachine(machine, machine.protectsExcessItem(), machine.protectsExcessFluid());
    }

    public VoidProtectionHelper setMachine(IVoidable machine, boolean protectExcessItem, boolean protectExcessFluid) {
        this.protectExcessItem = protectExcessItem;
        this.protectExcessFluid = protectExcessFluid;
        this.machine = machine;
        return this;
    }

    public VoidProtectionHelper setItemOutputs(ItemStack[] itemOutputs) {
        this.itemOutputs = itemOutputs;
        return this;
    }

    public VoidProtectionHelper setFluidOutputs(FluidStack[] fluidOutputs) {
        this.fluidOutputs = fluidOutputs;
        return this;
    }

    public VoidProtectionHelper setMaxParallel(int maxParallel) {
        this.maxParallel = maxParallel;
        return this;
    }

    public VoidProtectionHelper setChanceMultiplier(double chanceMultiplier) {
        this.chanceMultiplier = chanceMultiplier;
        return this;
    }

    public VoidProtectionHelper setChangeGetter(Function<Integer, Integer> getter) {
        this.chanceGetter = getter;
        return this;
    }

    public VoidProtectionHelper build() {
        if (this.built) {
            throw new IllegalStateException("Tried to build twice");
        }
        if (this.machine == null) {
            throw new IllegalStateException("Machine is not set");
        }
        this.built = true;
        this.determineParallel();
        return this;
    }

    public int getMaxParallel() {
        if (!this.built) {
            throw new IllegalStateException("Tried to get parallels before building");
        }
        return this.maxParallel;
    }

    public boolean isItemFull() {
        if (!this.built) {
            throw new IllegalStateException("Tried to get isItemFull before building");
        }
        return this.isItemFull;
    }

    public boolean isFluidFull() {
        if (!this.built) {
            throw new IllegalStateException("Tried to get isFluidFull before building");
        }
        return this.isFluidFull;
    }

    private void determineParallel() {
        if (this.itemOutputs == null) {
            this.itemOutputs = GTValues.emptyItemStackArray;
        }
        if (this.fluidOutputs == null) {
            this.fluidOutputs = GTValues.emptyFluidStackArray;
        }
        if (this.protectExcessItem && this.itemOutputs.length > 0 && !this.machine.canDumpItemToME()) {
            this.maxParallel = Math.min(this.calculateMaxItemParallels(), this.maxParallel);
            if (this.maxParallel <= 0) {
                this.isItemFull = true;
                return;
            }
        }
        if (this.protectExcessFluid && this.fluidOutputs.length > 0 && !this.machine.canDumpFluidToME()) {
            this.maxParallel = Math.min(this.calculateMaxFluidParallels(), this.maxParallel);
            if (this.maxParallel <= 0) {
                this.isFluidFull = true;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private int calculateMaxFluidParallels() {
        void var6_10;
        List<? extends IFluidStore> hatches = this.machine.getFluidOutputSlots(this.fluidOutputs);
        if (hatches.size() < this.fluidOutputs.length) {
            return 0;
        }
        HashMap<FluidStack, Integer> tFluidOutputMap = new HashMap<FluidStack, Integer>();
        HashMap<FluidStack, ParallelData> tParallels = new HashMap<FluidStack, ParallelData>();
        FluidStack[] fluidStackArray = this.fluidOutputs;
        int n = fluidStackArray.length;
        boolean bl = false;
        while (var6_10 < n) {
            FluidStack aY = fluidStackArray[var6_10];
            if (aY != null && aY.amount > 0) {
                tFluidOutputMap.merge(aY, aY.amount, Integer::sum);
                tParallels.put(aY, new ParallelData(0, 0L));
            }
            ++var6_10;
        }
        if (tFluidOutputMap.isEmpty()) {
            return this.maxParallel;
        }
        for (IFluidStore iFluidStore : hatches) {
            MTEHatchOutputME tMEHatch;
            OutputHatchWrapper w;
            MTEHatchOutput mTEHatchOutput;
            Object tMEHatch2;
            int n2 = iFluidStore instanceof MTEHatchOutputME ? (((MTEHatchOutputME)(tMEHatch2 = (MTEHatchOutputME)iFluidStore)).canAcceptFluid() ? Integer.MAX_VALUE : 0) : (iFluidStore instanceof OutputHatchWrapper && (mTEHatchOutput = (w = (OutputHatchWrapper)iFluidStore).unwrap()) instanceof MTEHatchOutputME ? ((tMEHatch = (MTEHatchOutputME)mTEHatchOutput).canAcceptFluid() ? Integer.MAX_VALUE : 0) : iFluidStore.getCapacity() - iFluidStore.getFluidAmount());
            if (n2 <= 0 || iFluidStore.isEmptyAndAcceptsAnyFluid()) continue;
            tMEHatch2 = tParallels.entrySet().iterator();
            while (tMEHatch2.hasNext()) {
                Map.Entry entry = (Map.Entry)tMEHatch2.next();
                FluidStack tFluidOutput = (FluidStack)entry.getKey();
                if (!iFluidStore.canStoreFluid(tFluidOutput)) continue;
                ParallelData tParallel = (ParallelData)entry.getValue();
                Integer tCraftSize = (Integer)tFluidOutputMap.get(tFluidOutput);
                tParallel.batch = (int)((long)tParallel.batch + (tParallel.partial + (long)n2) / (long)tCraftSize.intValue());
                tParallel.partial = (tParallel.partial + (long)n2) % (long)tCraftSize.intValue();
            }
        }
        PriorityQueue<ParallelStackInfo> aParallelQueue = new PriorityQueue<ParallelStackInfo>(Comparator.comparing(i -> ((ParallelStackInfo)i).batch));
        for (Map.Entry entry : tParallels.entrySet()) {
            aParallelQueue.add(new ParallelStackInfo(((ParallelData)entry.getValue()).batch, ((ParallelData)entry.getValue()).partial, (FluidStack)entry.getKey()));
        }
        for (IFluidStore iFluidStore : hatches) {
            MTEHatchOutputME tMEHatch;
            OutputHatchWrapper w;
            MTEHatchOutput mTEHatchOutput;
            MTEHatchOutputME tMEHatch3;
            if (!iFluidStore.isEmptyAndAcceptsAnyFluid()) continue;
            ParallelStackInfo tParallel = aParallelQueue.poll();
            assert (tParallel != null);
            Integer tCraftSize = (Integer)tFluidOutputMap.get(tParallel.stack);
            int tSpaceLeft = iFluidStore instanceof MTEHatchOutputME ? ((tMEHatch3 = (MTEHatchOutputME)iFluidStore).canAcceptFluid() ? Integer.MAX_VALUE : 0) : (iFluidStore instanceof OutputHatchWrapper && (mTEHatchOutput = (w = (OutputHatchWrapper)iFluidStore).unwrap()) instanceof MTEHatchOutputME ? ((tMEHatch = (MTEHatchOutputME)mTEHatchOutput).canAcceptFluid() ? Integer.MAX_VALUE : 0) : iFluidStore.getCapacity());
            tParallel.batch = (int)((long)tParallel.batch + (tParallel.partial + (long)tSpaceLeft) / (long)tCraftSize.intValue());
            tParallel.partial = (tParallel.partial + (long)tSpaceLeft) % (long)tCraftSize.intValue();
            aParallelQueue.add(tParallel);
        }
        return ((ParallelStackInfo)aParallelQueue.element()).batch;
    }

    private int calculateMaxItemParallels() {
        List<ItemStack> busStacks = this.machine.getItemOutputSlots(this.itemOutputs);
        ItemStackMap tItemOutputMap = new ItemStackMap();
        ItemStackMap tParallels = new ItemStackMap();
        int tSlotsFree = 0;
        int index = 0;
        for (ItemStack tItem : this.itemOutputs) {
            int itemStackSize;
            if (tItem == null || (itemStackSize = (int)((double)tItem.field_77994_a * Math.ceil(this.chanceMultiplier * (double)this.chanceGetter.apply(index++).intValue() / 10000.0))) <= 0) continue;
            tItemOutputMap.merge(tItem, itemStackSize, Integer::sum);
            tParallels.put(tItem, new ParallelData(0, 0L));
        }
        if (tItemOutputMap.isEmpty()) {
            return this.maxParallel;
        }
        if (this.itemOutputs.length > 0) {
            for (ItemStack tBusStack : busStacks) {
                ParallelData tParallel;
                if (tBusStack == null) {
                    ++tSlotsFree;
                    continue;
                }
                if (tBusStack.field_77994_a == 65) {
                    for (Map.Entry entry : tParallels.entrySet()) {
                        ItemStack tItemOutput = (ItemStack)entry.getKey();
                        if (!tBusStack.func_77969_a(tItemOutput)) continue;
                        tParallel = (ParallelData)entry.getValue();
                        Integer tCraftSize = (Integer)tItemOutputMap.get(tBusStack);
                        tParallel.batch = (int)((long)tParallel.batch + (tParallel.partial + Integer.MAX_VALUE) / (long)tCraftSize.intValue());
                        tParallel.partial = (tParallel.partial + Integer.MAX_VALUE) % (long)tCraftSize.intValue();
                    }
                    continue;
                }
                int tMaxBusStackSize = tBusStack.func_77976_d();
                if (tBusStack.field_77994_a >= tMaxBusStackSize) continue;
                int tSpaceLeft = tMaxBusStackSize - tBusStack.field_77994_a;
                Integer tCraftSize = (Integer)tItemOutputMap.get(tBusStack);
                if (tCraftSize == null) continue;
                tParallel = (ParallelData)tParallels.get(tBusStack);
                tParallel.batch = (int)((long)tParallel.batch + (tParallel.partial + (long)tSpaceLeft) / (long)tCraftSize.intValue());
                tParallel.partial = (tParallel.partial + (long)tSpaceLeft) % (long)tCraftSize.intValue();
            }
            PriorityQueue<ParallelStackInfo> aParallelQueue = new PriorityQueue<ParallelStackInfo>(Comparator.comparing(i -> ((ParallelStackInfo)i).batch));
            for (Map.Entry entry : tParallels.entrySet()) {
                aParallelQueue.add(new ParallelStackInfo(((ParallelData)entry.getValue()).batch, ((ParallelData)entry.getValue()).partial, (ItemStack)entry.getKey()));
            }
            while (tSlotsFree > 0) {
                ParallelStackInfo tParallel = aParallelQueue.poll();
                assert (tParallel != null);
                Integer tCraftSize = (Integer)tItemOutputMap.get(tParallel.stack);
                int tStackSize = ((ItemStack)tParallel.stack).func_77976_d();
                tParallel.batch = (int)((long)tParallel.batch + (tParallel.partial + (long)tStackSize) / (long)tCraftSize.intValue());
                tParallel.partial = (tParallel.partial + (long)tStackSize) % (long)tCraftSize.intValue();
                aParallelQueue.add(tParallel);
                --tSlotsFree;
            }
            return ((ParallelStackInfo)aParallelQueue.element()).batch;
        }
        return 0;
    }

    private static class ParallelData {
        private int batch;
        private long partial;

        private ParallelData(int batch, long partial) {
            this.batch = batch;
            this.partial = partial;
        }
    }

    private static class ParallelStackInfo<T> {
        private int batch;
        private long partial;
        private final T stack;

        private ParallelStackInfo(int batch, long partial, T stack) {
            this.batch = batch;
            this.partial = partial;
            this.stack = stack;
        }
    }
}

