/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.enums.GTValues;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomFishable;
import net.minecraftforge.common.FishingHooks;

public class FishPondRecipes {
    public static void generateFishPondRecipes() {
        try {
            ArrayList fishList = (ArrayList)GTUtility.getField(FishingHooks.class, "fish").get(null);
            ArrayList junkList = (ArrayList)GTUtility.getField(FishingHooks.class, "junk").get(null);
            ArrayList treasureList = (ArrayList)GTUtility.getField(FishingHooks.class, "treasure").get(null);
            Field stackField = GTUtility.getField(WeightedRandomFishable.class, "field_150711_b");
            FishPondRecipes.generateRecipeForFishable(14, fishList, stackField, 0.85);
            FishPondRecipes.generateRecipeForFishable(15, junkList, stackField, 1.35);
            FishPondRecipes.generateRecipeForFishable(16, treasureList, stackField, 20.0);
        }
        catch (Exception e) {
            Logger.INFO("Error reading the vanilla fishing loot table.");
            e.printStackTrace();
        }
    }

    private static void generateRecipeForFishable(int circuitType, ArrayList<WeightedRandomFishable> lootTable, Field stackField, double chanceMultiplier) {
        int[] chances = new int[lootTable.size()];
        ItemStack[] outputs = new ItemStack[lootTable.size()];
        for (int i = 0; i < lootTable.size(); ++i) {
            chances[i] = (int)((double)(lootTable.get((int)i).field_76292_a * 100) * chanceMultiplier);
            try {
                ItemFishFood.FishType fishtype;
                ItemStack output = (ItemStack)stackField.get(lootTable.get(i));
                if (output.func_77973_b() instanceof ItemFishFood && (fishtype = ItemFishFood.FishType.func_150978_a((ItemStack)output)) == ItemFishFood.FishType.PUFFERFISH) {
                    chances[i] = chances[i] * 3;
                }
                outputs[i] = output;
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException e1) {
                Logger.INFO("Error generating Fish Pond Recipes");
                e1.printStackTrace();
            }
        }
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(circuitType)).itemOutputs(outputs, chances).duration(200).eut(16).ignoreCollision().addTo(GTPPRecipeMaps.fishPondRecipes);
    }
}

