/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketTypes;
import gregtech.common.handlers.PowerGogglesHudHandler;
import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import net.minecraft.world.IBlockAccess;

public class GTPacketUpdatePowerGoggles
extends GTPacket {
    BigInteger EU;
    long lscCapacity;
    boolean refresh;

    public GTPacketUpdatePowerGoggles() {
    }

    public GTPacketUpdatePowerGoggles(BigInteger EU) {
        this.EU = EU;
        this.refresh = false;
        this.lscCapacity = 0L;
    }

    public GTPacketUpdatePowerGoggles(BigInteger EU, long lscCapacity, boolean refresh) {
        this(EU, refresh);
        this.lscCapacity = lscCapacity;
    }

    public GTPacketUpdatePowerGoggles(BigInteger EU, boolean refresh) {
        this.EU = EU;
        this.refresh = refresh;
        this.lscCapacity = 0L;
    }

    @Override
    public byte getPacketID() {
        return GTPacketTypes.SEND_WIRELESS_EU.id;
    }

    @Override
    public void encode(ByteBuf buffer) {
        buffer.writeBoolean(this.refresh);
        byte[] EUBytes = this.EU.toByteArray();
        buffer.writeInt(EUBytes.length);
        buffer.writeBytes(EUBytes);
        buffer.writeLong(this.lscCapacity);
    }

    @Override
    public GTPacket decode(ByteArrayDataInput buffer) {
        boolean refresh = buffer.readBoolean();
        int length = buffer.readInt();
        byte[] eu = new byte[length];
        for (int i = 0; i < length; ++i) {
            eu[i] = buffer.readByte();
        }
        BigInteger EU = new BigInteger(eu);
        long lscCapacity = buffer.readLong();
        return new GTPacketUpdatePowerGoggles(EU, lscCapacity, refresh);
    }

    @Override
    public void process(IBlockAccess aWorld) {
        if (this.refresh) {
            PowerGogglesHudHandler.clear();
        }
        PowerGogglesHudHandler.setMeasurement(this.EU, this.lscCapacity);
        PowerGogglesHudHandler.updateClient = true;
    }
}

