/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations.gui;

import com.cleanroommc.modularui.api.IPanelHandler;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IBoolValue;
import com.cleanroommc.modularui.api.value.IStringValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.DrawableStack;
import com.cleanroommc.modularui.drawable.DynamicDrawable;
import com.cleanroommc.modularui.drawable.UITexture;
import com.cleanroommc.modularui.factory.PosGuiData;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.screen.UISettings;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.item.IItemHandler;
import com.cleanroommc.modularui.utils.serialization.IByteBufAdapter;
import com.cleanroommc.modularui.value.sync.BooleanSyncValue;
import com.cleanroommc.modularui.value.sync.GenericListSyncHandler;
import com.cleanroommc.modularui.value.sync.GenericSyncValue;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.value.sync.LongSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.StringSyncValue;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widget.SingleChildWidget;
import com.cleanroommc.modularui.widget.sizer.Area;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import com.cleanroommc.modularui.widgets.CycleButtonWidget;
import com.cleanroommc.modularui.widgets.ListWidget;
import com.cleanroommc.modularui.widgets.SlotGroupWidget;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.cleanroommc.modularui.widgets.ToggleButton;
import com.cleanroommc.modularui.widgets.layout.Column;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.layout.Row;
import com.cleanroommc.modularui.widgets.slot.ItemSlot;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.cleanroommc.modularui.widgets.textfield.TextFieldWidget;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import gregtech.api.enums.Mods;
import gregtech.api.enums.VoidingMode;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.metatileentity.implementations.gui.CheckRecipeResultAdapter;
import gregtech.api.metatileentity.implementations.gui.ShutdownReasonAdapter;
import gregtech.api.metatileentity.implementations.gui.StructureErrorAdapter;
import gregtech.api.modularui2.GTGuiTextures;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.util.GTUtility;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.modularui2.sync.Predicates;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTEMultiBlockBaseGui {
    protected final MTEMultiBlockBase base;
    private final IGregTechTileEntity baseMetaTileEntity;
    protected List<UITexture> machineModeIcons = new ArrayList<UITexture>();
    protected Map<String, UITexture> customIcons = new HashMap<String, UITexture>();
    protected final int textBoxToInventoryGap = 26;
    protected final Map<String, IPanelHandler> panelMap = new HashMap<String, IPanelHandler>();

    public MTEMultiBlockBaseGui(MTEMultiBlockBase base) {
        this.base = base;
        this.baseMetaTileEntity = base.getBaseMetaTileEntity();
        this.initCustomIcons();
    }

    protected void initCustomIcons() {
        this.customIcons.put("power_switch_disabled", GTGuiTextures.OVERLAY_BUTTON_POWER_SWITCH_DISABLED);
        this.customIcons.put("power_switch_on", GTGuiTextures.OVERLAY_BUTTON_POWER_SWITCH_ON);
        this.customIcons.put("power_switch_off", GTGuiTextures.OVERLAY_BUTTON_POWER_SWITCH_OFF);
    }

    public ModularPanel build(PosGuiData guiData, PanelSyncManager syncManager, UISettings uiSettings) {
        this.setMachineModeIcons();
        this.registerSyncValues(syncManager);
        ModularPanel panel = (ModularPanel)((ModularPanel)new ModularPanel("MTEMultiBlockBase").size(198, 207)).padding(4);
        return (ModularPanel)panel.child((IWidget)((Flow)((Flow)((Flow)((Flow)new Column().sizeRel(1.0f)).child(this.createTitleTextStyle(this.base.getLocalName()))).child((IWidget)this.createTerminalRow(panel, syncManager))).child(this.createPanelGap(panel, syncManager))).child(this.createInventoryRow(panel, syncManager)));
    }

    private IWidget createTitleTextStyle(String title) {
        return ((SingleChildWidget)((SingleChildWidget)((SingleChildWidget)((SingleChildWidget)new SingleChildWidget().coverChildren()).topRel(0.0f, -4, 1.0f)).leftRel(0.0f, -4, 0.0f)).widgetTheme("backgroundTitle")).child((IWidget)((TextWidget)((TextWidget)((TextWidget)((TextWidget)IKey.str((String)title).asWidget().alignment(Alignment.Center).widgetTheme("textTitle")).marginLeft(5)).marginRight(5)).marginTop(5)).marginBottom(1));
    }

    protected Flow createTerminalRow(ModularPanel panel, PanelSyncManager syncManager) {
        return (Flow)((Flow)new Row().size(this.getTerminalRowWidth(), this.getTerminalRowHeight())).child((IWidget)((ParentWidget)((ParentWidget)((ParentWidget)((ParentWidget)new ParentWidget().size(this.getTerminalWidgetWidth(), this.getTerminalWidgetHeight())).padding(4)).widgetTheme("backgroundTerminal")).child((IWidget)((ListWidget)this.createTerminalTextWidget(syncManager, panel).size(this.getTerminalWidgetWidth() - 10, this.getTerminalWidgetHeight() - 8)).collapseDisabledChild())).child((IWidget)((SingleChildWidget)((SingleChildWidget)((SingleChildWidget)new SingleChildWidget().bottomRel(0.0f, 10, 0.0f)).rightRel(0.0f, 10, 0.0f)).size(18, 18)).widgetTheme("pictureLogo")));
    }

    protected int getTerminalRowWidth() {
        return 190;
    }

    protected int getTerminalRowHeight() {
        return this.base.doesBindPlayerInventory() ? 94 : 174;
    }

    protected int getTerminalWidgetWidth() {
        return this.getTerminalRowWidth();
    }

    protected int getTerminalWidgetHeight() {
        return this.getTerminalRowHeight();
    }

    protected ListWidget<IWidget, ?> createTerminalTextWidget(PanelSyncManager syncManager, ModularPanel parent) {
        return (ListWidget)((ListWidget)((ListWidget)((ListWidget)((ListWidget)((ListWidget)((ListWidget)((ListWidget)((ListWidget)((ListWidget)((ListWidget)((ListWidget)((ListWidget)((ListWidget)((ListWidget)new ListWidget().child((IWidget)((TextWidget)((TextWidget)new TextWidget(GTUtility.trans("132", "Pipe is loose. (Wrench)")).color(Integer.valueOf(Color.WHITE.main)).setEnabledIf(widget -> !this.base.mWrench)).marginBottom(2)).widthRel(1.0f))).child((IWidget)((TextWidget)((TextWidget)new TextWidget(GTUtility.trans("133", "Screws are loose. (Screwdriver)")).color(Integer.valueOf(Color.WHITE.main)).setEnabledIf(widget -> !this.base.mScrewdriver)).marginBottom(2)).widthRel(1.0f))).child((IWidget)((TextWidget)((TextWidget)new TextWidget(GTUtility.trans("134", "Something is stuck. (Soft Mallet)")).color(Integer.valueOf(Color.WHITE.main)).setEnabledIf(widget -> !this.base.mSoftMallet)).marginBottom(2)).widthRel(1.0f))).child((IWidget)((TextWidget)((TextWidget)new TextWidget(GTUtility.trans("135", "Platings are dented. (Hammer)")).color(Integer.valueOf(Color.WHITE.main)).setEnabledIf(widget -> !this.base.mHardHammer)).marginBottom(2)).widthRel(1.0f))).child((IWidget)((TextWidget)((TextWidget)new TextWidget(GTUtility.trans("136", "Circuitry burned out. (Soldering)")).color(Integer.valueOf(Color.WHITE.main)).setEnabledIf(widget -> !this.base.mSolderingTool)).marginBottom(2)).widthRel(1.0f))).child((IWidget)((TextWidget)((TextWidget)new TextWidget(GTUtility.trans("137", "That doesn't belong there. (Crowbar)")).color(Integer.valueOf(Color.WHITE.main)).setEnabledIf(widget -> !this.base.mCrowbar)).marginBottom(2)).widthRel(1.0f))).child((IWidget)((TextWidget)((TextWidget)new TextWidget(GTUtility.trans("138", "Incomplete Structure.")).color(Integer.valueOf(Color.WHITE.main)).setEnabledIf(widget -> !this.base.mMachine)).marginBottom(2)).widthRel(1.0f))).child((IWidget)((TextWidget)((TextWidget)new TextWidget(StatCollector.func_74838_a((String)"GT5U.gui.text.too_uncertain")).color(Integer.valueOf(Color.WHITE.main)).setEnabledIf(widget -> (this.base.getErrorDisplayID() & 0x80) != 0)).marginBottom(2)).widthRel(1.0f))).child((IWidget)((TextWidget)((TextWidget)new TextWidget(StatCollector.func_74838_a((String)"GT5U.gui.text.invalid_parameters")).color(Integer.valueOf(Color.WHITE.main)).setEnabledIf(widget -> (this.base.getErrorDisplayID() & 0x100) != 0)).marginBottom(2)).widthRel(1.0f))).child((IWidget)((TextWidget)((TextWidget)new TextWidget(IKey.comp((IKey[])new IKey[]{IKey.lang((String)"gt.interact.desc.mb.idle.1"), IKey.lang((String)"gt.interact.desc.mb.idle.2"), IKey.lang((String)"gt.interact.desc.mb.idle.3")})).color(Integer.valueOf(Color.WHITE.main)).setEnabledIf(widget -> this.base.getErrorDisplayID() == 0 && !this.baseMetaTileEntity.isActive() && !this.baseMetaTileEntity.isAllowedToWork())).marginBottom(2)).widthRel(1.0f))).child((IWidget)((TextWidget)((TextWidget)new TextWidget(GTUtility.trans("142", "Running perfectly.")).color(Integer.valueOf(Color.WHITE.main)).setEnabledIf(widget -> this.base.getErrorDisplayID() == 0 && this.baseMetaTileEntity.isActive())).marginBottom(2)).widthRel(1.0f))).child(this.createShutdownDurationWidget())).child(this.createShutdownReasonWidget())).child(this.createRecipeResultWidget())).childIf(this.base.showRecipeTextInGUI(), this.createRecipeInfoWidget(syncManager));
    }

    private IWidget createShutdownDurationWidget() {
        return ((TextWidget)((TextWidget)IKey.dynamic(() -> {
            Duration time = Duration.ofSeconds((this.base.getTotalRunTime() - this.base.getLastWorkingTick()) / 20L);
            return StatCollector.func_74837_a((String)"GT5U.gui.text.shutdown_duration", (Object[])new Object[]{time.toHours(), time.toMinutes() % 60L, time.getSeconds() % 60L});
        }).asWidget().marginBottom(2)).widthRel(1.0f)).setEnabledIf(widget -> this.base.shouldDisplayShutDownReason() && !this.baseMetaTileEntity.isActive() && !this.baseMetaTileEntity.isAllowedToWork());
    }

    private IWidget createShutdownReasonWidget() {
        return ((TextWidget)((TextWidget)IKey.dynamic(() -> this.baseMetaTileEntity.getLastShutDownReason().getDisplayString()).asWidget().marginBottom(2)).widthRel(1.0f)).setEnabledIf(widget -> this.shouldShutdownReasonBeDisplayed());
    }

    private boolean shouldShutdownReasonBeDisplayed() {
        return this.base.shouldDisplayShutDownReason() && !this.baseMetaTileEntity.isActive() && !this.baseMetaTileEntity.isAllowedToWork() && GTUtility.isStringValid(this.baseMetaTileEntity.getLastShutDownReason().getDisplayString());
    }

    private IWidget createRecipeResultWidget() {
        return ((TextWidget)((TextWidget)IKey.dynamic(() -> this.base.getCheckRecipeResult().getDisplayString()).asWidget().marginBottom(2)).widthRel(1.0f)).setEnabledIf(widget -> this.shouldRecipeResultBeDisplayed());
    }

    private boolean shouldRecipeResultBeDisplayed() {
        CheckRecipeResult recipeResult = this.base.getCheckRecipeResult();
        return this.base.shouldDisplayCheckRecipeResult() && GTUtility.isStringValid(recipeResult.getDisplayString()) && (this.base.isAllowedToWork() || this.baseMetaTileEntity.isActive() || recipeResult.persistsOnShutdown());
    }

    private IWidget createRecipeInfoWidget(PanelSyncManager syncManager) {
        return ((TextWidget)((TextWidget)IKey.dynamic(() -> ((StringSyncValue)syncManager.getSyncHandler("recipeInfo:0")).getValue()).asWidget().marginBottom(2)).widthRel(1.0f)).setEnabledIf(widget -> Predicates.isNonEmptyList(syncManager.getSyncHandler("itemOutput:0")) || Predicates.isNonEmptyList(syncManager.getSyncHandler("fluidOutput:0")));
    }

    protected IWidget createPanelGap(ModularPanel parent, PanelSyncManager syncManager) {
        return (IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)new Row().widthRel(1.0f)).paddingRight(6)).paddingLeft(4)).height(26)).child(this.createVoidExcessButton(syncManager))).child(this.createInputSeparationButton(syncManager))).childIf(!this.machineModeIcons.isEmpty(), this.createModeSwitchButton(syncManager))).child(this.createBatchModeButton(syncManager))).child(this.createLockToSingleRecipeButton(syncManager))).childIf(this.base.supportsPowerPanel(), this.createPowerPanelButton(syncManager, parent));
    }

    protected IWidget createVoidExcessButton(PanelSyncManager syncManager) {
        IntSyncValue voidExcessSyncer = (IntSyncValue)syncManager.getSyncHandler("voidExcess:0");
        return (IWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().size(18, 18)).onMousePressed(mouseButton -> this.voidExcessOnMousePressed(mouseButton, voidExcessSyncer)).overlay(new IDrawable[]{this.base.supportsVoidProtection() ? this.getVoidExcessOverlay() : this.getForcedVoidExcessOverlay()})).tooltipBuilder(this::createVoidExcessTooltip);
    }

    private boolean voidExcessOnMousePressed(int mouseButton, IntSyncValue voidExcessSyncer) {
        if (!this.base.supportsVoidProtection()) {
            return false;
        }
        Set allowed = this.base.getAllowedVoidingModes();
        int voidingMode = 0;
        switch (mouseButton) {
            case 0: {
                voidingMode = this.base.getVoidingMode().nextInCollection(allowed).ordinal();
                break;
            }
            case 1: {
                voidingMode = this.base.getVoidingMode().previousInCollection(allowed).ordinal();
            }
        }
        voidExcessSyncer.setValue((Object)voidingMode);
        return true;
    }

    private IDrawable getForcedVoidExcessOverlay() {
        return new DrawableStack(new IDrawable[]{this.base.getVoidingMode().buttonOverlay, GTGuiTextures.OVERLAY_BUTTON_FORBIDDEN});
    }

    private IDrawable getVoidExcessOverlay() {
        return new DynamicDrawable(() -> this.base.getVoidingMode().buttonOverlay);
    }

    private void createVoidExcessTooltip(RichTooltip t) {
        ((RichTooltip)t.addLine((IDrawable)IKey.dynamic(() -> StatCollector.func_74838_a((String)"GT5U.gui.button.voiding_mode")))).addLine((IDrawable)IKey.dynamic(() -> StatCollector.func_74838_a((String)this.base.getVoidingMode().getTransKey())));
        if (!this.base.supportsVoidProtection()) {
            t.addLine((IDrawable)IKey.lang((String)"GT5U.gui.button.forbidden"));
        }
    }

    protected IWidget createInputSeparationButton(PanelSyncManager syncManager) {
        BooleanSyncValue inputSeparationSyncer = (BooleanSyncValue)syncManager.getSyncHandler("inputSeparation:0");
        return (IWidget)((ToggleButton)((ToggleButton)new ToggleButton(){

            @NotNull
            public Interactable.Result onMousePressed(int mouseButton) {
                if (!MTEMultiBlockBaseGui.this.base.supportsInputSeparation()) {
                    return Interactable.Result.IGNORE;
                }
                return super.onMousePressed(mouseButton);
            }
        }.size(18, 18)).value((IBoolValue)this.getInputSeparationSyncValue(inputSeparationSyncer)).overlay(new IDrawable[]{this.base.supportsInputSeparation() ? this.getInputSeparationOverlay(inputSeparationSyncer) : this.getForcedInputSeparationOverlay()})).tooltipBuilder(this::createInputSeparationTooltip);
    }

    private BooleanSyncValue getInputSeparationSyncValue(BooleanSyncValue inputSeparationSyncer) {
        return new BooleanSyncValue(() -> inputSeparationSyncer.getValue() != false || !this.base.supportsInputSeparation(), bool -> {
            if (this.base.supportsInputSeparation()) {
                inputSeparationSyncer.setValue((Object)bool);
            }
        });
    }

    private IDrawable getForcedInputSeparationOverlay() {
        UITexture texture = this.base.isBatchModeEnabled() ? GTGuiTextures.OVERLAY_BUTTON_INPUT_SEPARATION_ON_DISABLED : GTGuiTextures.OVERLAY_BUTTON_INPUT_SEPARATION_OFF_DISABLED;
        return new DrawableStack(new IDrawable[]{texture, GTGuiTextures.OVERLAY_BUTTON_FORBIDDEN});
    }

    private IDrawable getInputSeparationOverlay(BooleanSyncValue inputSeparationSyncer) {
        return new DynamicDrawable(() -> inputSeparationSyncer.getValue() != false ? GTGuiTextures.OVERLAY_BUTTON_INPUT_SEPARATION_ON : GTGuiTextures.OVERLAY_BUTTON_INPUT_SEPARATION_OFF);
    }

    private void createInputSeparationTooltip(RichTooltip t) {
        t.addLine((IDrawable)IKey.lang((String)"GT5U.gui.button.input_separation"));
        if (!this.base.supportsInputSeparation()) {
            t.addLine((IDrawable)IKey.lang((String)"GT5U.gui.button.forbidden"));
        }
    }

    protected IWidget createModeSwitchButton(PanelSyncManager syncManager) {
        IntSyncValue machineModeSyncer = (IntSyncValue)syncManager.getSyncHandler("machineMode:0");
        return (IWidget)((CycleButtonWidget)((CycleButtonWidget)((CycleButtonWidget)new CycleButtonWidget().size(18, 18)).syncHandler("machineMode")).length(this.machineModeIcons.size()).overlay(new IDrawable[]{new DynamicDrawable(() -> this.getMachineModeIcon(machineModeSyncer.getValue()))})).tooltipBuilder(this::createModeSwitchTooltip);
    }

    protected UITexture getMachineModeIcon(int index) {
        if (index > this.machineModeIcons.size() - 1) {
            return null;
        }
        return this.machineModeIcons.get(index);
    }

    private void createModeSwitchTooltip(RichTooltip t) {
        ((RichTooltip)t.addLine((IDrawable)IKey.dynamic(() -> StatCollector.func_74838_a((String)"GT5U.gui.button.mode_switch")))).addLine((IDrawable)IKey.dynamic(this.base::getMachineModeName));
    }

    protected IWidget createBatchModeButton(PanelSyncManager syncManager) {
        BooleanSyncValue batchModeSyncer = (BooleanSyncValue)syncManager.getSyncHandler("batchMode:0");
        return (IWidget)((ToggleButton)((ToggleButton)new ToggleButton(){

            @NotNull
            public Interactable.Result onMousePressed(int mouseButton) {
                if (!MTEMultiBlockBaseGui.this.base.supportsBatchMode()) {
                    return Interactable.Result.IGNORE;
                }
                return super.onMousePressed(mouseButton);
            }
        }.size(18, 18)).value((IBoolValue)this.getBatchModeSyncValue(batchModeSyncer)).overlay(new IDrawable[]{this.base.supportsBatchMode() ? this.getBatchModeOverlay(batchModeSyncer) : this.getForcedBatchModeOverlay()})).tooltipBuilder(this::createBatchModeTooltip);
    }

    private BooleanSyncValue getBatchModeSyncValue(BooleanSyncValue batchModeSyncer) {
        return new BooleanSyncValue(() -> batchModeSyncer.getValue() != false || !this.base.supportsBatchMode(), bool -> {
            if (this.base.supportsBatchMode()) {
                batchModeSyncer.setValue((Object)bool);
            }
        });
    }

    private IDrawable getBatchModeOverlay(BooleanSyncValue batchModeSyncer) {
        return new DynamicDrawable(() -> batchModeSyncer.getValue() != false ? GTGuiTextures.OVERLAY_BUTTON_BATCH_MODE_ON : GTGuiTextures.OVERLAY_BUTTON_BATCH_MODE_OFF);
    }

    private IDrawable getForcedBatchModeOverlay() {
        UITexture texture = this.base.isBatchModeEnabled() ? GTGuiTextures.OVERLAY_BUTTON_BATCH_MODE_ON_DISABLED : GTGuiTextures.OVERLAY_BUTTON_BATCH_MODE_OFF_DISABLED;
        return new DrawableStack(new IDrawable[]{texture, GTGuiTextures.OVERLAY_BUTTON_FORBIDDEN});
    }

    private void createBatchModeTooltip(RichTooltip t) {
        t.addLine((IDrawable)IKey.lang((String)"GT5U.gui.button.batch_mode"));
        if (!this.base.supportsBatchMode()) {
            t.addLine((IDrawable)IKey.lang((String)"GT5U.gui.button.forbidden"));
        }
    }

    protected IWidget createLockToSingleRecipeButton(PanelSyncManager syncManager) {
        BooleanSyncValue recipeLockSyncer = (BooleanSyncValue)syncManager.getSyncHandler("recipeLock:0");
        return (IWidget)((ToggleButton)((ToggleButton)new ToggleButton(){

            @NotNull
            public Interactable.Result onMousePressed(int mouseButton) {
                if (!MTEMultiBlockBaseGui.this.base.supportsSingleRecipeLocking()) {
                    return Interactable.Result.IGNORE;
                }
                return super.onMousePressed(mouseButton);
            }
        }.size(18, 18)).value((IBoolValue)this.getRecipeLockSyncValue(recipeLockSyncer)).overlay(new IDrawable[]{this.base.supportsSingleRecipeLocking() ? this.getRecipeLockOverlay(recipeLockSyncer) : this.getForcedRecipeLockOverlay()})).tooltipBuilder(this::createRecipeLockTooltip);
    }

    private BooleanSyncValue getRecipeLockSyncValue(BooleanSyncValue recipeLockSyncer) {
        return new BooleanSyncValue(() -> recipeLockSyncer.getValue() != false || !this.base.supportsSingleRecipeLocking(), bool -> {
            if (this.base.supportsSingleRecipeLocking()) {
                recipeLockSyncer.setValue((Object)bool);
            }
        });
    }

    private IDrawable getForcedRecipeLockOverlay() {
        UITexture texture = this.base.mLockedToSingleRecipe ? GTGuiTextures.OVERLAY_BUTTON_RECIPE_LOCKED_DISABLED : GTGuiTextures.OVERLAY_BUTTON_RECIPE_UNLOCKED_DISABLED;
        return new DrawableStack(new IDrawable[]{texture, GTGuiTextures.OVERLAY_BUTTON_FORBIDDEN});
    }

    private IDrawable getRecipeLockOverlay(BooleanSyncValue recipeLockSyncer) {
        return new DynamicDrawable(() -> recipeLockSyncer.getValue() != false ? GTGuiTextures.OVERLAY_BUTTON_RECIPE_LOCKED : GTGuiTextures.OVERLAY_BUTTON_RECIPE_UNLOCKED);
    }

    private void createRecipeLockTooltip(RichTooltip t) {
        t.addLine((IDrawable)IKey.lang((String)"GT5U.gui.button.lock_recipe"));
        if (!this.base.supportsSingleRecipeLocking()) {
            t.addLine((IDrawable)IKey.lang((String)"GT5U.gui.button.forbidden"));
        }
    }

    protected IWidget createPowerPanelButton(PanelSyncManager syncManager, ModularPanel parent) {
        IPanelHandler powerPanel = syncManager.panel("powerPanel", (p_syncManager, syncHandler) -> this.openPowerControlPanel(p_syncManager, parent), true);
        return (IWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().size(18, 18)).rightRel(0.0f, 6, 0.0f)).marginTop(4)).overlay(new IDrawable[]{UITexture.fullImage((String)Mods.GregTech.ID, (String)"gui/overlay_button/power_panel")})).onMousePressed(d -> {
            if (!powerPanel.isPanelOpen()) {
                powerPanel.openPanel();
            } else {
                powerPanel.closePanel();
            }
            return true;
        }).tooltipBuilder(t -> t.addLine((IDrawable)IKey.lang((String)"GT5U.gui.button.power_panel")))).tooltipShowUpTimer(5);
    }

    private ModularPanel openPowerControlPanel(PanelSyncManager syncManager, ModularPanel parent) {
        Area area = parent.getArea();
        int x = area.x + area.width;
        int y = area.y;
        return (ModularPanel)((ModularPanel)((ModularPanel)new ModularPanel("powerPanel").pos(x, y)).size(120, 130)).child((IWidget)((Flow)((Flow)((Flow)((Flow)new Column().sizeRel(1.0f)).padding(3)).child(this.makeTitleTextWidget())).child((IWidget)IKey.lang((String)"GTPP.CC.parallel").asWidget().marginBottom(4))).child(this.makeParallelConfigurator(syncManager)));
    }

    private IWidget makeTitleTextWidget() {
        return (IWidget)((TextWidget)new TextWidget(EnumChatFormatting.UNDERLINE + StatCollector.func_74838_a((String)"GT5U.gui.text.power_panel")).alignment(Alignment.Center).size(120, 18)).marginBottom(4);
    }

    private IWidget makeParallelConfigurator(PanelSyncManager syncManager) {
        IntSyncValue maxParallelSyncer = new IntSyncValue(this.base::getMaxParallelRecipes, this.base::setMaxParallelForPanel);
        BooleanSyncValue alwaysMaxParallelSyncer = new BooleanSyncValue(this.base::isAlwaysMaxParallel, this.base::setAlwaysMaxParallel);
        syncManager.syncValue("maxParallel", (SyncHandler)maxParallelSyncer);
        syncManager.syncValue("alwaysMaxParallel", (SyncHandler)alwaysMaxParallelSyncer);
        IntSyncValue powerPanelMaxParallelSyncer = new IntSyncValue(this.base::getPowerPanelMaxParallel, this.base::setPowerPanelMaxParallel);
        return (IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)new Row().widthRel(1.0f)).height(18)).paddingLeft(3)).paddingRight(3)).mainAxisAlignment(Alignment.MainAxis.CENTER).child((IWidget)((TextFieldWidget)((TextFieldWidget)((TextFieldWidget)((TextFieldWidget)new TextFieldWidget().value((IStringValue)powerPanelMaxParallelSyncer).setTextAlignment(Alignment.Center)).setNumbers(() -> alwaysMaxParallelSyncer.getValue() != false ? maxParallelSyncer.getValue() : 1, () -> ((IntSyncValue)maxParallelSyncer).getValue()).tooltipBuilder(t -> t.addLine((IDrawable)IKey.dynamic(() -> alwaysMaxParallelSyncer.getValue() != false ? StatCollector.func_74837_a((String)"GT5U.gui.text.lockedvalue", (Object[])new Object[]{maxParallelSyncer.getValue()}) : StatCollector.func_74837_a((String)"GT5U.gui.text.rangedvalue", (Object[])new Object[]{1, maxParallelSyncer.getValue()}))))).tooltipShowUpTimer(5)).size(70, 14)).marginBottom(4))).child((IWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().size(18, 18)).overlay(new IDrawable[]{new DynamicDrawable(() -> {
            if (alwaysMaxParallelSyncer.getValue().booleanValue()) {
                return GTGuiTextures.OVERLAY_BUTTON_CHECKMARK;
            }
            return GTGuiTextures.OVERLAY_BUTTON_CROSS;
        })})).onMousePressed(d -> {
            alwaysMaxParallelSyncer.setValue((Object)(alwaysMaxParallelSyncer.getValue() == false ? 1 : 0));
            powerPanelMaxParallelSyncer.setValue((Object)maxParallelSyncer.getValue());
            return true;
        }).tooltipBuilder(t -> t.addLine((IDrawable)IKey.lang((String)"GT5U.gui.button.max_parallel")))).tooltipShowUpTimer(5));
    }

    private IWidget createInventoryRow(ModularPanel panel, PanelSyncManager syncManager) {
        return (IWidget)((Flow)((Flow)((Flow)((Flow)new Row().widthRel(1.0f)).height(76)).alignX(0.0f)).childIf(this.base.doesBindPlayerInventory(), (IWidget)SlotGroupWidget.playerInventory((boolean)false).marginLeft(4))).child((IWidget)this.createButtonColumn(panel, syncManager));
    }

    protected Flow createButtonColumn(ModularPanel panel, PanelSyncManager syncManager) {
        return (Flow)((Flow)((Flow)((Flow)((Flow)new Column().width(18)).leftRel(1.0f, -2, 1.0f)).mainAxisAlignment(Alignment.MainAxis.END).child(this.createStructureUpdateButton(syncManager))).child(this.createPowerSwitchButton())).childIf(this.base.doesBindPlayerInventory(), (IWidget)new ItemSlot().slot(new ModularSlot((IItemHandler)this.base.inventoryHandler, this.base.getControllerSlotIndex()).slotGroup("item_inv")));
    }

    protected IWidget createStructureUpdateButton(PanelSyncManager syncManager) {
        return (IWidget)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().size(18, 18)).syncHandler("structureUpdateButton")).overlay(new IDrawable[]{GTGuiTextures.OVERLAY_BUTTON_STRUCTURE_UPDATE})).tooltipBuilder(t -> t.addLine((IDrawable)IKey.lang((String)"GT5U.gui.button.structure_update")));
    }

    protected IWidget createPowerSwitchButton() {
        return ((ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().syncHandler("powerSwitch")).tooltip(tooltip -> tooltip.add("Power Switch"))).size(18, 18)).marginBottom(4)).overlay(new IDrawable[]{new DynamicDrawable(() -> this.isPowerSwitchDisabled() ? (IDrawable)this.customIcons.get("power_switch_disabled") : (this.baseMetaTileEntity.isAllowedToWork() ? (IDrawable)this.customIcons.get("power_switch_on") : (IDrawable)this.customIcons.get("power_switch_off")))});
    }

    protected boolean isPowerSwitchDisabled() {
        return false;
    }

    protected void registerSyncValues(PanelSyncManager syncManager) {
        syncManager.syncValue("errors", (SyncHandler)new GenericSyncValue(this.base::getStructureErrors, this.base::setStructureErrors, (IByteBufAdapter)new StructureErrorAdapter()));
        syncManager.syncValue("errorID", (SyncHandler)new IntSyncValue(this.base::getErrorDisplayID, this.base::setErrorDisplayID));
        syncManager.syncValue("machineActive", (SyncHandler)new BooleanSyncValue(this.baseMetaTileEntity::isActive, this.baseMetaTileEntity::setActive));
        syncManager.syncValue("wrench", (SyncHandler)new BooleanSyncValue(() -> this.base.mWrench, val -> {
            this.base.mWrench = val;
        }));
        syncManager.syncValue("screwdriver", (SyncHandler)new BooleanSyncValue(() -> this.base.mScrewdriver, val -> {
            this.base.mScrewdriver = val;
        }));
        syncManager.syncValue("softMallet", (SyncHandler)new BooleanSyncValue(() -> this.base.mSoftMallet, val -> {
            this.base.mSoftMallet = val;
        }));
        syncManager.syncValue("hardHammer", (SyncHandler)new BooleanSyncValue(() -> this.base.mHardHammer, val -> {
            this.base.mHardHammer = val;
        }));
        syncManager.syncValue("solderingTool", (SyncHandler)new BooleanSyncValue(() -> this.base.mSolderingTool, val -> {
            this.base.mSolderingTool = val;
        }));
        syncManager.syncValue("crowbar", (SyncHandler)new BooleanSyncValue(() -> this.base.mCrowbar, val -> {
            this.base.mCrowbar = val;
        }));
        syncManager.syncValue("machine", (SyncHandler)new BooleanSyncValue(() -> this.base.mMachine, val -> {
            this.base.mMachine = val;
        }));
        syncManager.syncValue("totalRunTime", (SyncHandler)new LongSyncValue(this.base::getTotalRunTime, this.base::setTotalRunTime));
        syncManager.syncValue("lastWorkingTick", (SyncHandler)new LongSyncValue(this.base::getLastWorkingTick, this.base::setLastWorkingTick));
        BooleanSyncValue wasShutDown = new BooleanSyncValue(this.baseMetaTileEntity::wasShutdown, this.baseMetaTileEntity::setShutdownStatus);
        syncManager.syncValue("wasShutdown", (SyncHandler)wasShutDown);
        syncManager.syncValue("shutdownReason", (SyncHandler)new GenericSyncValue(this.baseMetaTileEntity::getLastShutDownReason, this.baseMetaTileEntity::setShutDownReason, (IByteBufAdapter)new ShutdownReasonAdapter()));
        syncManager.syncValue("checkRecipeResult", (SyncHandler)new GenericSyncValue(this.base::getCheckRecipeResult, this.base::setCheckRecipeResult, (IByteBufAdapter)new CheckRecipeResultAdapter()));
        syncManager.syncValue("fluidOutput", (SyncHandler)new GenericListSyncHandler(() -> this.base.mOutputFluids != null ? Arrays.stream(this.base.mOutputFluids).map(fluidStack -> {
            if (fluidStack == null) {
                return null;
            }
            return new FluidStack((FluidStack)fluidStack, fluidStack.amount){

                public boolean isFluidEqual(FluidStack other) {
                    return super.isFluidEqual(other) && this.amount == other.amount;
                }
            };
        }).collect(Collectors.toList()) : Collections.emptyList(), val -> {
            this.base.mOutputFluids = val.toArray(new FluidStack[0]);
        }, NetworkUtils::readFluidStack, NetworkUtils::writeFluidStack, null, null));
        syncManager.syncValue("itemOutput", (SyncHandler)new GenericListSyncHandler(() -> this.base.mOutputItems != null ? Arrays.asList(this.base.mOutputItems) : Collections.emptyList(), val -> {
            this.base.mOutputItems = val.toArray(new ItemStack[0]);
        }, NetworkUtils::readItemStack, NetworkUtils::writeItemStack, null, null));
        syncManager.syncValue("progressTime", (SyncHandler)new IntSyncValue(() -> this.base.mProgresstime, val -> {
            this.base.mProgresstime = val;
        }));
        syncManager.syncValue("maxProgressTime", (SyncHandler)new IntSyncValue(() -> this.base.mMaxProgresstime, val -> {
            this.base.mMaxProgresstime = val;
        }));
        StringSyncValue recipeInfoSyncer = new StringSyncValue(this.base::generateCurrentRecipeInfoString);
        syncManager.syncValue("recipeInfo", (SyncHandler)recipeInfoSyncer);
        BooleanSyncValue powerSwitchSyncer = new BooleanSyncValue(this.base::isAllowedToWork, bool -> {
            if (this.isPowerSwitchDisabled()) {
                return;
            }
            if (bool) {
                this.base.enableWorking();
            } else if (this.base.maxProgresstime() > 0) {
                this.base.disableWorking();
            } else {
                this.base.stopMachine(ShutDownReasonRegistry.NONE);
            }
        });
        syncManager.syncValue("powerSwitch", (SyncHandler)powerSwitchSyncer);
        IntSyncValue structureUpdateSyncer = new IntSyncValue(this.base::getStructureUpdateTime, this.base::setStructureUpdateTime);
        BooleanSyncValue structureUpdateButtonSyncer = new BooleanSyncValue(() -> structureUpdateSyncer.getValue() > -20, val -> {
            if (val) {
                structureUpdateSyncer.setValue((Object)1);
            }
        });
        syncManager.syncValue("structureUpdate", (SyncHandler)structureUpdateSyncer);
        syncManager.syncValue("structureUpdateButton", (SyncHandler)structureUpdateButtonSyncer);
        BooleanSyncValue recipeLockSyncer = new BooleanSyncValue(this.base::isRecipeLockingEnabled, this.base::setRecipeLocking);
        syncManager.syncValue("recipeLock", (SyncHandler)recipeLockSyncer);
        BooleanSyncValue batchModeSyncer = new BooleanSyncValue(this.base::isBatchModeEnabled, this.base::setBatchMode);
        syncManager.syncValue("batchMode", (SyncHandler)batchModeSyncer);
        IntSyncValue machineModeSyncer = new IntSyncValue(this.base::getMachineMode, this.base::setMachineMode);
        syncManager.syncValue("machineMode", (SyncHandler)machineModeSyncer);
        BooleanSyncValue inputSeparationSyncer = new BooleanSyncValue(this.base::isInputSeparationEnabled, this.base::setInputSeparation);
        syncManager.syncValue("inputSeparation", (SyncHandler)inputSeparationSyncer);
        IntSyncValue voidExcessSyncer = new IntSyncValue(() -> this.base.getVoidingMode().ordinal(), val -> {
            if (this.base.supportsVoidProtection()) {
                this.base.setVoidingMode(VoidingMode.fromOrdinal(val));
            }
        });
        syncManager.syncValue("voidExcess", (SyncHandler)voidExcessSyncer);
        syncManager.registerSlotGroup("item_inv", 1);
    }

    protected void setMachineModeIcons() {
    }
}

