/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.hazards;

import gregtech.api.enchants.EnchantmentHazmat;
import gregtech.api.hazards.Hazard;
import gregtech.api.hazards.IHazardProtector;
import java.util.Map;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HazardProtection {
    public static boolean isWearingFullFrostHazmat(@NotNull EntityLivingBase entity) {
        return HazardProtection.isWearingFullHazmatAgainst(entity, Hazard.FROST);
    }

    public static boolean isWearingFullHeatHazmat(@NotNull EntityLivingBase entity) {
        return HazardProtection.isWearingFullHazmatAgainst(entity, Hazard.HEAT);
    }

    public static boolean isWearingFullBioHazmat(@NotNull EntityLivingBase entity) {
        return HazardProtection.isWearingFullHazmatAgainst(entity, Hazard.BIOLOGICAL);
    }

    public static boolean isWearingFullRadioHazmat(@NotNull EntityLivingBase entity) {
        return HazardProtection.isWearingFullHazmatAgainst(entity, Hazard.RADIOLOGICAL);
    }

    public static boolean isWearingFullElectroHazmat(@NotNull EntityLivingBase entity) {
        return HazardProtection.isWearingFullHazmatAgainst(entity, Hazard.ELECTRICAL);
    }

    public static boolean isWearingFullGasHazmat(@NotNull EntityLivingBase entity) {
        return HazardProtection.isWearingFullHazmatAgainst(entity, Hazard.GAS);
    }

    public static boolean isWearingFullHazmatAgainst(@NotNull EntityLivingBase entity, @NotNull Hazard hazard) {
        for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
            ItemStack stack = entity.func_71124_b(i);
            if (HazardProtection.protectsAgainstHazard(stack, hazard)) continue;
            return false;
        }
        return true;
    }

    public static boolean protectsAgainstHazard(@Nullable ItemStack stack, @NotNull Hazard hazard) {
        IHazardProtector hazardProtector;
        Item item;
        return stack != null && (HazardProtection.hasHazmatEnchant(stack) || (item = stack.func_77973_b()) instanceof IHazardProtector && (hazardProtector = (IHazardProtector)item).protectsAgainst(stack, hazard));
    }

    public static boolean providesFullHazmatProtection(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        for (Hazard hazard : Hazard.values()) {
            if (HazardProtection.protectsAgainstHazard(stack, hazard)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasHazmatEnchant(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Map tEnchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        Integer level = (Integer)tEnchantments.get(EnchantmentHazmat.INSTANCE.field_77352_x);
        return level != null && level >= 1;
    }
}

