/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import goodgenerator.api.recipe.GoodGeneratorRecipeMaps;
import goodgenerator.blocks.tileEntity.GTMetaTileEntity.MTENeutronAccelerator;
import goodgenerator.blocks.tileEntity.GTMetaTileEntity.MTENeutronSensor;
import goodgenerator.blocks.tileEntity.base.MTETooltipMultiBlockBaseEM;
import goodgenerator.loader.Loaders;
import goodgenerator.util.DescTextLocalization;
import goodgenerator.util.ItemRefer;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.objects.XSTR;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import tectech.thing.metaTileEntity.multi.base.INameFunction;
import tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import tectech.thing.metaTileEntity.multi.base.LedStatus;
import tectech.thing.metaTileEntity.multi.base.Parameters;

public class MTENeutronActivator
extends MTETooltipMultiBlockBaseEM
implements IConstructable,
ISurvivalConstructable {
    public Parameters.Group.ParameterIn batchSetting;
    public static final INameFunction<MTENeutronActivator> BATCH_SETTING_NAME = (base, p) -> StatCollector.func_74838_a((String)"batch_mode.cfgi.0");
    public static final IStatusFunction<MTENeutronActivator> BATCH_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary(p.get(), 1.0, 0.0, 32.0, 128.0, new double[0]);
    protected static IStructureDefinition<MTENeutronActivator> multiDefinition = null;
    protected final ArrayList<MTENeutronAccelerator> mNeutronAccelerator = new ArrayList();
    protected final ArrayList<MTENeutronSensor> mNeutronSensor = new ArrayList();
    protected int casingAmount = 0;
    protected int height = 0;
    protected int eV = 0;
    protected int mCeil = 0;
    protected int mFloor = 0;
    protected static final NumberFormatMUI numberFormat = new NumberFormatMUI();
    final XSTR R = new XSTR();
    private static final IIconContainer textureFontOn;
    private static final IIconContainer textureFontOn_Glow;
    private static final IIconContainer textureFontOff;
    private static final IIconContainer textureFontOff_Glow;
    protected final String NA_BOTTOM = this.mName + "buttom";
    protected final String NA_MID = this.mName + "mid";
    protected final String NA_TOP = this.mName + "top";

    public MTENeutronActivator(String name) {
        super(name);
    }

    public MTENeutronActivator(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected OverclockCalculator createOverclockCalculator(@NotNull GTRecipe recipe) {
                return OverclockCalculator.ofNoOverclock(recipe).setDuration((int)Math.ceil((double)recipe.mDuration * GTUtility.powInt((double)0.9f, MTENeutronActivator.this.height - 4))).setDurationUnderOneTickSupplier(() -> (double)recipe.mDuration * GTUtility.powInt((double)0.9f, MTENeutronActivator.this.height - 4));
            }

            @Override
            @NotNull
            public CheckRecipeResult process() {
                CheckRecipeResult result = super.process();
                if (!result.wasSuccessful()) {
                    return result;
                }
                MTENeutronActivator.this.mFloor = this.lastRecipe.mSpecialValue % 10000 * 1000000;
                MTENeutronActivator.this.mCeil = this.lastRecipe.mSpecialValue / 10000 * 1000000;
                if (MTENeutronActivator.this.eV > MTENeutronActivator.this.mCeil || MTENeutronActivator.this.eV < MTENeutronActivator.this.mFloor) {
                    this.overwriteOutputItems(ItemRefer.Radioactive_Waste.get(4));
                }
                this.calculatedEut = 0L;
                return result;
            }
        };
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(Long.MAX_VALUE);
        logic.setAvailableAmperage(1L);
        logic.setUnlimitedTierSkips();
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (this.getMaxBatchSize() == 1) {
            this.parametrization.trySetParameters(this.batchSetting.hatchId(), this.batchSetting.parameterId(), 128.0);
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
        } else {
            this.parametrization.trySetParameters(this.batchSetting.hatchId(), this.batchSetting.parameterId(), 1.0);
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
        }
        return true;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.eV = aNBT.func_74762_e("mKeV");
        this.mCeil = aNBT.func_74762_e("mCeil");
        this.mFloor = aNBT.func_74762_e("mFloor");
        this.height = aNBT.func_74762_e("height");
        super.loadNBTData(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mKeV", this.eV);
        aNBT.func_74768_a("mCeil", this.mCeil);
        aNBT.func_74768_a("mFloor", this.mFloor);
        aNBT.func_74768_a("height", this.height);
        super.saveNBTData(aNBT);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GoodGeneratorRecipeMaps.neutronActivatorRecipes;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Neutron Activator, NA").addInfo("Superluminal-velocity Motion.").addInfo("The minimum height of the Speeding Pipe Casing is 4.").addInfo("Per extra Speeding Pipe Casing will give time discount.").addInfo("But it will reduce the Neutron Accelerator efficiency.").addInfo("You need to input energy to the Neutron Accelerator to get it running.").addInfo("It will output correct products with Specific Neutron Kinetic Energy.").addInfo("Otherwise it will output trash.").addInfo("The Neutron Kinetic Energy will decrease 72KeV/s when no Neutron Accelerator is running.").addInfo("It will explode when the Neutron Kinetic Energy is over" + EnumChatFormatting.RED + " 1200MeV" + EnumChatFormatting.GRAY + ".").addInfo("Inputting Graphite/Beryllium dust can reduce 10MeV per dust immediately.").addController("Front bottom").addCasingInfoRange("Clean Stainless Steel Machine Casing", 7, 31, false).addCasingInfoExactly("Processor Machine Casing", 18, false).addCasingInfoMin("Steel Frame Box", 16, false).addCasingInfoMin("Speeding Pipe Casing", 4, false).addCasingInfoMin("EV+ Glass", 32, false).addInputHatch("Hint block with dot 1").addInputBus("Hint block with dot 1").addOutputHatch("Hint block with dot 2").addOutputBus("Hint block with dot 2").addMaintenanceHatch("Hint block with dot 2").addOtherStructurePart("Neutron Accelerator", "Hint block with dot 2").addOtherStructurePart("Neutron Sensor", "Hint block with dot 2").toolTipFinisher(new String[0]);
        return tt;
    }

    public IStructureDefinition<MTENeutronActivator> getStructure_EM() {
        if (multiDefinition == null) {
            multiDefinition = StructureDefinition.builder().addShape(this.NA_TOP, StructureUtility.transpose((String[][])new String[][]{{"CCCCC", "CDDDC", "CDDDC", "CDDDC", "CCCCC"}})).addShape(this.NA_MID, StructureUtility.transpose((String[][])new String[][]{{"F   F", " GGG ", " GPG ", " GGG ", "F   F"}})).addShape(this.NA_BOTTOM, StructureUtility.transpose((String[][])new String[][]{{"XX~XX", "XDDDX", "XDDDX", "XDDDX", "XXXXX"}})).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTENeutronActivator.class).atLeast(HatchElement.InputHatch, HatchElement.InputBus, HatchElement.Maintenance).casingIndex(49).dot(1).build(), StructureUtility.onElementPass(MTENeutronActivator::onCasingFound, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1))})).addElement('D', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)6)).addElement('F', GTStructureUtility.ofFrame(Materials.Steel)).addElement('G', GTStructureUtility.chainAllGlasses()).addElement('P', StructureUtility.ofBlock((Block)Loaders.speedingPipe, (int)0)).addElement('X', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTENeutronActivator.class).atLeast(HatchElement.OutputHatch, HatchElement.OutputBus, HatchElement.Maintenance, NeutronHatchElement.NeutronAccelerator, NeutronHatchElement.NeutronSensor).casingIndex(49).dot(2).build(), StructureUtility.onElementPass(MTENeutronActivator::onCasingFound, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1))})).build();
        }
        return multiDefinition;
    }

    @Override
    protected void clearHatches_EM() {
        super.clearHatches_EM();
        this.mNeutronAccelerator.clear();
        this.mNeutronSensor.clear();
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.casingAmount = 0;
        if (!this.structureCheck_EM(this.NA_BOTTOM, 2, 0, 0)) {
            return false;
        }
        this.height = 0;
        while (this.structureCheck_EM(this.NA_MID, 2, this.height + 1, 0)) {
            ++this.height;
        }
        if (this.height < 4) {
            return false;
        }
        return this.structureCheck_EM(this.NA_TOP, 2, this.height + 1, 0) && this.casingAmount >= 7;
    }

    public final boolean addAcceleratorAndSensor(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof MTENeutronAccelerator) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mNeutronAccelerator.add((MTENeutronAccelerator)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof MTENeutronSensor) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mNeutronSensor.add((MTENeutronSensor)aMetaTileEntity);
        }
        return false;
    }

    public int maxNeutronKineticEnergy() {
        return 1200000000;
    }

    public int getCurrentNeutronKineticEnergy() {
        return this.eV;
    }

    @Override
    protected void parametersInstantiation_EM() {
        this.batchSetting = this.parametrization.getGroup(9, true).makeInParameter(1, 1.0, BATCH_SETTING_NAME, BATCH_STATUS);
    }

    @Override
    protected int getMaxBatchSize() {
        return (int)Math.min(Math.max(this.batchSetting.get(), 1.0), 128.0);
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean getDefaultBatchMode() {
        return true;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTENeutronActivator(this.mName);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        boolean anyWorking = false;
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.eV > 0 && (aTick % 20L == 0L || this.eV > this.mCeil)) {
                this.tryUseModerator();
            }
            for (MTENeutronAccelerator mTENeutronAccelerator : this.mNeutronAccelerator) {
                if (!mTENeutronAccelerator.getBaseMetaTileEntity().isActive() || this.getRepairStatus() != this.getIdealStatus()) continue;
                anyWorking = true;
                this.eV = (int)((double)this.eV + Math.max((double)((this.R.nextInt(mTENeutronAccelerator.getMaxEUConsume() + 1) + mTENeutronAccelerator.getMaxEUConsume()) * 10) * GTUtility.powInt(0.95, this.height - 4), 10.0));
            }
            if (!anyWorking) {
                if (this.eV >= 72000 && aTick % 20L == 0L) {
                    this.eV -= 72000;
                } else if (this.eV > 0 && aTick % 20L == 0L) {
                    this.eV = 0;
                }
            }
            if (this.eV < 0) {
                this.eV = 0;
            }
            if (this.eV > this.maxNeutronKineticEnergy()) {
                this.doExplosion(128L);
            }
            for (MTENeutronSensor mTENeutronSensor : this.mNeutronSensor) {
                mTENeutronSensor.updateRedstoneOutput(this.eV);
            }
            if (this.mProgresstime < this.mMaxProgresstime && (this.eV > this.mCeil || this.eV < this.mFloor)) {
                this.mOutputFluids = null;
                this.mOutputItems = new ItemStack[]{ItemRefer.Radioactive_Waste.get(4)};
            }
        }
    }

    private void tryUseModerator() {
        this.startRecipeProcessing();
        for (ItemStack input : this.getStoredInputs()) {
            if (!input.func_77969_a(Materials.Graphite.getDust(1)) && !input.func_77969_a(Materials.Beryllium.getDust(1))) continue;
            int consume = Math.min(this.eV / 10000000, input.field_77994_a);
            this.depleteInput(GTUtility.copyAmount(consume, input));
            this.eV -= 10000000 * consume;
        }
        this.endRecipeProcessing();
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        int heights;
        this.structureBuild_EM(this.NA_BOTTOM, 2, 0, 0, stackSize, hintsOnly);
        this.structureBuild_EM(this.NA_TOP, 2, heights + 1, 0, stackSize, hintsOnly);
        for (heights = stackSize.field_77994_a + 3; heights > 0; --heights) {
            this.structureBuild_EM(this.NA_MID, 2, heights, 0, stackSize, hintsOnly);
        }
    }

    @Override
    public String[] getStructureDescription(ItemStack itemStack) {
        return DescTextLocalization.addText("NeutronActivator.hint", 7);
    }

    @Override
    public String[] getInfoData() {
        int currentNKEInput = 0;
        boolean anyWorking = false;
        for (MTENeutronAccelerator tHatch : this.mNeutronAccelerator) {
            if (!tHatch.getBaseMetaTileEntity().isActive()) continue;
            currentNKEInput = (int)((double)currentNKEInput + (double)((this.R.nextInt(tHatch.getMaxEUConsume() + 1) + tHatch.getMaxEUConsume()) * 10) * GTUtility.powInt(0.95, this.height - 4));
            anyWorking = true;
        }
        if (!anyWorking) {
            currentNKEInput = -72000;
        }
        return new String[]{StatCollector.func_74837_a((String)"gg.scanner.info.neutron_activator.progress", (Object[])new Object[]{EnumChatFormatting.GREEN + Integer.toString(this.mProgresstime / 20) + EnumChatFormatting.RESET, EnumChatFormatting.YELLOW + Integer.toString(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET}), StatCollector.func_74837_a((String)"gg.scanner.info.neutron_activator.input", (Object[])new Object[]{EnumChatFormatting.GREEN + GTUtility.formatNumbers(currentNKEInput) + EnumChatFormatting.RESET}), StatCollector.func_74838_a((String)"scanner.info.NA") + " " + EnumChatFormatting.LIGHT_PURPLE + GTUtility.formatNumbers(this.getCurrentNeutronKineticEnergy()) + EnumChatFormatting.RESET + "eV"};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49), TextureFactory.builder().addIcon(textureFontOn).extFacing().build(), TextureFactory.builder().addIcon(textureFontOn_Glow).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49), TextureFactory.builder().addIcon(textureFontOff).extFacing().build(), TextureFactory.builder().addIcon(textureFontOff_Glow).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49)};
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int built = this.survivalBuildPiece(this.NA_BOTTOM, stackSize, 2, 0, 0, elementBudget, env, false, true);
        if (built >= 0) {
            return built;
        }
        int heights = stackSize.field_77994_a + 3;
        for (int i = 1; i <= heights; ++i) {
            built = this.survivalBuildPiece(this.NA_MID, stackSize, 2, i, 0, elementBudget, env, false, true);
            if (built < 0) continue;
            return built;
        }
        return this.survivalBuildPiece(this.NA_TOP, stackSize, 2, heights + 1, 0, elementBudget, env, false, true);
    }

    protected void onCasingFound() {
        ++this.casingAmount;
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)((Column)screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"gui.NeutronActivator.0")).setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getErrorDisplayID() == 0))).widget(new TextWidget().setStringSupplier(() -> numberFormat.format((double)this.eV / 1000000.0) + " MeV").setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getErrorDisplayID() == 0))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.eV, val -> {
            this.eV = val;
        }));
    }

    static {
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        textureFontOn = new Textures.BlockIcons.CustomIcon("icons/NeutronActivator_On");
        textureFontOn_Glow = new Textures.BlockIcons.CustomIcon("icons/NeutronActivator_On_GLOW");
        textureFontOff = new Textures.BlockIcons.CustomIcon("icons/NeutronActivator_Off");
        textureFontOff_Glow = new Textures.BlockIcons.CustomIcon("icons/NeutronActivator_Off_GLOW");
    }

    private static enum NeutronHatchElement implements IHatchElement<MTENeutronActivator>
    {
        NeutronSensor(MTENeutronActivator::addAcceleratorAndSensor, new Class[]{MTENeutronSensor.class}){

            @Override
            public long count(MTENeutronActivator t) {
                return t.mNeutronSensor.size();
            }
        }
        ,
        NeutronAccelerator(MTENeutronActivator::addAcceleratorAndSensor, new Class[]{MTENeutronAccelerator.class}){

            @Override
            public long count(MTENeutronActivator t) {
                return t.mNeutronAccelerator.size();
            }
        };

        private final List<Class<? extends IMetaTileEntity>> mteClasses;
        private final IGTHatchAdder<MTENeutronActivator> adder;

        @SafeVarargs
        private NeutronHatchElement(IGTHatchAdder<MTENeutronActivator> adder, Class<? extends IMetaTileEntity> ... mteClasses) {
            this.mteClasses = Collections.unmodifiableList(Arrays.asList(mteClasses));
            this.adder = adder;
        }

        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return this.mteClasses;
        }

        @Override
        public IGTHatchAdder<? super MTENeutronActivator> adder() {
            return this.adder;
        }
    }
}

