/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import bartworks.common.loaders.ItemRegistry;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import goodgenerator.blocks.structures.AntimatterStructures;
import goodgenerator.loader.Loaders;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.misc.WirelessNetworkManager;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kekztech.client.gui.KTUITextures;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import tectech.thing.metaTileEntity.hatch.MTEHatchDynamoTunnel;

public class AntimatterGenerator
extends MTEExtendedPowerMultiBlockBase
implements IConstructable,
ISurvivalConstructable {
    public static final String MAIN_NAME = "antimatterGenerator";
    protected IStructureDefinition<AntimatterGenerator> multiDefinition = null;
    protected int times = 1;
    private UUID owner_uuid;
    private boolean wirelessEnabled = false;
    private boolean canUseWireless = true;
    private long euLastCycle = 0L;
    private float annihilationEfficiency = 0.0f;
    public static final long ANTIMATTER_FUEL_VALUE = 1000000000000L;
    private final List<Float> avgEff = new ArrayList<Float>(10);
    private static final ClassValue<IStructureDefinition<AntimatterGenerator>> STRUCTURE_DEFINITION = new ClassValue<IStructureDefinition<AntimatterGenerator>>(){

        @Override
        protected IStructureDefinition<AntimatterGenerator> computeValue(Class<?> type) {
            return StructureDefinition.builder().addShape(AntimatterGenerator.MAIN_NAME, AntimatterStructures.ANTIMATTER_GENERATOR).addElement('F', (IStructureElement)StructureUtility.lazy(x -> GTStructureUtility.ofFrame(Materials.Naquadria))).addElement('D', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofBlock((Block)x.getCasingBlock(1), (int)x.getCasingMeta(1)))).addElement('G', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofBlock((Block)x.getCoilBlock(1), (int)x.getCoilMeta(1)))).addElement('B', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofBlock((Block)x.getCoilBlock(2), (int)x.getCoilMeta(2)))).addElement('C', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofBlock((Block)x.getCasingBlock(2), (int)x.getCasingMeta(2)))).addElement('A', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofBlock((Block)x.getGlassBlock(), (int)x.getGlassMeta()))).addElement('E', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)1))).addElement('H', (IStructureElement)StructureUtility.lazy(x -> HatchElementBuilder.builder().anyOf(HatchElement.ExoticEnergy).adder((rec$, x$0, x$1) -> ((AntimatterGenerator)rec$).addLaserSource(x$0, x$1)).casingIndex(x.textureIndex(2)).dot(2).buildAndChain(x.getCasingBlock(2), x.getCasingMeta(2)))).addElement('I', (IStructureElement)StructureUtility.lazy(x -> GTStructureUtility.buildHatchAdder(AntimatterGenerator.class).atLeast(HatchElement.InputHatch).casingIndex(x.textureIndex(1)).dot(1).buildAndChain(x.getCasingBlock(1), x.getCasingMeta(1)))).build();
        }
    };
    private int n = 0;
    protected long energyProducedCache;
    protected float efficiencyCache;
    protected float avgEffCache;
    protected static final NumberFormatMUI numberFormat = new NumberFormatMUI();
    protected static DecimalFormat standardFormat;

    private boolean addLaserSource(IGregTechTileEntity aBaseMetaTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchDynamoTunnel) {
            MTEHatchDynamoTunnel tHatch = (MTEHatchDynamoTunnel)aMetaTileEntity;
            tHatch.updateTexture(aBaseCasingIndex);
            return this.mExoticEnergyHatches.add(tHatch);
        }
        return false;
    }

    public AntimatterGenerator(String name) {
        super(name);
    }

    public AntimatterGenerator(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    @Override
    public boolean supportsPowerPanel() {
        return false;
    }

    @Override
    public CheckRecipeResult checkProcessing() {
        int i;
        this.startRecipeProcessing();
        ArrayList<FluidStack> inputFluids = this.getStoredFluids();
        long containedAntimatter = 0L;
        FluidStack catalystFluid = null;
        for (i = 0; i < inputFluids.size(); ++i) {
            FluidStack inputFluid = (FluidStack)inputFluids.get(i);
            if (inputFluid.isFluidEqual(MaterialsUEVplus.Antimatter.getFluid(1L))) {
                containedAntimatter += (long)inputFluid.amount;
            } else {
                catalystFluid = inputFluid.copy();
            }
            inputFluid.amount = 0;
        }
        if (i == 2 && containedAntimatter > 0L && catalystFluid != null) {
            this.createEU(containedAntimatter, catalystFluid);
        }
        if (containedAntimatter == 0L && catalystFluid != null || containedAntimatter > 0L && catalystFluid == null) {
            this.annihilationEfficiency = 0.0f;
            this.euLastCycle = 0L;
            this.setAvgEff(0.0f);
        }
        this.endRecipeProcessing();
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    public void createEU(long antimatter, FluidStack catalyst) {
        float efficiency;
        Float modifier = null;
        if (catalyst.isFluidEqual(Materials.Copper.getMolten(1L))) {
            modifier = Float.valueOf(1.0f);
        } else if (catalyst.isFluidEqual(Materials.SuperconductorUIVBase.getMolten(1L))) {
            modifier = Float.valueOf(1.02f);
        } else if (catalyst.isFluidEqual(Materials.SuperconductorUMVBase.getMolten(1L))) {
            modifier = Float.valueOf(1.03f);
        }
        long catalystCount = catalyst.amount;
        long generatedEU = 0L;
        if (modifier == null) {
            this.annihilationEfficiency = 0.0f;
            this.euLastCycle = 0L;
            this.setAvgEff(0.0f);
            return;
        }
        this.annihilationEfficiency = efficiency = Math.min((float)antimatter / (float)catalystCount, (float)catalystCount / (float)antimatter);
        this.setAvgEff(efficiency);
        generatedEU = (long)(Math.pow(antimatter, modifier.floatValue()) * 1.0E12 * (double)efficiency);
        if (this.wirelessEnabled && modifier.floatValue() >= 1.03f) {
            long euCapacity = 0L;
            for (MTEHatch tHatch : this.getExoticEnergyHatches()) {
                if (!(tHatch instanceof MTEHatchDynamoTunnel)) continue;
                MTEHatchDynamoTunnel tLaserSource = (MTEHatchDynamoTunnel)tHatch;
                euCapacity += tLaserSource.maxEUStore();
            }
            if (generatedEU < 0L) {
                generatedEU = Long.MAX_VALUE;
            }
            if (euCapacity < 0L) {
                euCapacity = Long.MAX_VALUE;
            }
            this.euLastCycle = generatedEU = Math.min(generatedEU, euCapacity);
            WirelessNetworkManager.addEUToGlobalEnergyMap(this.owner_uuid, generatedEU);
        } else {
            this.euLastCycle = generatedEU;
            float invHatchCount = 1.0f / (float)this.mExoticEnergyHatches.size();
            for (MTEHatch tHatch : this.getExoticEnergyHatches()) {
                if (!(tHatch instanceof MTEHatchDynamoTunnel)) continue;
                MTEHatchDynamoTunnel tLaserSource = (MTEHatchDynamoTunnel)tHatch;
                tLaserSource.setEUVar(tLaserSource.getEUVar() + (long)((float)generatedEU * invHatchCount));
            }
        }
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.checkPiece(MAIN_NAME, 17, 41, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int realBudget = elementBudget >= 200 ? elementBudget : Math.min(200, elementBudget * 5);
        return this.survivalBuildPiece(MAIN_NAME, stackSize, 17, 41, 0, realBudget, env, false, true);
    }

    public void construct(ItemStack itemStack, boolean hintsOnly) {
        this.buildPiece(MAIN_NAME, itemStack, hintsOnly, 17, 41, 0);
    }

    @Override
    public void saveNBTData(NBTTagCompound nbt) {
        nbt.func_74757_a("wirelessEnabled", this.wirelessEnabled);
        super.saveNBTData(nbt);
    }

    @Override
    public void loadNBTData(NBTTagCompound nbt) {
        this.wirelessEnabled = nbt.func_74767_n("wirelessEnabled");
        super.loadNBTData(nbt);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new AntimatterGenerator(MAIN_NAME);
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        this.wirelessEnabled = !this.wirelessEnabled;
        GTUtility.sendChatToPlayer(aPlayer, "Wireless network mode " + (this.wirelessEnabled ? "enabled." : "disabled."));
        if (this.wirelessEnabled) {
            GTUtility.sendChatToPlayer(aPlayer, "Wireless only works with UMV Superconductor Base or better.");
        }
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && aTick == 1L) {
            this.owner_uuid = aBaseMetaTileEntity.getOwnerUuid();
            WirelessNetworkManager.strongCheckOrAddUser(this.owner_uuid);
        }
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Antimatter Generator, SLAM").addInfo("Annihilating Antimatter like it's 2205!").addSeparator().addInfo("Generates energy by reacting " + EnumChatFormatting.DARK_AQUA + "Semi-Stable Antimatter" + EnumChatFormatting.GRAY + " with " + EnumChatFormatting.GOLD + "Matter").addInfo("Annihilation uses an equal amount of " + EnumChatFormatting.DARK_AQUA + "Antimatter" + EnumChatFormatting.GRAY + " and " + EnumChatFormatting.GOLD + "Matter").addInfo("Consumes " + EnumChatFormatting.GOLD + "all inputs" + EnumChatFormatting.GRAY + " every processing cycle").addInfo(EnumChatFormatting.RED + "Voids any invalid fluid!").addInfo("A cycle lasts 1 tick").addInfo("Imbalance between " + EnumChatFormatting.DARK_AQUA + "Antimatter" + EnumChatFormatting.GRAY + " and " + EnumChatFormatting.GOLD + "Matter" + EnumChatFormatting.RED + " will decrease efficiency!" + EnumChatFormatting.GRAY).addInfo("Efficiency formula: Min(" + EnumChatFormatting.DARK_AQUA + "Antimatter" + EnumChatFormatting.GRAY + "/" + EnumChatFormatting.GOLD + "Matter" + EnumChatFormatting.GRAY + ", " + EnumChatFormatting.GOLD + "Matter" + EnumChatFormatting.GRAY + "/" + EnumChatFormatting.DARK_AQUA + "Antimatter" + EnumChatFormatting.GRAY + ")").addInfo("Any excess EU generated will be " + EnumChatFormatting.RED + "voided!" + EnumChatFormatting.GRAY).addSeparator().addInfo("Energy production formula: " + EnumChatFormatting.GREEN + EnumChatFormatting.BOLD + EnumChatFormatting.UNDERLINE + "A" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + "*(" + EnumChatFormatting.DARK_AQUA + "Antimatter" + EnumChatFormatting.GRAY + ")^" + EnumChatFormatting.GOLD + EnumChatFormatting.BOLD + EnumChatFormatting.UNDERLINE + "E" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + " EU/Cycle").addInfo("Cannot produce more than " + GTUtility.formatNumbers(9.2E18) + " EU per cycle").addInfo("" + EnumChatFormatting.GREEN + EnumChatFormatting.BOLD + EnumChatFormatting.UNDERLINE + "A" + EnumChatFormatting.RESET + EnumChatFormatting.GREEN + "ntimatter energy" + EnumChatFormatting.GRAY + " base value : " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(1000000000000L) + EnumChatFormatting.GRAY + " EU/L").addInfo("" + EnumChatFormatting.GOLD + EnumChatFormatting.BOLD + EnumChatFormatting.UNDERLINE + "E" + EnumChatFormatting.RESET + EnumChatFormatting.GOLD + "nergy production boost" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + ":").addInfo("1. Molten Copper: " + EnumChatFormatting.GOLD + "1.00").addInfo("2. Molten Superconductor Base UIV: " + EnumChatFormatting.GOLD + "1.02").addInfo("3. Molten Superconductor Base UMV: " + EnumChatFormatting.GOLD + "1.03").addSeparator().addInfo("Switch the power destination to your wireless network with a screwdriver").addInfo("Wireless mode requires Superconductor Base UMV to work").addInfo("Wireless mode uses hatch capacity limit").beginStructureBlock(35, 43, 35, false).addCasingInfoMin("Transcendentally Reinforced Borosilicate Glass", 1008, false).addCasingInfoMin("Magnetic Flux Casing", 4122, false).addCasingInfoMin("Gravity Stabilization Casing", 2418, false).addCasingInfoMin("Protomatter Activation Coil", 32, false).addCasingInfoMin("Antimatter Annihilation Matrix", 600, false).addCasingInfoMin("Naquadria Frame Box", 293, false).addCasingInfoMin("Advanced Filter Casing", 209, false).addInputHatch("2, Hint block with dot 1", 1).addOtherStructurePart(StatCollector.func_74838_a((String)"gg.structure.tooltip.laser_source_hatch"), "1-64, Hint Block with dot 2", 2).toolTipFinisher(new String[0]);
        return tt;
    }

    protected boolean canUseWireless() {
        return true;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                this.canUseWireless = this.canUseWireless();
            }
            if (this.canUseWireless) {
                this.wirelessEnabled = !this.wirelessEnabled;
            }
        }).setPlayClickSound(true).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(GTUITextures.BUTTON_STANDARD);
            if (this.canUseWireless) {
                if (this.wirelessEnabled) {
                    ret.add(KTUITextures.OVERLAY_BUTTON_WIRELESS_ON);
                } else {
                    ret.add(KTUITextures.OVERLAY_BUTTON_WIRELESS_OFF);
                }
            } else {
                ret.add(KTUITextures.OVERLAY_BUTTON_WIRELESS_OFF_DISABLED);
            }
            return ret.toArray(new IDrawable[0]);
        }).setPos(80, 91).setSize(16, 16).addTooltip(StatCollector.func_74838_a((String)"gui.kekztech_lapotronicenergyunit.wireless")).setTooltipShowUpDelay(5))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.wirelessEnabled, val -> {
            this.wirelessEnabled = val;
        }))).widget((Widget)new FakeSyncWidget.BooleanSyncer(this::canUseWireless, val -> {
            this.canUseWireless = val;
        }));
    }

    @Override
    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (MTEHatch tHatch : this.mExoticEnergyHatches) {
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        if (storedEnergy < 0L) {
            storedEnergy = Long.MAX_VALUE;
        }
        if (maxEnergy < 0L) {
            maxEnergy = Long.MAX_VALUE;
        }
        return new String[]{EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"gg.info.antimatter_forge") + " " + EnumChatFormatting.GRAY, StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime) + EnumChatFormatting.RESET + "t / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime) + EnumChatFormatting.RESET + "t", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"gui.AntimatterGenerator.0") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.euLastCycle) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"gui.AntimatterGenerator.1") + ": " + EnumChatFormatting.AQUA + GTUtility.formatNumbers(Math.ceil(this.annihilationEfficiency * 100.0f)) + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"gui.AntimatterGenerator.1") + ": \u27e8 " + EnumChatFormatting.AQUA + GTUtility.formatNumbers(Math.ceil(this.avgEffCache * 100.0f)) + EnumChatFormatting.RESET + " % \u27e9\u2081\u2080"};
    }

    private long getEnergyProduced() {
        return this.euLastCycle;
    }

    private float getEfficiency() {
        return this.annihilationEfficiency;
    }

    private void setAvgEff(float a) {
        if (this.n == 10) {
            this.n = 0;
        }
        if (this.avgEff.size() < 10) {
            this.avgEff.add(Float.valueOf(a));
        } else {
            this.avgEff.set(this.n, Float.valueOf(a));
            ++this.n;
        }
        float b = 0.0f;
        for (float c : this.avgEff) {
            b += c;
        }
        this.avgEffCache = b == 0.0f ? 0.0f : b / (float)this.avgEff.size();
    }

    private float getAvgEfficiency() {
        return this.avgEffCache;
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)((Column)((Column)((Column)((Column)screenElements.widget((Widget)new TextWidget().setStringSupplier(() -> StatCollector.func_74838_a((String)"gui.AntimatterGenerator.0") + ": " + EnumChatFormatting.BLUE + standardFormat.format(this.energyProducedCache) + EnumChatFormatting.WHITE + " EU").setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()))).widget((Widget)new FakeSyncWidget.LongSyncer(this::getEnergyProduced, val -> {
            this.energyProducedCache = val;
        }))).widget((Widget)new TextWidget().setStringSupplier(() -> StatCollector.func_74838_a((String)"gui.AntimatterGenerator.1") + ": " + EnumChatFormatting.RED + numberFormat.format(Math.ceil(this.efficiencyCache * 100.0f)) + EnumChatFormatting.WHITE + " %").setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()))).widget((Widget)new FakeSyncWidget.FloatSyncer(this::getEfficiency, val -> {
            this.efficiencyCache = val.floatValue();
        }))).widget((Widget)new TextWidget().setStringSupplier(() -> StatCollector.func_74838_a((String)"gui.AntimatterGenerator.1") + ": \u27e8 " + EnumChatFormatting.RED + numberFormat.format(Math.ceil(this.avgEffCache * 100.0f)) + EnumChatFormatting.WHITE + " % \u27e9\u2081\u2080").setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()))).widget((Widget)new FakeSyncWidget.FloatSyncer(this::getAvgEfficiency, val -> {
            this.avgEffCache = val.floatValue();
        }));
    }

    @Override
    public IStructureDefinition<AntimatterGenerator> getStructureDefinition() {
        return STRUCTURE_DEFINITION.get(this.getClass());
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_ANTIMATTER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FUSION1).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FUSION1_GLOW).extFacing().glow().build()};
        }
        if (aActive) {
            return new ITexture[]{TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_ANTIMATTER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_ANTIMATTER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_ANTIMATTER).extFacing().build()};
    }

    public Block getCoilBlock(int type) {
        if (type == 2) {
            return Loaders.protomatterActivationCoil;
        }
        return Loaders.antimatterAnnihilationMatrix;
    }

    public int getCoilMeta(int type) {
        return 0;
    }

    public Block getCasingBlock(int type) {
        if (type == 2) {
            return Loaders.gravityStabilizationCasing;
        }
        return Loaders.magneticFluxCasing;
    }

    public int getCasingMeta(int type) {
        return 0;
    }

    public Block getFrameBlock() {
        return Loaders.antimatterContainmentCasing;
    }

    public int getFrameMeta() {
        return 0;
    }

    public Block getGlassBlock() {
        return ItemRegistry.bw_realglas2;
    }

    public int getGlassMeta() {
        return 0;
    }

    public int textureIndex(int type) {
        if (type == 2) {
            return 1546;
        }
        return 1545;
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }

    @Override
    public boolean showRecipeTextInGUI() {
        return false;
    }

    static {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
        dfs.setExponentSeparator("e");
        standardFormat = new DecimalFormat("0.00E0", dfs);
    }
}

