/*
 * Decompiled with CFR 0.152.
 */
package galacticgreg;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import galacticgreg.auxiliary.GalacticGregConfig;
import galacticgreg.auxiliary.LogHelper;
import galacticgreg.auxiliary.ProfilingStorage;
import galacticgreg.command.AEStorageCommand;
import galacticgreg.command.ProfilingCommand;
import galacticgreg.registry.GalacticGregRegistry;
import galacticgreg.schematics.SpaceSchematicHandler;
import gregtech.api.enums.Mods;
import gregtech.api.world.GTWorldgen;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.command.ICommand;

@Mod(modid="galacticgreg", name="Galactic Greg", version="5.09.51.389", dependencies="after:GalacticraftCore; required-after:gregtech@5.09.32.30;", acceptableRemoteVersions="*")
public class GalacticGreg {
    public static final List<GTWorldgen> smallOreWorldgenList = new ArrayList<GTWorldgen>();
    public static final List<GTWorldgen> oreVeinWorldgenList = new ArrayList<GTWorldgen>();
    public static final String NICE_MODID = "GalacticGreg";
    public static final String MODID = "galacticgreg";
    public static final String MODNAME = "Galactic Greg";
    public static final String VERSION = "5.09.51.389";
    public static final LogHelper Logger = new LogHelper("GalacticGreg");
    public static ProfilingStorage Profiler = new ProfilingStorage();
    public static SpaceSchematicHandler SchematicHandler;
    public static Random GalacticRandom;
    public static GalacticGregConfig GalacticConfig;
    public static final ArrayList<Runnable> ADDITIONALVEINREGISTER;

    @Mod.EventHandler
    public void onPreLoad(FMLPreInitializationEvent aEvent) {
        GalacticConfig = new GalacticGregConfig(aEvent.getModConfigurationDirectory(), NICE_MODID, NICE_MODID);
        if (!GalacticConfig.LoadConfig()) {
            Logger.warn("Something went wrong while reading GalacticGregs config file. Things will be wonky..", new Object[0]);
        }
        GalacticRandom = new Random(System.currentTimeMillis());
        if (GalacticGreg.GalacticConfig.SchematicsEnabled) {
            SchematicHandler = new SpaceSchematicHandler(aEvent.getModConfigurationDirectory());
        }
        Logger.trace("Leaving PRELOAD", new Object[0]);
    }

    @Mod.EventHandler
    public void onPostLoad(FMLPostInitializationEvent aEvent) {
        Logger.trace("Entering POSTLOAD", new Object[0]);
        if (!GalacticGregRegistry.InitRegistry()) {
            throw new RuntimeException("GalacticGreg registry has been finalized from a 3rd-party mod, this is forbidden!");
        }
        for (Runnable r : ADDITIONALVEINREGISTER) {
            try {
                r.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        GalacticConfig.serverPostInit();
        Logger.trace("Leaving POSTLOAD", new Object[0]);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent pEvent) {
        Logger.trace("Entering SERVERLOAD", new Object[0]);
        if (GalacticGreg.GalacticConfig.ProfileOreGen) {
            pEvent.registerServerCommand((ICommand)new ProfilingCommand());
        }
        if (Mods.AppliedEnergistics2.isModLoaded() && GalacticGreg.GalacticConfig.EnableAEExportCommand && GalacticGreg.GalacticConfig.SchematicsEnabled) {
            pEvent.registerServerCommand((ICommand)new AEStorageCommand());
        }
        Logger.trace("Leaving SERVERLOAD", new Object[0]);
    }

    static {
        GalacticRandom = null;
        GalacticConfig = null;
        ADDITIONALVEINREGISTER = new ArrayList();
    }
}

