/*
 * Decompiled with CFR 0.152.
 */
package bartworks;

import bartworks.API.BioObjectAdder;
import bartworks.API.BioVatLogicAdder;
import bartworks.GuiHandler;
import bartworks.client.creativetabs.BartWorksTab;
import bartworks.client.creativetabs.BioTab;
import bartworks.client.creativetabs.GT2Tab;
import bartworks.client.textures.PrefixTextureLinker;
import bartworks.common.configs.Configuration;
import bartworks.common.items.BWItemBlocks;
import bartworks.common.loaders.ArtificialMicaLine;
import bartworks.common.loaders.BioCultureLoader;
import bartworks.common.loaders.BioLabLoader;
import bartworks.common.loaders.BioRecipeLoader;
import bartworks.common.loaders.ItemRegistry;
import bartworks.common.loaders.RadioHatchMaterialLoader;
import bartworks.common.loaders.RecipeLoader;
import bartworks.common.loaders.RegisterServerCommands;
import bartworks.common.loaders.StaticRecipeChangeLoaders;
import bartworks.server.EventHandler.ServerEventHandler;
import bartworks.system.material.CircuitGeneration.CircuitImprintLoader;
import bartworks.system.material.CircuitGeneration.CircuitPartLoader;
import bartworks.system.material.Werkstoff;
import bartworks.system.material.WerkstoffLoader;
import bartworks.system.material.gtenhancement.PlatinumSludgeOverHaul;
import bartworks.system.oredict.OreDictHandler;
import bartworks.util.ResultWrongSievert;
import bartworks.util.log.DebugLog;
import bwcrossmod.galacticgreg.VoidMinerUtility;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Mods;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GlassTier;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tectech.loader.recipe.Godforge;

@Mod(modid="bartworks", name="BartWorks", version="5.09.51.389", guiFactory="bartworks.client.gui.BWGuiFactory", dependencies="required-after:IC2;required-after:gregtech;after:berriespp;after:tectech;after:GalacticraftMars;after:GalacticraftCore;after:Forestry;after:ProjRed|Illumination;after:RandomThings;before:miscutils;")
public final class MainMod {
    public static final String NAME = "BartWorks";
    public static final String MOD_ID = "bartworks";
    public static final String APIVERSION = "11";
    public static final Logger LOGGER = LogManager.getLogger((String)"BartWorks");
    public static final CreativeTabs GT2 = new GT2Tab("GT2C");
    public static final CreativeTabs BIO_TAB = new BioTab("BioTab");
    public static final CreativeTabs BWT = new BartWorksTab(Mods.BartWorks.ID);
    public static final IGuiHandler GH = new GuiHandler();
    public static final boolean DEBUG = Boolean.getBoolean("bw.debug");
    @Mod.Instance(value="bartworks")
    public static MainMod instance;
    private static boolean recipesAdded;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        GameRegistry.registerBlock((Block)ItemRegistry.bw_glasses[0], BWItemBlocks.class, (String)"BW_GlasBlocks");
        GameRegistry.registerBlock((Block)ItemRegistry.bw_glasses[1], BWItemBlocks.class, (String)"BW_GlasBlocks2");
        if (DEBUG) {
            try {
                DebugLog.initDebugLog(event);
            }
            catch (IOException e) {
                LOGGER.catching((Throwable)e);
            }
        }
        WerkstoffLoader.setUp();
        BioCultureLoader.run();
        Werkstoff.init();
        GregTechAPI.sAfterGTPostload.add(new CircuitPartLoader());
        if (event.getSide().isClient()) {
            GregTechAPI.sBeforeGTLoad.add(new PrefixTextureLinker());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (event.getSide().isClient() && Configuration.tooltip.addGlassTierInTooltips) {
            MinecraftForge.EVENT_BUS.register((Object)new GlassTier.GlassTooltipHandler());
        }
        ServerEventHandler serverEventHandler = new ServerEventHandler();
        if (event.getSide().isServer()) {
            MinecraftForge.EVENT_BUS.register((Object)serverEventHandler);
        }
        FMLCommonHandler.instance().bus().register((Object)serverEventHandler);
        BioLabLoader.run(event);
        WerkstoffLoader.runInit();
        ItemRegistry.run();
        GlassTier.RegisterGlassTiers.run();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent postinit) {
        RecipeLoader.run();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, GH);
        ArtificialMicaLine.runArtificialMicaRecipe();
        BioObjectAdder.regenerateBioFluids();
        WerkstoffLoader.run();
        CheckRecipeResultRegistry.register(new ResultWrongSievert(0, ResultWrongSievert.NeededSievertType.EXACTLY));
        RadioHatchMaterialLoader.run();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        RegisterServerCommands.registerAll(event);
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) {
        MainMod.runOnPlayerJoined(false, false);
    }

    @Mod.EventHandler
    public void onModLoadingComplete(FMLLoadCompleteEvent event) {
        WerkstoffLoader.removeIC2Recipes();
        StaticRecipeChangeLoaders.addElectricImplosionCompressorRecipes();
        PlatinumSludgeOverHaul.replacePureElements();
        BioRecipeLoader.runOnServerStarted();
        StaticRecipeChangeLoaders.unificationRecipeEnforcer();
        VoidMinerUtility.generateDropMaps();
    }

    public static void runOnPlayerJoined(boolean classicMode, boolean disableExtraGasRecipes) {
        OreDictHandler.adaptCacheForWorld();
        CircuitImprintLoader.run();
        BioVatLogicAdder.RadioHatch.runBasicItemIntegration();
        RecipeMap.ALL_RECIPE_MAPS.values().forEach(map -> ((RecipeMapBackend)map.getBackend()).reInit());
        if (!recipesAdded) {
            Godforge.initMoltenModuleRecipes();
        }
        recipesAdded = true;
    }
}

