/*
 * Decompiled with CFR 0.152.
 */
package bartworks.API;

import bartworks.system.material.BWNonMetaMaterialItems;
import bartworks.system.material.WerkstoffLoader;
import bartworks.util.BWUtil;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.util.GTModHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BioVatLogicAdder {

    public static class MaterialSvPair {
        final Materials materials;
        final Integer sievert;

        public MaterialSvPair(Materials materials, Integer sievert) {
            this.materials = materials;
            this.sievert = sievert;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MaterialSvPair that = (MaterialSvPair)o;
            return Objects.equals(this.getMaterials(), that.getMaterials()) && Objects.equals(this.getSievert(), that.getSievert());
        }

        public int hashCode() {
            return Objects.hash(this.getMaterials(), this.getSievert());
        }

        public Materials getMaterials() {
            return this.materials;
        }

        public Integer getSievert() {
            return this.sievert;
        }
    }

    public static class RadioHatch {
        private static final HashSet<MaterialSvPair> MaSv = new HashSet();
        private static final HashMap<ItemStack, Integer> IsSv = new HashMap();
        private static final HashMap<ItemStack, Integer> IsKg = new HashMap();
        private static final HashMap<ItemStack, short[]> IsColor = new HashMap();
        public static int MaxSV = 150;

        public static void runBasicItemIntegration() {
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.ThoriumCell_1.get(1L, new Object[0]), Materials.Thorium, 3);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.ThoriumCell_2.get(1L, new Object[0]), Materials.Thorium, 6);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.ThoriumCell_4.get(1L, new Object[0]), Materials.Thorium, 12);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.NaquadahCell_1.get(1L, new Object[0]), Materials.Naquadah, 3);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.NaquadahCell_2.get(1L, new Object[0]), Materials.Naquadah, 6);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.NaquadahCell_4.get(1L, new Object[0]), Materials.Naquadah, 12);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.Moxcell_1.get(1L, new Object[0]), Materials.Plutonium, 3);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.Moxcell_2.get(1L, new Object[0]), Materials.Plutonium, 6);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.Moxcell_4.get(1L, new Object[0]), Materials.Plutonium, 12);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.Uraniumcell_1.get(1L, new Object[0]), Materials.Uranium, 3);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.Uraniumcell_2.get(1L, new Object[0]), Materials.Uranium, 6);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.Uraniumcell_4.get(1L, new Object[0]), Materials.Uranium, 12);
            RadioHatch.giveItemStackRadioHatchAbilites(BWNonMetaMaterialItems.TiberiumCell_1.get(1L, new Object[0]), WerkstoffLoader.Tiberium.getBridgeMaterial(), 3);
            RadioHatch.giveItemStackRadioHatchAbilites(BWNonMetaMaterialItems.TiberiumCell_2.get(1L, new Object[0]), WerkstoffLoader.Tiberium.getBridgeMaterial(), 6);
            RadioHatch.giveItemStackRadioHatchAbilites(BWNonMetaMaterialItems.TiberiumCell_4.get(1L, new Object[0]), WerkstoffLoader.Tiberium.getBridgeMaterial(), 12);
            RadioHatch.giveItemStackRadioHatchAbilites(BWNonMetaMaterialItems.TheCoreCell.get(1L, new Object[0]), Materials.Naquadah, 96);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.Depleted_Thorium_1.get(1L, new Object[0]), Materials.Thorium, 3, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.Depleted_Thorium_2.get(1L, new Object[0]), Materials.Thorium, 6, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.Depleted_Thorium_4.get(1L, new Object[0]), Materials.Thorium, 12, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.Depleted_Naquadah_1.get(1L, new Object[0]), Materials.Naquadah, 3, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.Depleted_Naquadah_2.get(1L, new Object[0]), Materials.Naquadah, 6, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.Depleted_Naquadah_4.get(1L, new Object[0]), Materials.Naquadah, 12, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(GTModHandler.getModItem(Mods.IndustrialCraft2.ID, "reactorMOXSimpledepleted", 1L), Materials.Plutonium, 3, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(GTModHandler.getModItem(Mods.IndustrialCraft2.ID, "reactorMOXDualdepleted", 1L), Materials.Plutonium, 6, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(GTModHandler.getModItem(Mods.IndustrialCraft2.ID, "reactorMOXQuaddepleted", 1L), Materials.Plutonium, 12, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(GTModHandler.getModItem(Mods.IndustrialCraft2.ID, "reactorUraniumSimpledepleted", 1L), Materials.Uranium, 3, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(GTModHandler.getModItem(Mods.IndustrialCraft2.ID, "reactorUraniumDualdepleted", 1L), Materials.Uranium, 6, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(GTModHandler.getModItem(Mods.IndustrialCraft2.ID, "reactorUraniumQuaddepleted", 1L), Materials.Uranium, 12, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(BWNonMetaMaterialItems.Depleted_Tiberium_1.get(1L, new Object[0]), WerkstoffLoader.Tiberium.getBridgeMaterial(), 3, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(BWNonMetaMaterialItems.Depleted_Tiberium_2.get(1L, new Object[0]), WerkstoffLoader.Tiberium.getBridgeMaterial(), 6, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(BWNonMetaMaterialItems.Depleted_Tiberium_4.get(1L, new Object[0]), WerkstoffLoader.Tiberium.getBridgeMaterial(), 12, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(BWNonMetaMaterialItems.Depleted_TheCoreCell.get(1L, new Object[0]), Materials.Naquadah, 96, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.MNqCell_1.get(1L, new Object[0]), Materials.Naquadria, 3);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.MNqCell_2.get(1L, new Object[0]), Materials.Naquadria, 6);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.MNqCell_4.get(1L, new Object[0]), Materials.Naquadria, 12);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.Depleted_MNq_1.get(1L, new Object[0]), Materials.Naquadria, 3, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.Depleted_MNq_2.get(1L, new Object[0]), Materials.Naquadria, 6, 10);
            RadioHatch.giveItemStackRadioHatchAbilites(ItemList.Depleted_MNq_4.get(1L, new Object[0]), Materials.Naquadria, 12, 10);
        }

        @NotNull
        public static HashSet<MaterialSvPair> getMaSv() {
            return MaSv;
        }

        @NotNull
        public static HashMap<ItemStack, Integer> getIsKg() {
            return IsKg;
        }

        @NotNull
        public static HashMap<ItemStack, Integer> getIsSv() {
            return IsSv;
        }

        @NotNull
        public static HashMap<ItemStack, short[]> getIsColor() {
            return IsColor;
        }

        public static void setOverrideSvForMaterial(Materials m, int sv) {
            MaSv.add(new MaterialSvPair(m, sv));
        }

        public static void giveItemStackRadioHatchAbilites(ItemStack stack, int sv) {
            IsSv.put(stack, sv);
        }

        public static void giveItemStackRadioHatchAbilites(ItemStack stack, Materials materials) {
            IsSv.put(stack, BWUtil.calculateSv(materials));
        }

        public static void giveItemStackRadioHatchAbilites(ItemStack stack, int sv, int kg) {
            IsSv.put(stack, sv);
            IsKg.put(stack, kg);
        }

        public static void giveItemStackRadioHatchAbilites(ItemStack stack, @NotNull Materials materials, int kg) {
            RadioHatch.giveItemStackRadioHatchAbilites(stack, BWUtil.calculateSv(materials), kg);
            IsColor.put(stack, materials.getRGBA());
        }

        public static void giveItemStackRadioHatchAbilites(ItemStack stack, @NotNull Materials materials, int kg, int divider) {
            RadioHatch.giveItemStackRadioHatchAbilites(stack, BWUtil.calculateSv(materials) / divider, kg);
            IsColor.put(stack, materials.getRGBA());
        }

        public static void giveItemStackRadioHatchAbilites(ItemStack stack, int sv, int kg, short[] color) {
            RadioHatch.giveItemStackRadioHatchAbilites(stack, sv, kg);
            IsColor.put(stack, color);
        }

        public static int getMaxSv() {
            int ret = MaxSV;
            for (MaterialSvPair pair : RadioHatch.getMaSv()) {
                if (pair.getSievert() <= ret) continue;
                ret = pair.getSievert();
            }
            for (ItemStack is : IsSv.keySet()) {
                if (IsSv.get(is) <= ret) continue;
                ret = IsSv.get(is);
            }
            return ret;
        }
    }
}

