/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.render;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vector3d;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public final class CubeRenderer {
    private static final ThreadLocal<CubeRenderer> instance = ThreadLocal.withInitial(CubeRenderer::new);
    public final Vector3d[] verts = new Vector3d[8];

    public CubeRenderer() {
        for (int i = 0; i < this.verts.length; ++i) {
            this.verts[i] = new Vector3d();
        }
    }

    public static CubeRenderer get() {
        return instance.get();
    }

    public void render(Block block, int meta) {
        this.render(block, meta, null);
    }

    public void render(Block block, int meta, VertexTransform xForm) {
        IIcon[] icons = new IIcon[6];
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            icons[dir.ordinal()] = block.func_149691_a(dir.ordinal(), meta);
        }
        this.render(BoundingBox.UNIT_CUBE.translate(0.0f, -0.1f, 0.0f), icons, xForm, true);
    }

    public void render(BoundingBox bb, IIcon tex) {
        this.render(bb, tex, null, false);
    }

    public void render(BoundingBox bb, IIcon tex, boolean tintSides) {
        this.render(bb, tex, null, tintSides);
    }

    public void render(BoundingBox bb, IIcon tex, VertexTransform xForm) {
        this.render(bb, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h(), xForm, false);
    }

    public void render(BoundingBox bb, IIcon tex, VertexTransform xForm, float[] brightnessPerSide, boolean tintSides) {
        float minU = 0.0f;
        float minV = 0.0f;
        float maxU = 1.0f;
        float maxV = 1.0f;
        if (tex != null) {
            minU = tex.func_94209_e();
            minV = tex.func_94206_g();
            maxU = tex.func_94212_f();
            maxV = tex.func_94210_h();
        }
        this.render(bb, minU, maxU, minV, maxV, xForm, brightnessPerSide, tintSides);
    }

    public void render(BoundingBox bb, IIcon tex, VertexTransform xForm, boolean tintSides) {
        float minU = 0.0f;
        float minV = 0.0f;
        float maxU = 1.0f;
        float maxV = 1.0f;
        if (tex != null) {
            minU = tex.func_94209_e();
            minV = tex.func_94206_g();
            maxU = tex.func_94212_f();
            maxV = tex.func_94210_h();
        }
        this.render(bb, minU, maxU, minV, maxV, xForm, tintSides);
    }

    public void render(BoundingBox bb, float minU, float maxU, float minV, float maxV, boolean tintSides) {
        this.render(bb, minU, maxU, minV, maxV, null, tintSides);
    }

    public void render(BoundingBox bb, float minU, float maxU, float minV, float maxV) {
        this.render(bb, minU, maxU, minV, maxV, null, false);
    }

    public void render(BoundingBox bb, float minU, float maxU, float minV, float maxV, VertexTransform xForm) {
        this.render(bb, minU, maxU, minV, maxV, xForm, false);
    }

    public void render(BoundingBox bb, float minU, float maxU, float minV, float maxV, VertexTransform xForm, boolean tintSides) {
        float[] brightnessPerSide = null;
        if (tintSides) {
            brightnessPerSide = new float[6];
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                brightnessPerSide[dir.ordinal()] = RenderUtil.getColorMultiplierForFace(dir);
            }
        }
        this.render(bb, minU, maxU, minV, maxV, xForm, brightnessPerSide);
    }

    public void render(BoundingBox bb, float minU, float maxU, float minV, float maxV, VertexTransform xForm, float[] brightnessPerSide, boolean tintSides) {
        if (tintSides) {
            if (brightnessPerSide == null || brightnessPerSide.length != 6) {
                brightnessPerSide = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                brightnessPerSide[dir.ordinal()] = brightnessPerSide[dir.ordinal()] * RenderUtil.getColorMultiplierForFace(dir);
            }
        }
        this.render(bb, minU, maxU, minV, maxV, xForm, brightnessPerSide);
    }

    public void render(BoundingBox bb, float minU, float maxU, float minV, float maxV, VertexTransform xForm, float[] brightnessPerSide) {
        float cm;
        if (brightnessPerSide != null && brightnessPerSide.length != 6) {
            brightnessPerSide = null;
        }
        this.setupVertices(bb, xForm);
        float tmp = minV;
        minV = maxV;
        maxV = tmp;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        if (brightnessPerSide != null) {
            cm = brightnessPerSide[ForgeDirection.NORTH.ordinal()];
            tessellator.func_78386_a(cm, cm, cm);
        }
        this.addVecWithUV(this.verts[1], minU, minV);
        this.addVecWithUV(this.verts[0], maxU, minV);
        this.addVecWithUV(this.verts[3], maxU, maxV);
        this.addVecWithUV(this.verts[2], minU, maxV);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        if (brightnessPerSide != null) {
            cm = brightnessPerSide[ForgeDirection.SOUTH.ordinal()];
            tessellator.func_78386_a(cm, cm, cm);
        }
        this.addVecWithUV(this.verts[4], minU, minV);
        this.addVecWithUV(this.verts[5], maxU, minV);
        this.addVecWithUV(this.verts[6], maxU, maxV);
        this.addVecWithUV(this.verts[7], minU, maxV);
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        if (brightnessPerSide != null) {
            cm = brightnessPerSide[ForgeDirection.UP.ordinal()];
            tessellator.func_78386_a(cm, cm, cm);
        }
        this.addVecWithUV(this.verts[6], minU, minV);
        this.addVecWithUV(this.verts[2], minU, maxV);
        this.addVecWithUV(this.verts[3], maxU, maxV);
        this.addVecWithUV(this.verts[7], maxU, minV);
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        if (brightnessPerSide != null) {
            cm = brightnessPerSide[ForgeDirection.DOWN.ordinal()];
            tessellator.func_78386_a(cm, cm, cm);
        }
        this.addVecWithUV(this.verts[0], maxU, maxV);
        this.addVecWithUV(this.verts[1], minU, maxV);
        this.addVecWithUV(this.verts[5], minU, minV);
        this.addVecWithUV(this.verts[4], maxU, minV);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        if (brightnessPerSide != null) {
            cm = brightnessPerSide[ForgeDirection.EAST.ordinal()];
            tessellator.func_78386_a(cm, cm, cm);
        }
        this.addVecWithUV(this.verts[2], minU, maxV);
        this.addVecWithUV(this.verts[6], maxU, maxV);
        this.addVecWithUV(this.verts[5], maxU, minV);
        this.addVecWithUV(this.verts[1], minU, minV);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        if (brightnessPerSide != null) {
            cm = brightnessPerSide[ForgeDirection.WEST.ordinal()];
            tessellator.func_78386_a(cm, cm, cm);
        }
        this.addVecWithUV(this.verts[0], minU, minV);
        this.addVecWithUV(this.verts[4], maxU, minV);
        this.addVecWithUV(this.verts[7], maxU, maxV);
        this.addVecWithUV(this.verts[3], minU, maxV);
    }

    public void render(BoundingBox bb, IIcon[] icons, boolean tintSides) {
        float[] brightnessPerSide = null;
        if (tintSides) {
            brightnessPerSide = new float[6];
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                brightnessPerSide[dir.ordinal()] = RenderUtil.getColorMultiplierForFace(dir);
            }
        }
        this.render(bb, icons, null, brightnessPerSide);
    }

    public void render(BoundingBox bb, IIcon[] icons, VertexTransform xForm, boolean tintSides) {
        float[] brightnessPerSide = null;
        if (tintSides) {
            brightnessPerSide = new float[6];
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                brightnessPerSide[dir.ordinal()] = RenderUtil.getColorMultiplierForFace(dir);
            }
        }
        this.render(bb, icons, xForm, brightnessPerSide);
    }

    public void render(BoundingBox bb, IIcon[] faceTextures, VertexTransform xForm, float[] brightnessPerSide) {
        float cm;
        this.setupVertices(bb, xForm);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        if (brightnessPerSide != null) {
            cm = brightnessPerSide[ForgeDirection.NORTH.ordinal()];
            tessellator.func_78386_a(cm, cm, cm);
        }
        IIcon tex = faceTextures[ForgeDirection.NORTH.ordinal()];
        float minU = tex.func_94209_e();
        float maxU = tex.func_94212_f();
        float minV = tex.func_94206_g();
        float maxV = tex.func_94210_h();
        this.addVecWithUV(this.verts[1], minU, maxV);
        this.addVecWithUV(this.verts[0], maxU, maxV);
        this.addVecWithUV(this.verts[3], maxU, minV);
        this.addVecWithUV(this.verts[2], minU, minV);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        if (brightnessPerSide != null) {
            cm = brightnessPerSide[ForgeDirection.SOUTH.ordinal()];
            tessellator.func_78386_a(cm, cm, cm);
        }
        tex = faceTextures[ForgeDirection.SOUTH.ordinal()];
        minU = tex.func_94209_e();
        maxU = tex.func_94212_f();
        minV = tex.func_94206_g();
        maxV = tex.func_94210_h();
        this.addVecWithUV(this.verts[4], minU, maxV);
        this.addVecWithUV(this.verts[5], maxU, maxV);
        this.addVecWithUV(this.verts[6], maxU, minV);
        this.addVecWithUV(this.verts[7], minU, minV);
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        if (brightnessPerSide != null) {
            cm = brightnessPerSide[ForgeDirection.UP.ordinal()];
            tessellator.func_78386_a(cm, cm, cm);
        }
        tex = faceTextures[ForgeDirection.UP.ordinal()];
        minU = tex.func_94209_e();
        maxU = tex.func_94212_f();
        minV = tex.func_94206_g();
        maxV = tex.func_94210_h();
        this.addVecWithUV(this.verts[6], minU, minV);
        this.addVecWithUV(this.verts[2], minU, maxV);
        this.addVecWithUV(this.verts[3], maxU, maxV);
        this.addVecWithUV(this.verts[7], maxU, minV);
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        if (brightnessPerSide != null) {
            cm = brightnessPerSide[ForgeDirection.DOWN.ordinal()];
            tessellator.func_78386_a(cm, cm, cm);
        }
        tex = faceTextures[ForgeDirection.DOWN.ordinal()];
        minU = tex.func_94209_e();
        maxU = tex.func_94212_f();
        minV = tex.func_94206_g();
        maxV = tex.func_94210_h();
        this.addVecWithUV(this.verts[0], maxU, maxV);
        this.addVecWithUV(this.verts[1], minU, maxV);
        this.addVecWithUV(this.verts[5], minU, minV);
        this.addVecWithUV(this.verts[4], maxU, minV);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        if (brightnessPerSide != null) {
            cm = brightnessPerSide[ForgeDirection.EAST.ordinal()];
            tessellator.func_78386_a(cm, cm, cm);
        }
        tex = faceTextures[ForgeDirection.EAST.ordinal()];
        minU = tex.func_94209_e();
        maxU = tex.func_94212_f();
        minV = tex.func_94206_g();
        maxV = tex.func_94210_h();
        this.addVecWithUV(this.verts[2], minU, minV);
        this.addVecWithUV(this.verts[6], maxU, minV);
        this.addVecWithUV(this.verts[5], maxU, maxV);
        this.addVecWithUV(this.verts[1], minU, maxV);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        if (brightnessPerSide != null) {
            cm = brightnessPerSide[ForgeDirection.WEST.ordinal()];
            tessellator.func_78386_a(cm, cm, cm);
        }
        tex = faceTextures[ForgeDirection.WEST.ordinal()];
        minU = tex.func_94209_e();
        maxU = tex.func_94212_f();
        minV = tex.func_94206_g();
        maxV = tex.func_94210_h();
        this.addVecWithUV(this.verts[0], minU, maxV);
        this.addVecWithUV(this.verts[4], maxU, maxV);
        this.addVecWithUV(this.verts[7], maxU, minV);
        this.addVecWithUV(this.verts[3], minU, minV);
    }

    public void setupVertices(BoundingBox bound) {
        this.setupVertices(bound, null);
    }

    public void setupVertices(BoundingBox bound, VertexTransform xForm) {
        this.verts[0].set(bound.minX, bound.minY, bound.minZ);
        this.verts[1].set(bound.maxX, bound.minY, bound.minZ);
        this.verts[2].set(bound.maxX, bound.maxY, bound.minZ);
        this.verts[3].set(bound.minX, bound.maxY, bound.minZ);
        this.verts[4].set(bound.minX, bound.minY, bound.maxZ);
        this.verts[5].set(bound.maxX, bound.minY, bound.maxZ);
        this.verts[6].set(bound.maxX, bound.maxY, bound.maxZ);
        this.verts[7].set(bound.minX, bound.maxY, bound.maxZ);
        if (xForm != null) {
            for (Vector3d vec : this.verts) {
                xForm.apply(vec);
            }
        }
    }

    public void addVecWithUV(Vector3d vec, double u, double v) {
        Tessellator.field_78398_a.func_78374_a(vec.x, vec.y, vec.z, u, v);
    }
}

