/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.inventory.item;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGridNode;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.IConfigManager;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import appeng.util.item.OreHelper;
import appeng.util.prioitylist.OreFilteredList;
import com.glodblock.github.inventory.ItemBiggerAppEngInventory;
import com.glodblock.github.inventory.item.BaseWirelessInventory;
import com.glodblock.github.inventory.item.IWirelessMagnetFilter;
import com.glodblock.github.inventory.item.WirelessMagnet;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class WirelessMagnetCardFilterInventory
extends BaseWirelessInventory
implements IWirelessMagnetFilter {
    private boolean ignoreNbt;
    private boolean ignoreMeta;
    private boolean useOre;
    private boolean useOreDict;
    private String oreDictFilter = "";
    protected Predicate<IAEItemStack> filterPredicate = null;
    private WirelessMagnet.ListMode listMode = WirelessMagnet.ListMode.BlackList;
    private final AppEngInternalInventory filterInventory;
    private final NBTTagCompound settingCache;
    private final NBTTagCompound filterCache;

    public WirelessMagnetCardFilterInventory(ItemStack is, int slot, IGridNode gridNode, EntityPlayer player) {
        super(is, slot, gridNode, player, StorageChannel.ITEMS, true);
        this.filterInventory = new ItemBiggerAppEngInventory(is, WirelessMagnet.filterKey, 27){

            public void func_70299_a(int slot, ItemStack newItemStack) {
                if (newItemStack != null) {
                    newItemStack.field_77994_a = 1;
                }
                super.func_70299_a(slot, newItemStack);
            }
        };
        this.settingCache = this.getSettingTag(is);
        this.filterCache = this.getFilterTag(is);
        this.readFromNBT();
    }

    public void readFromNBT() {
        NBTTagCompound data = Platform.openNbtData((ItemStack)this.target);
        if (!data.func_74764_b(WirelessMagnet.filterConfigKey)) {
            this.writeToNBT();
        }
        NBTTagCompound tag = (NBTTagCompound)data.func_74781_a(WirelessMagnet.filterConfigKey);
        this.ignoreNbt = tag.func_74767_n("nbt");
        this.ignoreMeta = tag.func_74767_n("meta");
        this.useOre = tag.func_74767_n("ore");
        this.useOreDict = tag.func_74767_n("oreDict");
        this.oreDictFilter = tag.func_74779_i("oreDictFilter");
        this.listMode = WirelessMagnet.ListMode.values()[tag.func_74762_e("list")];
    }

    public void writeToNBT() {
        NBTTagCompound data = Platform.openNbtData((ItemStack)this.target);
        NBTTagCompound tmp = new NBTTagCompound();
        tmp.func_74757_a("nbt", this.ignoreNbt);
        tmp.func_74757_a("meta", this.ignoreMeta);
        tmp.func_74757_a("ore", this.useOre);
        tmp.func_74757_a("oreDict", this.useOreDict);
        tmp.func_74778_a("oreDictFilter", this.oreDictFilter);
        tmp.func_74768_a("list", this.listMode.ordinal());
        data.func_74782_a(WirelessMagnet.filterConfigKey, (NBTBase)tmp);
    }

    private NBTTagCompound getSettingTag(ItemStack is) {
        return (NBTTagCompound)is.func_77978_p().func_74775_l(WirelessMagnet.filterConfigKey).func_74737_b();
    }

    private NBTTagCompound getFilterTag(ItemStack is) {
        return (NBTTagCompound)is.func_77978_p().func_74775_l(WirelessMagnet.filterKey).func_74737_b();
    }

    @Override
    public WirelessMagnet.ListMode getListMode() {
        return this.listMode;
    }

    @Override
    public boolean getNBTMode() {
        return this.ignoreNbt;
    }

    @Override
    public boolean getMetaMode() {
        return this.ignoreMeta;
    }

    @Override
    public boolean getOreMode() {
        return this.useOre;
    }

    @Override
    public boolean getOreDictMode() {
        return this.useOreDict;
    }

    @Override
    public String getOreDictFilter() {
        return this.oreDictFilter;
    }

    @Override
    public void setListMode(WirelessMagnet.ListMode mode) {
        this.listMode = mode;
    }

    @Override
    public void setNBTMode(boolean ignoreNBT) {
        this.ignoreNbt = ignoreNBT;
    }

    @Override
    public void setMetaMode(boolean ignoreMeta) {
        this.ignoreMeta = ignoreMeta;
    }

    @Override
    public void setOreMode(boolean useOre) {
        this.useOre = useOre;
    }

    @Override
    public void setOreDictMode(boolean useOreDict) {
        this.useOreDict = useOreDict;
    }

    @Override
    public void setOreDictFilter(String str) {
        this.oreDictFilter = str;
        this.filterPredicate = null;
    }

    @Override
    public void clearConfig() {
        IInventory inv = this.getInventoryByName("config");
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            inv.func_70299_a(i, null);
        }
    }

    @Override
    public StorageChannel getChannel() {
        return null;
    }

    public IInventory getViewCellStorage() {
        return null;
    }

    @Override
    public double extractAEPower(double amt, Actionable mode, PowerMultiplier usePowerMultiplier) {
        return 0.0;
    }

    public IMEMonitor<IAEItemStack> getItemInventory() {
        return null;
    }

    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        return null;
    }

    public IConfigManager getConfigManager() {
        return null;
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }

    @Override
    public void saveSettings() {
        super.saveSettings();
        this.writeToNBT();
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.filterInventory;
        }
        return null;
    }

    public boolean doInject(IAEItemStack is, EntityItem itemToGet, World world) {
        IAEItemStack ais = (IAEItemStack)this.injectItems((IAEStack)is);
        if (ais != null) {
            this.player.func_71001_a((Entity)itemToGet, ais.getItemStack().field_77994_a);
            this.player.field_71071_by.func_70441_a(ais.getItemStack());
            world.func_72956_a((Entity)this.player, "random.pop", 0.15f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            return false;
        }
        return true;
    }

    public boolean isItemFiltered(ItemStack inputItemStack) {
        if (this.useOreDict && !this.oreDictFilter.isEmpty()) {
            if (this.filterPredicate == null) {
                this.filterPredicate = OreFilteredList.makeFilter((String)this.oreDictFilter);
            }
            if (this.filterPredicate.test((IAEItemStack)AEItemStack.create((ItemStack)inputItemStack))) {
                return true;
            }
        }
        for (int i = 0; i < this.filterInventory.func_70302_i_(); ++i) {
            ItemStack is = this.filterInventory.func_70301_a(i);
            if (is == null) continue;
            if (this.useOre && OreHelper.INSTANCE.sameOre(OreHelper.INSTANCE.isOre(is), OreHelper.INSTANCE.isOre(inputItemStack))) {
                return true;
            }
            if (this.ignoreMeta && this.ignoreNbt) {
                return is.func_77973_b().equals(inputItemStack.func_77973_b());
            }
            if (this.ignoreMeta) {
                return ItemStack.func_77970_a((ItemStack)is, (ItemStack)inputItemStack) && is.func_77973_b() == inputItemStack.func_77973_b();
            }
            if (this.ignoreNbt) {
                return is.func_77973_b() == inputItemStack.func_77973_b() && is.func_77960_j() == inputItemStack.func_77960_j();
            }
            return is.func_77969_a(inputItemStack) && ItemStack.func_77970_a((ItemStack)is, (ItemStack)inputItemStack);
        }
        return false;
    }

    public boolean isPassFilter(ItemStack is) {
        return is != null && this.listMode == WirelessMagnet.ListMode.WhiteList == this.isItemFiltered(is);
    }

    public boolean checkCache(ItemStack is) {
        return this.settingCache.equals((Object)this.getSettingTag(is)) && this.filterCache.equals((Object)this.getFilterTag(is));
    }

    public static class FilterCache {
        private static final Map<UUID, WirelessMagnetCardFilterInventory> cache = new WeakHashMap<UUID, WirelessMagnetCardFilterInventory>();

        public static WirelessMagnetCardFilterInventory getFilter(ItemStack is, int slot, IGridNode gridNode, EntityPlayer player) {
            WirelessMagnetCardFilterInventory cachedInv = cache.get(player.func_110124_au());
            if (cachedInv != null && cachedInv.checkCache(is)) {
                return cachedInv;
            }
            WirelessMagnetCardFilterInventory newInv = new WirelessMagnetCardFilterInventory(is, slot, gridNode, player);
            cache.put(player.func_110124_au(), newInv);
            return newInv;
        }
    }
}

