/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui.container;

import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.ITerminalHost;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.OptionalSlotFake;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.container.slot.SlotPatternOutputs;
import appeng.container.slot.SlotPatternTerm;
import appeng.helpers.IContainerCraftingPacket;
import appeng.util.Platform;
import com.glodblock.github.client.gui.container.base.FCContainerEncodeTerminal;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;

public class ContainerFluidPatternTerminal
extends FCContainerEncodeTerminal {
    public ContainerFluidPatternTerminal(InventoryPlayer ip, ITerminalHost monitorable) {
        super(ip, monitorable);
        int y;
        IInventory output = this.patternTerminal.getInventoryByName("output");
        IInventory patternInv = this.patternTerminal.getInventoryByName("pattern");
        this.craftingSlots = new SlotFakeCraftingMatrix[9];
        this.outputSlots = new OptionalSlotFake[3];
        for (y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                SlotFakeCraftingMatrix slotFakeCraftingMatrix = new SlotFakeCraftingMatrix(this.crafting, x + y * 3, 18 + x * 18, -76 + y * 18);
                this.craftingSlots[x + y * 3] = slotFakeCraftingMatrix;
                this.func_75146_a((Slot)slotFakeCraftingMatrix);
            }
        }
        this.craftSlot = new SlotPatternTerm(ip.field_70458_d, this.getActionSource(), this.getPowerSource(), (IStorageMonitorable)monitorable, this.crafting, patternInv, (IInventory)this.cOut, 110, -58, (IOptionalSlotHost)this, 2, (IContainerCraftingPacket)this);
        this.func_75146_a((Slot)this.craftSlot);
        this.craftSlot.setIIcon(-1);
        for (y = 0; y < 3; ++y) {
            this.outputSlots[y] = new SlotPatternOutputs(output, (IOptionalSlotHost)this, y, 110, -76 + y * 18, 0, 0, 1);
            this.func_75146_a((Slot)this.outputSlots[y]);
            this.outputSlots[y].setRenderDisabled(false);
        }
        this.updateOrderOfOutputSlots();
    }

    private void updateOrderOfOutputSlots() {
        if (!this.isCraftingMode()) {
            this.craftSlot.field_75223_e = -9000;
            for (int y = 0; y < 3; ++y) {
                this.outputSlots[y].field_75223_e = this.outputSlots[y].getX();
            }
        } else {
            this.craftSlot.field_75223_e = this.craftSlot.getX();
            for (int y = 0; y < 3; ++y) {
                this.outputSlots[y].field_75223_e = -9000;
            }
        }
    }

    @Override
    protected boolean validPatternSlot(Slot slot) {
        return slot instanceof SlotFakeCraftingMatrix || slot instanceof SlotPatternOutputs;
    }

    public void func_75141_a(int par1, ItemStack par2ItemStack) {
        super.func_75141_a(par1, par2ItemStack);
        this.getAndUpdateOutput();
    }

    public void func_75131_a(ItemStack[] par1ArrayOfItemStack) {
        super.func_75131_a(par1ArrayOfItemStack);
        this.getAndUpdateOutput();
    }

    private ItemStack getAndUpdateOutput() {
        InventoryCrafting ic = new InventoryCrafting((Container)this, 3, 3);
        for (int x = 0; x < ic.func_70302_i_(); ++x) {
            ic.func_70299_a(x, this.crafting.func_70301_a(x));
        }
        ItemStack is = CraftingManager.func_77594_a().func_82787_a(ic, this.getPlayerInv().field_70458_d.field_70170_p);
        this.cOut.func_70299_a(0, is);
        return is;
    }

    @Override
    protected ItemStack[] getOutputs() {
        ItemStack out;
        if (this.isCraftingMode() && (out = this.getAndUpdateOutput()) != null && out.field_77994_a > 0) {
            return new ItemStack[]{out};
        }
        return super.getOutputs();
    }

    public boolean isSlotEnabled(int idx) {
        if (idx == 1) {
            return Platform.isServer() ? !this.patternTerminal.isCraftingRecipe() : !this.isCraftingMode();
        }
        if (idx == 2) {
            return Platform.isServer() ? this.patternTerminal.isCraftingRecipe() : this.isCraftingMode();
        }
        return false;
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (Platform.isServer() && this.isCraftingMode() != this.patternTerminal.isCraftingRecipe()) {
            this.setCraftingMode(this.patternTerminal.isCraftingRecipe());
            this.updateOrderOfOutputSlots();
        }
    }

    @Override
    public void onUpdate(String field, Object oldValue, Object newValue) {
        super.onUpdate(field, oldValue, newValue);
        if (field.equals("craftingMode")) {
            this.getAndUpdateOutput();
            this.updateOrderOfOutputSlots();
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.getAndUpdateOutput();
    }

    private void setCraftingMode(boolean craftingMode) {
        this.craftingMode = craftingMode;
    }

    @Override
    public void doubleStacks(int val) {
        if (!this.isCraftingMode()) {
            super.doubleStacks(val);
        }
    }
}

