/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui;

import appeng.api.config.Settings;
import appeng.api.config.TerminalFontSize;
import appeng.api.config.TerminalStyle;
import appeng.api.config.YesNo;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.IGuiTooltipHandler;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.client.gui.widgets.IDropToFillTextField;
import appeng.client.gui.widgets.ITooltip;
import appeng.client.gui.widgets.MEGuiTextField;
import appeng.client.render.BlockPosHighlighter;
import appeng.container.AEBaseContainer;
import appeng.container.slot.AppEngSlot;
import appeng.core.AEConfig;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiColors;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.helpers.InventoryAction;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.util.Platform;
import appeng.util.ReadableNumberConverter;
import appeng.util.item.AEItemStack;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.api.registries.LevelItemInfo;
import com.glodblock.github.api.registries.LevelState;
import com.glodblock.github.client.gui.GuiFCImgButton;
import com.glodblock.github.client.gui.base.FCBaseMEGui;
import com.glodblock.github.client.gui.container.ContainerLevelTerminal;
import com.glodblock.github.common.item.ItemWirelessUltraTerminal;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.network.CPacketInventoryAction;
import com.glodblock.github.network.CPacketLevelTerminalCommands;
import com.glodblock.github.network.CPacketRenamer;
import com.glodblock.github.network.SPacketLevelTerminalUpdate;
import com.glodblock.github.util.FCGuiColors;
import com.glodblock.github.util.ModAndClassUtil;
import com.glodblock.github.util.Util;
import cpw.mods.fml.common.Loader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiLevelTerminal
extends FCBaseMEGui
implements IDropToFillTextField,
IGuiTooltipHandler {
    public static final int HEADER_HEIGHT = 52;
    public static final int INV_HEIGHT = 98;
    public static final int VIEW_WIDTH = 174;
    public static final int VIEW_LEFT = 8;
    private static final ResourceLocation TEX_BG = FluidCraft.resource("textures/gui/level_terminal.png");
    private static final RenderItem renderItem = new RenderItem();
    protected int offsetY;
    private static final int offsetX = 21;
    protected static String searchFieldOutputsText = "";
    protected static String searchFieldNamesText = "";
    protected static String currentMode = "OFF";
    private final MEGuiTextField searchFieldOutputs;
    private final MEGuiTextField searchFieldNames;
    private GuiImgButton searchStringSave;
    private GuiImgButton terminalStyleBox;
    private ItemStack tooltipStack;
    private boolean online;
    private final boolean neiPresent;
    private int viewHeight;
    protected GuiTabButton craftingStatusBtn;
    private final LevelTerminalList masterList = new LevelTerminalList();
    private final List<String> extraOptionsText = new ArrayList<String>(2);
    private static final float ITEM_STACK_Z = 100.0f;
    private static final float ITEM_STACK_OVERLAY_Z = 200.0f;
    private static final float SLOT_HOVER_Z = 310.0f;
    private static final float TOOLTIP_Z = 410.0f;
    private static final float STEP_Z = 10.0f;
    private static final float MAGIC_RENDER_ITEM_Z = 50.0f;

    public GuiLevelTerminal(InventoryPlayer inventoryPlayer, Container container) {
        super(inventoryPlayer, container);
        this.setScrollBar(new GuiScrollbar());
        this.field_146999_f = 208;
        this.field_147000_g = 255;
        this.neiPresent = Loader.isModLoaded((String)"NotEnoughItems");
        this.searchFieldOutputs = new MEGuiTextField(86, 12, ButtonToolTips.SearchFieldOutputs.getLocal()){

            public void onTextChange(String oldText) {
                GuiLevelTerminal.this.masterList.markDirty();
            }
        };
        this.searchFieldNames = new MEGuiTextField(71, 12, ButtonToolTips.SearchFieldNames.getLocal()){

            public void onTextChange(String oldText) {
                GuiLevelTerminal.this.masterList.markDirty();
            }
        };
        this.searchFieldNames.setFocused(true);
        this.extraOptionsText.add(ButtonToolTips.HighlightInterface.getLocal());
        this.online = true;
    }

    public GuiLevelTerminal(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        this(inventoryPlayer, (Container)new ContainerLevelTerminal(inventoryPlayer, te));
    }

    @Override
    public int getOffsetY() {
        return this.offsetY;
    }

    @Override
    public void setOffsetY(int y) {
        this.offsetY = y;
    }

    private void setScrollBar() {
        int maxScroll = this.masterList.getHeight() - this.viewHeight - 1;
        if (maxScroll <= 0) {
            this.getScrollBar().setTop(52).setLeft(189).setHeight(this.viewHeight).setRange(0, 0, 1);
        } else {
            this.getScrollBar().setTop(52).setLeft(189).setHeight(this.viewHeight).setRange(0, maxScroll, 12);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.viewHeight = this.calculateViewHeight();
        this.field_147000_g = 150 + this.viewHeight;
        int unusedSpace = this.field_146295_m - this.field_147000_g;
        this.field_147009_r = (int)Math.floor((float)unusedSpace / (unusedSpace < 0 ? 3.8f : 2.0f));
        this.offsetY = this.field_147009_r + 8;
        this.terminalStyleBox = new GuiImgButton(this.field_147003_i - 18, this.offsetY, (Enum)Settings.TERMINAL_STYLE, AEConfig.instance.settings.getSetting(Settings.TERMINAL_STYLE));
        this.offsetY += 20;
        this.searchStringSave = new GuiImgButton(this.field_147003_i - 18, this.offsetY, (Enum)Settings.SAVE_SEARCH, AEConfig.instance.settings.getSetting(Settings.SAVE_SEARCH));
        this.offsetY += 20;
        this.searchFieldOutputs.x = this.field_147003_i + Math.max(32, 21);
        this.searchFieldOutputs.y = this.field_147009_r + 38;
        this.searchFieldNames.x = this.field_147003_i + Math.max(32, 21) + 99;
        this.searchFieldNames.y = this.field_147009_r + 38;
        this.terminalStyleBox.field_146128_h = this.field_147003_i - 18;
        this.terminalStyleBox.field_146129_i = this.field_147009_r + 8;
        this.craftingStatusBtn = new GuiTabButton(this.field_147003_i + this.field_146999_f - 24, this.field_147009_r - 4, 178, GuiText.CraftingStatus.getLocal(), field_146296_j);
        this.craftingStatusBtn.setHideEdge(13);
        if (ModAndClassUtil.isSearchBar && (AEConfig.instance.preserveSearchBar || this.isSubGui())) {
            this.setSearchString();
        }
        this.field_146292_n.add(this.terminalStyleBox);
        this.field_146292_n.add(this.searchStringSave);
        this.field_146292_n.add(this.craftingStatusBtn);
        this.setScrollBar();
        this.repositionSlots();
        this.initGuiDone();
    }

    @Override
    public void func_146281_b() {
        super.func_146281_b();
        searchFieldOutputsText = this.searchFieldOutputs.getText();
        searchFieldNamesText = this.searchFieldNames.getText();
    }

    public void setSearchString() {
        this.searchFieldOutputs.setText(searchFieldOutputsText);
        this.searchFieldNames.setText(searchFieldNamesText);
    }

    protected void repositionSlots() {
        for (Object obj : this.field_147002_h.field_75151_b) {
            if (!(obj instanceof AppEngSlot)) continue;
            AppEngSlot slot = (AppEngSlot)obj;
            slot.field_75221_f = slot.getY() + this.field_147000_g - 78 - 4;
        }
    }

    private int getMaxViewHeight() {
        return AEConfig.instance.getConfigManager().getSetting(Settings.TERMINAL_STYLE) == TerminalStyle.SMALL ? AEConfig.instance.InterfaceTerminalSmallSize * 18 : Integer.MAX_VALUE;
    }

    protected int calculateViewHeight() {
        int maxViewHeight = this.getMaxViewHeight();
        boolean hasNEI = IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.NEI);
        int NEIPadding = hasNEI ? 40 : 0;
        int availableSpace = this.field_146295_m - 52 - 98 - NEIPadding;
        return Math.min((int)((double)availableSpace * 0.95), maxViewHeight);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"ae2fc.gui.part_level_terminal"), 8, 6, GuiColors.InterfaceTerminalTitle.getColor());
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), 23, this.field_147000_g - 96 + 3, GuiColors.InterfaceTerminalInventory.getColor());
        if (!this.neiPresent && this.tooltipStack != null) {
            this.func_146285_a(this.tooltipStack, mouseX, mouseY);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float btn) {
        this.terminalStyleBox.set(AEConfig.instance.settings.getSetting(Settings.TERMINAL_STYLE));
        this.field_146292_n.clear();
        this.field_146292_n.add(this.terminalStyleBox);
        this.field_146292_n.add(this.searchStringSave);
        this.field_146292_n.add(this.craftingStatusBtn);
        this.addSwitchGuiBtns();
        super.func_73863_a(mouseX, mouseY, btn);
        this.handleTooltip(mouseX, mouseY, (ITooltip)this.searchFieldOutputs);
        this.handleTooltip(mouseX, mouseY, (ITooltip)this.searchFieldNames);
    }

    @Override
    protected void func_73864_a(int xCoord, int yCoord, int btn) {
        boolean focusOut = this.searchFieldOutputs.isFocused();
        boolean focusName = this.searchFieldNames.isFocused();
        this.searchFieldOutputs.mouseClicked(xCoord, yCoord, btn);
        this.searchFieldNames.mouseClicked(xCoord, yCoord, btn);
        if (focusOut && !this.searchFieldOutputs.isFocused()) {
            searchFieldOutputsText = this.searchFieldOutputs.getText();
        } else if (focusName && !this.searchFieldNames.isFocused()) {
            searchFieldNamesText = this.searchFieldNames.getText();
        }
        if (this.masterList.mouseClicked(xCoord - this.field_147003_i - 8, yCoord - this.field_147009_r - 52, btn)) {
            return;
        }
        super.func_73864_a(xCoord, yCoord, btn);
    }

    @Override
    protected void func_146284_a(GuiButton btn) {
        GuiImgButton iBtn;
        if (ModAndClassUtil.isSaveText && btn == this.searchStringSave) {
            boolean backwards = Mouse.isButtonDown((int)1);
            GuiImgButton iBtn2 = (GuiImgButton)btn;
            Enum cv = iBtn2.getCurrentValue();
            Enum next = Platform.rotateEnum((Enum)cv, (boolean)backwards, (EnumSet)iBtn2.getSetting().getPossibleValues());
            AEConfig.instance.preserveSearchBar = next == YesNo.YES;
            AEConfig.instance.settings.putSetting(Settings.SAVE_SEARCH, next);
            this.searchStringSave.set(next);
        } else if (btn == this.craftingStatusBtn) {
            InventoryHandler.switchGui(GuiType.CRAFTING_STATUS);
        } else if (btn instanceof GuiImgButton && (iBtn = (GuiImgButton)btn).getSetting() != Settings.ACTIONS) {
            Enum cv = iBtn.getCurrentValue();
            boolean backwards = Mouse.isButtonDown((int)1);
            Enum next = Platform.rotateEnum((Enum)cv, (boolean)backwards, (EnumSet)iBtn.getSetting().getPossibleValues());
            if (btn == this.terminalStyleBox) {
                AEConfig.instance.settings.putSetting(iBtn.getSetting(), next);
                super.scheduleGuiResize();
            }
            iBtn.set(next);
        }
        super.func_146284_a(btn);
    }

    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(TEX_BG);
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, 52);
        Tessellator.field_78398_a.func_78382_b();
        this.addTexturedRectToTesselator(offsetX, offsetY + 52, offsetX + this.field_146999_f, offsetY + 52 + this.viewHeight + 1, 0.0f, 0.0f, 0.25390625f, (float)this.field_146999_f / 256.0f, 0.6171875f);
        Tessellator.field_78398_a.func_78381_a();
        this.func_73729_b(offsetX, offsetY + 52 + this.viewHeight, 0, 158, this.field_146999_f, 98);
        if (this.online) {
            GL11.glPushAttrib((int)1048575);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(offsetX + 8), (float)(offsetY + 52), (float)0.0f);
            this.tooltipStack = null;
            this.drawViewport(mouseX - offsetX - 8, mouseY - offsetY - 52 - 1);
            GL11.glPopMatrix();
            GL11.glPopAttrib();
        }
        this.searchFieldOutputs.drawTextBox();
        this.searchFieldNames.drawTextBox();
    }

    private void drawViewport(int relMouseX, int relMouseY) {
        int scroll = this.getScrollBar().getCurrentScroll();
        int viewY = -scroll;
        int entryIdx = 0;
        List<LevelTerminalSection> visibleSections = this.masterList.getVisibleSections();
        float guiScaleX = (float)this.field_146297_k.field_71443_c / (float)this.field_146294_l;
        float guiScaleY = (float)this.field_146297_k.field_71440_d / (float)this.field_146295_m;
        GL11.glScissor((int)((int)((float)(this.field_147003_i + 8) * guiScaleX)), (int)((int)((float)(this.field_146295_m - (this.field_147009_r + 52 + this.viewHeight)) * guiScaleY)), (int)((int)(174.0f * guiScaleX)), (int)((int)((float)this.viewHeight * guiScaleY)));
        GL11.glEnable((int)3089);
        while (viewY < this.viewHeight && entryIdx < visibleSections.size()) {
            LevelTerminalSection section = visibleSections.get(entryIdx);
            int sectionHeight = section.getHeight();
            if (viewY + sectionHeight < 0) {
                ++entryIdx;
                viewY += sectionHeight;
                section.visible = false;
                continue;
            }
            section.visible = true;
            int advanceY = this.drawSection(section, viewY, relMouseX, relMouseY);
            viewY += advanceY;
            ++entryIdx;
        }
    }

    private int drawSection(LevelTerminalSection section, int viewY, int relMouseX, int relMouseY) {
        int renderY = 0;
        int sectionBottom = viewY + section.getHeight() - 1;
        int fontColor = GuiColors.InterfaceTerminalInventory.getColor();
        this.field_146297_k.func_110434_K().func_110577_a(TEX_BG);
        int title = sectionBottom > 0 && sectionBottom < 12 ? sectionBottom : (viewY < 0 ? 0 : 0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Iterator<LevelTerminalEntry> visible = section.getVisible();
        while (visible.hasNext()) {
            if (viewY < this.viewHeight) {
                renderY += this.drawEntry(visible.next(), viewY + 12 + renderY, title, relMouseX, relMouseY);
                continue;
            }
            LevelTerminalEntry entry = visible.next();
            entry.dispY = -9999;
            entry.highlightButton.field_146129_i = -1;
            entry.renameButton.field_146129_i = -1;
            entry.configButton.field_146129_i = -1;
        }
        this.field_146297_k.func_110434_K().func_110577_a(TEX_BG);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)310.0f);
        if (sectionBottom > 0 && sectionBottom < 12) {
            this.func_73729_b(0, 0, 8, 64 - sectionBottom, 174, sectionBottom);
            this.field_146289_q.func_78276_b(section.name, 2, sectionBottom - 12 + 2, fontColor);
        } else if (viewY < 0) {
            GL11.glDisable((int)2929);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)100.0f);
            this.func_73729_b(0, 0, 8, 52, 174, 12);
            this.field_146289_q.func_78276_b(section.name, 2, 2, fontColor);
            GL11.glEnable((int)2929);
        } else {
            this.func_73729_b(0, viewY, 8, 52, 174, 12);
            this.field_146289_q.func_78276_b(section.name, 2, viewY + 2, fontColor);
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-310.0f);
        return 12 + renderY;
    }

    private int drawEntry(LevelTerminalEntry entry, int viewY, int titleBottom, int relMouseX, int relMouseY) {
        int col;
        int rowYBot;
        int rowYTop;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        this.field_146297_k.func_110434_K().func_110577_a(TEX_BG);
        Tessellator.field_78398_a.func_78382_b();
        int relY = 0;
        int slotLeftMargin = 174 - entry.rowSize * 18;
        float lastZLevel = GuiLevelTerminal.renderItem.field_77023_b;
        entry.dispY = viewY;
        for (int row = 0; row < entry.rows; ++row) {
            rowYTop = row * 18;
            rowYBot = rowYTop + 18;
            relY += 18;
            if (viewY + rowYBot <= titleBottom) continue;
            for (col = 0; col < entry.rowSize; ++col) {
                this.addTexturedRectToTesselator(col * 18 + slotLeftMargin, viewY + rowYTop, 18 * col + 18 + slotLeftMargin, viewY + rowYBot, 0.0f, 0.08203125f, 0.67578125f, 0.15234375f, 0.74609375f);
            }
        }
        Tessellator.field_78398_a.func_78381_a();
        if (viewY + entry.highlightButton.field_146121_g > 0 && viewY < this.viewHeight) {
            entry.highlightButton.field_146129_i = viewY + 1;
            entry.renameButton.field_146129_i = viewY + 1;
            entry.configButton.field_146129_i = viewY + 1;
            GuiFCImgButton toRender = GuiLevelTerminal.func_146271_m() && GuiLevelTerminal.func_146272_n() && ItemWirelessUltraTerminal.hasInfinityBoosterCard((EntityPlayer)player) ? entry.configButton : (GuiLevelTerminal.func_146272_n() ? entry.renameButton : entry.highlightButton);
            toRender.func_146112_a(this.field_146297_k, relMouseX, relMouseY);
            if (toRender.getMouseIn() && relMouseY >= Math.max(12, entry.highlightButton.field_146129_i)) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)410.0f);
                GL11.glDisable((int)3089);
                this.drawHoveringText(Arrays.asList(toRender.getMessage()), relMouseX, relMouseY);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-410.0f);
                GL11.glEnable((int)3089);
            }
        } else {
            entry.highlightButton.field_146129_i = -1;
            entry.renameButton.field_146129_i = -1;
        }
        for (int row = 0; row < entry.rows; ++row) {
            rowYTop = row * 18;
            rowYBot = rowYTop + 18;
            if (viewY + rowYBot <= titleBottom) continue;
            for (col = 0; col < entry.rowSize; ++col) {
                boolean tooltip;
                int colLeft = col * 18 + slotLeftMargin + 1;
                int colRight = colLeft + 18 + 1;
                int slotIdx = row * entry.rowSize + col;
                LevelItemInfo info = entry.infoList[slotIdx];
                boolean bl = tooltip = relMouseX > colLeft - 1 && relMouseX < colRight - 1 && relMouseY >= Math.max(viewY + rowYTop, 12) && relMouseY < Math.min(viewY + rowYBot, this.viewHeight);
                if (info != null) {
                    int n;
                    ItemStack itemStack = info.stack;
                    long quantity = info.quantity;
                    long batch = info.batchSize;
                    LevelState state = info.state;
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)colLeft, (float)(viewY + rowYTop + 1), (float)100.0f);
                    GL11.glEnable((int)32826);
                    RenderHelper.func_74520_c();
                    itemStack.field_77994_a = 0;
                    GuiLevelTerminal.renderItem.field_77023_b = 50.0f;
                    renderItem.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), itemStack, 0, 0);
                    renderItem.func_77021_b(this.field_146289_q, this.field_146297_k.func_110434_K(), itemStack, 0, 0);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)100.0f);
                    switch (state) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case Idle: {
                            n = FCGuiColors.StateIdle.getColor();
                            break;
                        }
                        case Craft: {
                            n = FCGuiColors.StateCraft.getColor();
                            break;
                        }
                        case Export: {
                            n = FCGuiColors.StateExport.getColor();
                            break;
                        }
                        case Error: 
                        case NotFound: 
                        case CantCraft: {
                            n = FCGuiColors.StateError.getColor();
                            break;
                        }
                        case None: {
                            n = FCGuiColors.StateNone.getColor();
                        }
                    }
                    int color = n;
                    int offset = 0;
                    int size = 4;
                    GuiLevelTerminal.func_73734_a((int)offset, (int)offset, (int)(offset + size), (int)(offset + size), (int)color);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)100.0f);
                    this.drawReadableAmount(this.field_146289_q, quantity, true, 0xFFFFFF);
                    if (batch >= 0L) {
                        this.drawReadableAmount(this.field_146289_q, batch, false, 0xFFFFFF);
                    }
                    RenderHelper.func_74518_a();
                    if (!tooltip) {
                        if (entry.filteredRecipes[slotIdx]) {
                            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)200.0f);
                            GuiLevelTerminal.func_73734_a((int)0, (int)0, (int)16, (int)16, (int)GuiColors.ItemSlotOverlayUnpowered.getColor());
                        }
                    } else {
                        this.tooltipStack = itemStack;
                    }
                    GL11.glPopMatrix();
                } else if (entry.filteredRecipes[slotIdx]) {
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)colLeft, (float)(viewY + rowYTop + 1), (float)200.0f);
                    GuiLevelTerminal.func_73734_a((int)0, (int)0, (int)16, (int)16, (int)GuiColors.ItemSlotOverlayUnpowered.getColor());
                    GL11.glPopMatrix();
                }
                if (tooltip) {
                    GL11.glDisable((int)2896);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)310.0f);
                    GuiLevelTerminal.func_73734_a((int)colLeft, (int)(viewY + 1 + rowYTop), (int)(-2 + colRight), (int)(viewY - 1 + rowYBot), (int)0x77FFFFFF);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-310.0f);
                }
                GL11.glDisable((int)2896);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiLevelTerminal.renderItem.field_77023_b = lastZLevel;
        return relY + 1;
    }

    public void drawReadableAmount(FontRenderer fontRenderer, long amount, boolean alignBottom, int color) {
        TerminalFontSize fontSize = AEConfig.instance.getTerminalFontSize();
        String stackSize = this.getToBeRenderedStackSize(amount, fontSize);
        boolean unicodeFlag = fontRenderer.func_82883_a();
        float scaleFactor = 0.85f;
        float shiftX = 0.0f;
        float shiftY = 0.0f;
        if (fontSize == TerminalFontSize.SMALL) {
            scaleFactor = 0.5f;
            shiftX = -2.0f;
            shiftY = -1.0f;
        }
        float inverseScaleFactor = 1.0f / scaleFactor;
        fontRenderer.func_78264_a(false);
        GL11.glDisable((int)2896);
        GL11.glPushMatrix();
        GL11.glScaled((double)scaleFactor, (double)scaleFactor, (double)scaleFactor);
        int X = (int)((shiftX + 16.0f + 1.0f - (float)fontRenderer.func_78256_a(stackSize) * scaleFactor) * inverseScaleFactor);
        int Y = (int)(alignBottom ? (shiftY + 16.0f - 7.0f * scaleFactor) * inverseScaleFactor : 1.0f);
        fontRenderer.func_78276_b(stackSize, X + 1, Y, 0);
        fontRenderer.func_78276_b(stackSize, X - 1, Y, 0);
        fontRenderer.func_78276_b(stackSize, X, Y + 1, 0);
        fontRenderer.func_78276_b(stackSize, X, Y - 1, 0);
        fontRenderer.func_78276_b(stackSize, X, Y, color);
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        fontRenderer.func_78264_a(unicodeFlag);
    }

    private String getToBeRenderedStackSize(long originalSize, TerminalFontSize fontSize) {
        if (fontSize == TerminalFontSize.SMALL) {
            return ReadableNumberConverter.INSTANCE.toWideReadableForm(originalSize);
        }
        return ReadableNumberConverter.INSTANCE.toSlimReadableForm(originalSize);
    }

    public void drawHoveringText(List<String> textLines, int x, int y, FontRenderer font) {
        if (!textLines.isEmpty()) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            int maxStrWidth = 0;
            for (String s : textLines) {
                int width = font.func_78256_a(s);
                if (width <= maxStrWidth) continue;
                maxStrWidth = width;
            }
            int curX = x + 12;
            int curY = y - 12;
            int totalHeight = 8;
            if (textLines.size() > 1) {
                totalHeight += 2 + (textLines.size() - 1) * 10;
            }
            if (curX + maxStrWidth > this.field_146294_l) {
                curX -= 28 + maxStrWidth;
            }
            if (curY + totalHeight + 6 > this.field_146295_m) {
                curY = this.field_146295_m - totalHeight - 6;
            }
            int borderColor = -267386864;
            this.func_73733_a(curX - 3, curY - 4, curX + maxStrWidth + 3, curY - 3, borderColor, borderColor);
            this.func_73733_a(curX - 3, curY + totalHeight + 3, curX + maxStrWidth + 3, curY + totalHeight + 4, borderColor, borderColor);
            this.func_73733_a(curX - 3, curY - 3, curX + maxStrWidth + 3, curY + totalHeight + 3, borderColor, borderColor);
            this.func_73733_a(curX - 4, curY - 3, curX - 3, curY + totalHeight + 3, borderColor, borderColor);
            this.func_73733_a(curX + maxStrWidth + 3, curY - 3, curX + maxStrWidth + 4, curY + totalHeight + 3, borderColor, borderColor);
            int color1 = 0x505000FF;
            int color2 = (color1 & 0xFEFEFE) >> 1 | color1 & 0xFF000000;
            this.func_73733_a(curX - 3, curY - 3 + 1, curX - 3 + 1, curY + totalHeight + 3 - 1, color1, color2);
            this.func_73733_a(curX + maxStrWidth + 2, curY - 3 + 1, curX + maxStrWidth + 3, curY + totalHeight + 3 - 1, color1, color2);
            this.func_73733_a(curX - 3, curY - 3, curX + maxStrWidth + 3, curY - 3 + 1, color1, color1);
            this.func_73733_a(curX - 3, curY + totalHeight + 2, curX + maxStrWidth + 3, curY + totalHeight + 3, color2, color2);
            for (int i = 0; i < textLines.size(); ++i) {
                String line = textLines.get(i);
                font.func_78261_a(line, curX, curY, -1);
                if (i == 0) {
                    curY += 2;
                }
                curY += 10;
            }
            RenderHelper.func_74520_c();
            GL11.glEnable((int)32826);
        }
    }

    protected void func_73869_a(char character, int key) {
        if (!this.func_146983_a(key)) {
            if (character == ' ' ? this.searchFieldOutputs.getText().isEmpty() && this.searchFieldOutputs.isFocused() || this.searchFieldNames.getText().isEmpty() && this.searchFieldNames.isFocused() : character == '\t' && this.handleTab()) {
                return;
            }
            if (this.searchFieldOutputs.textboxKeyTyped(character, key) || this.searchFieldNames.textboxKeyTyped(character, key)) {
                this.masterList.markDirty();
            } else {
                super.func_73869_a(character, key);
            }
        }
    }

    private boolean handleTab() {
        if (this.searchFieldOutputs.isFocused()) {
            this.searchFieldOutputs.setFocused(false);
            this.searchFieldNames.setFocused(true);
            return true;
        }
        if (this.searchFieldNames.isFocused()) {
            this.searchFieldNames.setFocused(false);
            this.searchFieldOutputs.setFocused(true);
            return true;
        }
        return false;
    }

    protected boolean mouseWheelEvent(int mouseX, int mouseY, int wheel) {
        boolean isMouseInViewport = this.isMouseInViewport(mouseX, mouseY);
        GuiScrollbar scrollbar = this.getScrollBar();
        if (isMouseInViewport && GuiLevelTerminal.func_146271_m()) {
            if (wheel < 0) {
                scrollbar.setCurrentScroll(this.masterList.getHeight());
            } else {
                this.getScrollBar().setCurrentScroll(0);
            }
            return true;
        }
        if (isMouseInViewport && GuiLevelTerminal.func_146272_n()) {
            return this.masterList.scrollNextSection(wheel > 0);
        }
        return super.mouseWheelEvent(mouseX, mouseY, wheel);
    }

    private boolean isMouseInViewport(int mouseX, int mouseY) {
        return mouseX > this.field_147003_i + 8 && mouseX < this.field_147003_i + 8 + 174 && mouseY > this.field_147009_r + 52 && mouseY < this.field_147009_r + 52 + this.viewHeight;
    }

    public void receivePackets(List<SPacketLevelTerminalUpdate.PacketEntry> packets) {
        for (SPacketLevelTerminalUpdate.PacketEntry packet : packets) {
            this.parsePacket(packet);
        }
        this.masterList.markDirty();
    }

    private void parsePacket(SPacketLevelTerminalUpdate.PacketEntry packet) {
        if (packet instanceof SPacketLevelTerminalUpdate.PacketAdd) {
            SPacketLevelTerminalUpdate.PacketAdd packetAdd = (SPacketLevelTerminalUpdate.PacketAdd)packet;
            LevelTerminalEntry entry = new LevelTerminalEntry(packetAdd.entryId, packetAdd.name, packetAdd.rows, packetAdd.rowSize, true).setLocation(packetAdd.x, packetAdd.y, packetAdd.z, packetAdd.dim, packetAdd.side).setInfoList(packetAdd.infolist);
            this.masterList.addEntry(entry);
        } else if (packet instanceof SPacketLevelTerminalUpdate.PacketRemove) {
            SPacketLevelTerminalUpdate.PacketRemove packetRemove = (SPacketLevelTerminalUpdate.PacketRemove)packet;
            this.masterList.removeEntry(packetRemove.entryId);
        } else if (packet instanceof SPacketLevelTerminalUpdate.PacketRename) {
            SPacketLevelTerminalUpdate.PacketRename packetRename = (SPacketLevelTerminalUpdate.PacketRename)packet;
            LevelTerminalEntry entry = (LevelTerminalEntry)this.masterList.list.get(packetRename.entryId);
            if (entry == null) {
                return;
            }
            entry.customName = StatCollector.func_94522_b((String)packetRename.newName) ? StatCollector.func_74838_a((String)packetRename.newName) : StatCollector.func_150826_b((String)packetRename.newName);
            this.masterList.isDirty = true;
        } else if (packet instanceof SPacketLevelTerminalUpdate.PacketDisconnect) {
            this.online = false;
        } else if (packet instanceof SPacketLevelTerminalUpdate.PacketOverwriteSlot) {
            SPacketLevelTerminalUpdate.PacketOverwriteSlot packetOverwirteSlot = (SPacketLevelTerminalUpdate.PacketOverwriteSlot)packet;
            LevelTerminalEntry entry = (LevelTerminalEntry)this.masterList.list.get(packetOverwirteSlot.entryId);
            if (entry == null) {
                return;
            }
            entry.infoList[packetOverwirteSlot.index] = packetOverwirteSlot.info;
            this.masterList.isDirty = true;
        } else if (packet instanceof SPacketLevelTerminalUpdate.PacketOverwirteAllSlot) {
            SPacketLevelTerminalUpdate.PacketOverwirteAllSlot packetOverwirteAllSlot = (SPacketLevelTerminalUpdate.PacketOverwirteAllSlot)packet;
            LevelTerminalEntry entry = (LevelTerminalEntry)this.masterList.list.get(packetOverwirteAllSlot.entryId);
            if (entry == null) {
                return;
            }
            entry.infoList = packetOverwirteAllSlot.infoList;
            this.masterList.isDirty = true;
        }
    }

    private boolean itemStackMatchesSearchTerm(ItemStack itemStack, String searchTerm) {
        if (itemStack == null) {
            return false;
        }
        String displayName = Platform.getItemDisplayName((Object)itemStack).toLowerCase();
        return displayName.contains(searchTerm);
    }

    public boolean isOverTextField(int mouseX, int mouseY) {
        return this.searchFieldOutputs.isMouseIn(mouseX, mouseY) || this.searchFieldNames.isMouseIn(mouseX, mouseY);
    }

    public void setTextFieldValue(String displayName, int mousex, int mousey, ItemStack stack) {
        if (this.searchFieldOutputs.isMouseIn(mousex, mousey)) {
            this.searchFieldOutputs.setText(displayName);
        } else if (this.searchFieldNames.isMouseIn(mousex, mousey)) {
            this.searchFieldNames.setText(displayName);
        }
    }

    public List<String> handleItemTooltip(ItemStack stack, int mouseX, int mouseY, List<String> currentToolTip) {
        if (stack == null || !GuiLevelTerminal.func_146272_n()) {
            return currentToolTip;
        }
        for (LevelTerminalSection section : this.masterList.getVisibleSections()) {
            block1: for (LevelTerminalEntry entry : section.visibleEntries) {
                for (LevelItemInfo info : entry.infoList) {
                    if (info == null || !info.stack.equals(stack)) continue;
                    currentToolTip.add(I18n.func_135052_a((String)"ae2fc.tooltip.level_maintainer.request_size", (Object[])new Object[]{"\n", false}) + ": " + NumberFormat.getInstance().format(info.quantity));
                    if (info.batchSize < 0L) continue block1;
                    currentToolTip.add(I18n.func_135052_a((String)"ae2fc.tooltip.level_maintainer.batch_size", (Object[])new Object[]{"\n", false}) + ": " + NumberFormat.getInstance().format(info.batchSize));
                    continue block1;
                }
            }
        }
        return currentToolTip;
    }

    public ItemStack getHoveredStack() {
        return this.tooltipStack;
    }

    private class LevelTerminalList {
        private final Map<Long, LevelTerminalEntry> list = new HashMap<Long, LevelTerminalEntry>();
        private final Map<String, LevelTerminalSection> sections = new TreeMap<String, LevelTerminalSection>();
        private final List<LevelTerminalSection> visibleSections = new ArrayList<LevelTerminalSection>();
        private boolean isDirty = true;
        private int height;

        LevelTerminalList() {
        }

        private void update() {
            this.height = 0;
            this.visibleSections.clear();
            for (LevelTerminalSection section : this.sections.values()) {
                String query = GuiLevelTerminal.this.searchFieldNames.getText();
                if (!query.isEmpty() && !section.name.toLowerCase().contains(query.toLowerCase())) continue;
                section.isDirty = true;
                if (!section.getVisible().hasNext()) continue;
                this.height += section.getHeight();
                this.visibleSections.add(section);
            }
            this.isDirty = false;
        }

        public void markDirty() {
            this.isDirty = true;
            GuiLevelTerminal.this.setScrollBar();
        }

        public int getHeight() {
            if (this.isDirty) {
                this.update();
            }
            return this.height;
        }

        private boolean scrollNextSection(boolean up) {
            GuiScrollbar scrollbar = GuiLevelTerminal.this.getScrollBar();
            int viewY = scrollbar.getCurrentScroll();
            List<LevelTerminalSection> sections = this.getVisibleSections();
            boolean result = false;
            if (up) {
                int y = GuiLevelTerminal.this.masterList.getHeight();
                int i = sections.size() - 1;
                while (y > 0 && i >= 0) {
                    if ((y -= sections.get(--i).getHeight()) >= viewY) continue;
                    result = true;
                    scrollbar.setCurrentScroll(y);
                    break;
                }
            } else {
                int y = 0;
                for (LevelTerminalSection section : sections) {
                    if (y > viewY) {
                        result = true;
                        scrollbar.setCurrentScroll(y);
                        break;
                    }
                    y += section.getHeight();
                }
            }
            return result;
        }

        public void addEntry(LevelTerminalEntry entry) {
            LevelTerminalSection section = this.sections.get(entry.customName);
            if (section == null) {
                section = new LevelTerminalSection(entry.customName);
                this.sections.put(entry.customName, section);
            }
            section.addEntry(entry);
            this.list.put(entry.id, entry);
            this.isDirty = true;
        }

        public void removeEntry(long id) {
            LevelTerminalEntry entry = this.list.remove(id);
            if (entry != null) {
                entry.section.removeEntry(entry);
            }
        }

        public List<LevelTerminalSection> getVisibleSections() {
            if (this.isDirty) {
                this.update();
            }
            return this.visibleSections;
        }

        public boolean mouseClicked(int relMouseX, int relMouseY, int btn) {
            if (relMouseX < 0 || relMouseX >= 174 || relMouseY < 0 || relMouseY >= GuiLevelTerminal.this.viewHeight) {
                return false;
            }
            for (LevelTerminalSection section : this.getVisibleSections()) {
                if (!section.mouseClicked(relMouseX, relMouseY, btn)) continue;
                return true;
            }
            return false;
        }
    }

    private class LevelTerminalSection {
        public static final int TITLE_HEIGHT = 12;
        String name;
        List<LevelTerminalEntry> entries = new ArrayList<LevelTerminalEntry>();
        Set<LevelTerminalEntry> visibleEntries = new TreeSet<LevelTerminalEntry>(Comparator.comparing(e -> e.customName + e.id));
        int height;
        private boolean isDirty = true;
        boolean visible = false;

        LevelTerminalSection(String name) {
            this.name = name;
        }

        public int getHeight() {
            if (this.isDirty) {
                this.update();
            }
            return this.height;
        }

        private void update() {
            this.refreshVisible();
            if (this.visibleEntries.isEmpty()) {
                this.height = 0;
            } else {
                this.height = 12;
                for (LevelTerminalEntry entry : this.visibleEntries) {
                    this.height += entry.guiHeight;
                }
            }
            this.isDirty = false;
        }

        public void refreshVisible() {
            this.visibleEntries.clear();
            String output = GuiLevelTerminal.this.searchFieldOutputs.getText().toLowerCase();
            for (LevelTerminalEntry entry : this.entries) {
                entry.dispY = -9999;
                if (!output.isEmpty()) {
                    boolean shouldAdd = false;
                    for (int i = 0; i < entry.infoList.length; ++i) {
                        if (entry.infoList[i] == null) {
                            entry.filteredRecipes[i] = true;
                            continue;
                        }
                        if (GuiLevelTerminal.this.itemStackMatchesSearchTerm(entry.infoList[i].stack, output)) {
                            shouldAdd = true;
                            entry.filteredRecipes[i] = false;
                            continue;
                        }
                        entry.filteredRecipes[i] = true;
                    }
                    if (!shouldAdd) {
                        continue;
                    }
                } else {
                    Arrays.fill(entry.filteredRecipes, false);
                }
                this.visibleEntries.add(entry);
            }
        }

        public void addEntry(LevelTerminalEntry entry) {
            this.entries.add(entry);
            entry.section = this;
            this.isDirty = true;
        }

        public void removeEntry(LevelTerminalEntry entry) {
            this.entries.remove(entry);
            entry.section = null;
            this.isDirty = true;
        }

        public Iterator<LevelTerminalEntry> getVisible() {
            if (this.isDirty) {
                this.update();
            }
            return this.visibleEntries.iterator();
        }

        public boolean mouseClicked(int relMouseX, int relMouseY, int btn) {
            Iterator<LevelTerminalEntry> it = this.getVisible();
            boolean ret = false;
            while (it.hasNext() && !ret) {
                ret = it.next().mouseClicked(relMouseX, relMouseY, btn);
            }
            return ret;
        }
    }

    private class LevelTerminalEntry {
        String customName;
        GuiFCImgButton highlightButton;
        GuiFCImgButton renameButton;
        GuiFCImgButton configButton;
        LevelTerminalSection section;
        long id;
        int x;
        int y;
        int z;
        int dim;
        int side;
        int rows;
        int rowSize;
        int guiHeight;
        int dispY = -9999;
        boolean[] filteredRecipes;
        LevelItemInfo[] infoList;

        LevelTerminalEntry(long id, String name, int rows, int rowSize, boolean online) {
            String fallback;
            this.id = id;
            this.rows = rows;
            this.rowSize = rowSize;
            this.customName = StatCollector.func_94522_b((String)name) ? StatCollector.func_74838_a((String)name) : (StatCollector.func_94522_b((String)(fallback = name + ".name")) ? StatCollector.func_74838_a((String)fallback) : StatCollector.func_150826_b((String)name));
            this.highlightButton = new GuiFCImgButton(1, 0, "HIGHLIGHT", "YES");
            this.renameButton = new GuiFCImgButton(1, 0, "EDIT", "YES");
            this.configButton = new GuiFCImgButton(1, 0, "CONFIG", "YES");
            this.guiHeight = 18 * rows + 1;
            this.filteredRecipes = new boolean[rows * rowSize];
        }

        LevelTerminalEntry setLocation(int x, int y, int z, int dim, int side) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.dim = dim;
            this.side = side;
            return this;
        }

        LevelTerminalEntry setInfoList(LevelItemInfo[] infoList) {
            this.infoList = infoList;
            return this;
        }

        public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
            if (!this.section.visible || mouseButton < 0 || mouseButton > 2) {
                return false;
            }
            if (mouseX >= this.highlightButton.field_146128_h && mouseX < 2 + this.highlightButton.field_146120_f && mouseY > Math.max(this.highlightButton.field_146129_i, 12) && mouseY <= Math.min(this.highlightButton.field_146129_i + this.highlightButton.field_146121_g, GuiLevelTerminal.this.viewHeight)) {
                this.highlightButton.func_146113_a(GuiLevelTerminal.this.field_146297_k.func_147118_V());
                Util.DimensionalCoordSide blockPos = new Util.DimensionalCoordSide(this.x, this.y, this.z, this.dim, ForgeDirection.getOrientation((int)this.side), "");
                if (GuiScreen.func_146271_m() && GuiScreen.func_146272_n() && ItemWirelessUltraTerminal.hasInfinityBoosterCard((EntityPlayer)GuiLevelTerminal.this.field_146297_k.field_71439_g)) {
                    FluidCraft.proxy.netHandler.sendToServer(new CPacketLevelTerminalCommands(CPacketLevelTerminalCommands.Action.EDIT, blockPos.x, blockPos.y, blockPos.z, blockPos.getDimension(), blockPos.getSide()));
                } else if (GuiScreen.func_146272_n()) {
                    FluidCraft.proxy.netHandler.sendToServer(new CPacketRenamer(blockPos.x, blockPos.y, blockPos.z, blockPos.getDimension(), blockPos.getSide()));
                } else {
                    BlockPosHighlighter.highlightBlocks((EntityPlayer)GuiLevelTerminal.this.field_146297_k.field_71439_g, Collections.singletonList(blockPos), (String)PlayerMessages.LevelEmitterHighlighted.getUnlocalized(), (String)PlayerMessages.LevelEmitterInAnotherDim.getUnlocalized());
                    GuiLevelTerminal.this.field_146297_k.field_71439_g.func_71053_j();
                }
                return true;
            }
            int offsetY = mouseY - this.dispY;
            int offsetX = mouseX - (174 - this.rowSize * 18) - 1;
            if (offsetX >= 0 && offsetX < this.rowSize * 18 && mouseY > Math.max(this.dispY, 12) && offsetY < Math.min(GuiLevelTerminal.this.viewHeight - this.dispY, this.guiHeight)) {
                InventoryAction action;
                int col = offsetX / 18;
                int row = offsetY / 18;
                int slotIdx = row * this.rowSize + col;
                switch (mouseButton) {
                    case 0: {
                        InventoryAction inventoryAction = null;
                        break;
                    }
                    case 1: {
                        InventoryAction inventoryAction = null;
                        break;
                    }
                    case 2: {
                        InventoryAction inventoryAction;
                        if (GuiLevelTerminal.this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) {
                            inventoryAction = InventoryAction.CREATIVE_DUPLICATE;
                            break;
                        }
                        inventoryAction = InventoryAction.AUTO_CRAFT;
                        break;
                    }
                    default: {
                        InventoryAction inventoryAction = action = null;
                    }
                }
                if (action != null && this.infoList[slotIdx] != null) {
                    AEItemStack aeStack = AEItemStack.create((ItemStack)this.infoList[slotIdx].stack);
                    ((AEBaseContainer)GuiLevelTerminal.this.field_147002_h).setTargetStack((IAEItemStack)aeStack);
                    FluidCraft.proxy.netHandler.sendToServer(new CPacketInventoryAction(action, slotIdx, 0, (IAEItemStack)aeStack));
                }
                return true;
            }
            return false;
        }
    }
}

