/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory.manipulators;

import forestry.core.inventory.filters.IStackFilter;
import forestry.core.inventory.wrappers.IInvSlot;
import forestry.core.inventory.wrappers.InventoryIterator;
import forestry.core.utils.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InventoryManipulator {
    private final IInventory inv;

    public static InventoryManipulator get(IInventory inv) {
        return new InventoryManipulator(inv);
    }

    protected InventoryManipulator(IInventory inv) {
        this.inv = inv;
    }

    protected Iterable<IInvSlot> getSlots() {
        return InventoryIterator.getIterable(this.inv);
    }

    public boolean canAddStack(ItemStack stack) {
        return this.tryAddStack(stack) == null;
    }

    public ItemStack tryAddStack(ItemStack stack) {
        return this.addStack(stack, false);
    }

    public ItemStack addStack(ItemStack stack) {
        return this.addStack(stack, true);
    }

    private ItemStack addStack(ItemStack stack, boolean doAdd) {
        if (stack == null || stack.field_77994_a <= 0) {
            return null;
        }
        stack = stack.func_77946_l();
        ArrayList<IInvSlot> filledSlots = new ArrayList<IInvSlot>(this.inv.func_70302_i_());
        ArrayList<IInvSlot> emptySlots = new ArrayList<IInvSlot>(this.inv.func_70302_i_());
        for (IInvSlot slot : InventoryIterator.getIterable(this.inv)) {
            if (!slot.canPutStackInSlot(stack)) continue;
            if (slot.getStackInSlot() == null) {
                emptySlots.add(slot);
                continue;
            }
            filledSlots.add(slot);
        }
        int injected = 0;
        injected = this.tryPut(filledSlots, stack, injected, doAdd);
        injected = this.tryPut(emptySlots, stack, injected, doAdd);
        stack.field_77994_a -= injected;
        if (stack.field_77994_a <= 0) {
            return null;
        }
        return stack;
    }

    private int tryPut(List<IInvSlot> slots, ItemStack stack, int injected, boolean doAdd) {
        if (injected >= stack.field_77994_a) {
            return injected;
        }
        for (IInvSlot slot : slots) {
            int used;
            ItemStack stackInSlot = slot.getStackInSlot();
            if (stackInSlot != null && !InventoryUtil.isItemEqual(stackInSlot, stack) || (used = this.addToSlot(slot, stack, stack.field_77994_a - injected, doAdd)) <= 0 || (injected += used) < stack.field_77994_a) continue;
            return injected;
        }
        return injected;
    }

    private int addToSlot(IInvSlot slot, ItemStack stack, int available, boolean doAdd) {
        int max = Math.min(stack.func_77976_d(), this.inv.func_70297_j_());
        ItemStack stackInSlot = slot.getStackInSlot();
        if (stackInSlot == null) {
            int wanted = Math.min(available, max);
            if (doAdd) {
                stackInSlot = stack.func_77946_l();
                stackInSlot.field_77994_a = wanted;
                slot.setStackInSlot(stackInSlot);
            }
            return wanted;
        }
        if (!InventoryUtil.isItemEqual(stack, stackInSlot)) {
            return 0;
        }
        int wanted = max - stackInSlot.field_77994_a;
        if (wanted <= 0) {
            return 0;
        }
        if (wanted > available) {
            wanted = available;
        }
        if (doAdd) {
            stackInSlot.field_77994_a += wanted;
            slot.setStackInSlot(stackInSlot);
        }
        return wanted;
    }

    public boolean canRemoveItem(IStackFilter filter) {
        return this.tryRemoveItem(filter) == null;
    }

    public ItemStack tryRemoveItem(IStackFilter filter) {
        for (IInvSlot slot : this.getSlots()) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || !slot.canTakeStackFromSlot(stack) || !filter.matches(stack)) continue;
            ItemStack output = stack.func_77946_l();
            output.field_77994_a = 1;
            return output;
        }
        return null;
    }

    public ItemStack removeItem(IStackFilter filter) {
        for (IInvSlot slot : this.getSlots()) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || !slot.canTakeStackFromSlot(stack) || !filter.matches(stack)) continue;
            return slot.decreaseStackInSlot();
        }
        return null;
    }

    public ItemStack moveItem(IInventory dest, IStackFilter filter) {
        InventoryManipulator imDest = InventoryManipulator.get(dest);
        for (IInvSlot slot : this.getSlots()) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || !slot.canTakeStackFromSlot(stack) || !filter.matches(stack)) continue;
            stack = stack.func_77946_l();
            stack.field_77994_a = 1;
            if ((stack = imDest.addStack(stack)) != null) continue;
            return slot.decreaseStackInSlot();
        }
        return null;
    }
}

