/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.network.packet;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerPatternTerm;
import appeng.helpers.IContainerCraftingPacket;
import com.github.vfyjxf.nee.utils.ItemUtils;
import com.glodblock.github.client.gui.container.ContainerFluidPatternTerminal;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PacketNEIPatternRecipe
implements IMessage {
    NBTTagCompound input;
    NBTTagCompound output;

    public PacketNEIPatternRecipe() {
    }

    public PacketNEIPatternRecipe(@Nonnull NBTTagCompound input, NBTTagCompound output) {
        this.input = input;
        this.output = output;
    }

    public void fromBytes(ByteBuf buf) {
        this.input = ByteBufUtils.readTag((ByteBuf)buf);
        if (buf.readBoolean()) {
            this.output = ByteBufUtils.readTag((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.input);
        if (this.output != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.output);
        } else {
            buf.writeBoolean(false);
        }
    }

    public static final class Handler
    implements IMessageHandler<PacketNEIPatternRecipe, IMessage> {
        public IMessage onMessage(PacketNEIPatternRecipe message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container container = player.field_71070_bA;
            if (message.input != null && container instanceof AEBaseContainer && container instanceof IContainerCraftingPacket) {
                AEBaseContainer baseContainer = (AEBaseContainer)container;
                this.setCraftingRecipe(baseContainer, message.output == null);
                if (message.output == null) {
                    this.craftingRecipe(baseContainer, message);
                } else {
                    this.processRecipe(baseContainer, message);
                }
            }
            return null;
        }

        private void setCraftingRecipe(AEBaseContainer container, boolean craftingMode) {
            if (container instanceof ContainerPatternTerm) {
                ContainerPatternTerm cpt = (ContainerPatternTerm)container;
                cpt.getPatternTerminal().setCraftingRecipe(craftingMode);
            } else if (Loader.isModLoaded((String)"ae2fc") && container instanceof ContainerFluidPatternTerminal) {
                ContainerFluidPatternTerminal cfpt = (ContainerFluidPatternTerminal)container;
                cfpt.getPatternTerminal().setCraftingRecipe(craftingMode);
            }
        }

        private ItemStack[] getMatrix(NBTTagCompound items, String prefix, int size) {
            ItemStack[] matrix = new ItemStack[size];
            for (int i = 0; i < size; ++i) {
                NBTTagCompound currentStack = (NBTTagCompound)items.func_74781_a(prefix + i);
                matrix[i] = currentStack == null ? null : ItemUtils.loadItemStackFromNBT(currentStack);
            }
            return matrix;
        }

        private void craftingRecipe(AEBaseContainer container, PacketNEIPatternRecipe message) {
            IContainerCraftingPacket cct = (IContainerCraftingPacket)container;
            IGridNode node = cct.getNetworkNode();
            if (node == null) {
                return;
            }
            IGrid grid = node.getGrid();
            if (grid == null) {
                return;
            }
            IStorageGrid inv = (IStorageGrid)grid.getCache(IStorageGrid.class);
            ISecurityGrid security = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
            IInventory craftMatrix = cct.getInventoryByName("crafting");
            if (inv != null && craftMatrix != null && security != null) {
                ItemStack[] recipeInput = this.getMatrix(message.input, "#", craftMatrix.func_70302_i_());
                for (int i = 0; i < recipeInput.length; ++i) {
                    craftMatrix.func_70299_a(i, recipeInput[i]);
                }
                container.func_75130_a(craftMatrix);
            }
        }

        private void processRecipe(AEBaseContainer container, PacketNEIPatternRecipe message) {
            IContainerCraftingPacket cct = (IContainerCraftingPacket)container;
            IGridNode node = cct.getNetworkNode();
            if (node == null) {
                return;
            }
            IGrid grid = node.getGrid();
            if (grid == null) {
                return;
            }
            IStorageGrid inv = (IStorageGrid)grid.getCache(IStorageGrid.class);
            ISecurityGrid security = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
            IInventory craftMatrix = cct.getInventoryByName("crafting");
            IInventory outputMatrix = cct.getInventoryByName("output");
            if (inv != null && craftMatrix != null && outputMatrix != null && security != null) {
                int i;
                ItemStack[] recipeInput = this.getMatrix(message.input, "#", craftMatrix.func_70302_i_());
                ItemStack[] recipeOutput = this.getMatrix(message.output, "Outputs", outputMatrix.func_70302_i_());
                for (i = 0; i < recipeInput.length; ++i) {
                    craftMatrix.func_70299_a(i, recipeInput[i]);
                }
                for (i = 0; i < recipeOutput.length; ++i) {
                    outputMatrix.func_70299_a(i, recipeOutput[i]);
                }
                container.func_75130_a(craftMatrix);
                container.func_75130_a(outputMatrix);
            }
        }
    }
}

