/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.client.utils;

import blockrenderer6343.client.utils.BRButton;
import blockrenderer6343.client.utils.BRUtil;
import cpw.mods.fml.client.config.GuiUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public class GuiSlider
extends BRButton {
    private int maxValue;
    private int minValue;
    private int value;
    private boolean dragging;
    private IntConsumer valueListener;
    private IntSupplier maxValueSupplier;
    private Int2ObjectFunction<String> valueStringSupplier;
    public final String name;
    private float scale;
    private final int originalHeight;

    public GuiSlider(String name, int x, int y, int width, int height, int value, int minValue, int maxValue) {
        super(0, x, y, width, height, "");
        this.name = name;
        this.value = value;
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.originalHeight = height;
    }

    public GuiSlider(String name, int x, int y, int width, int height, int value, int minValue) {
        this(name, x, y, width, height, value, minValue, 0);
    }

    public GuiSlider setMaxValueSupplier(@NotNull IntSupplier supplier) {
        this.maxValueSupplier = supplier;
        return this;
    }

    public GuiSlider setValueListener(@NotNull IntConsumer listener) {
        this.valueListener = listener;
        return this;
    }

    public GuiSlider setTextSupplier(@NotNull Int2ObjectFunction<String> supplier) {
        this.valueStringSupplier = supplier;
        return this;
    }

    public int func_146114_a(boolean mouseOver) {
        return 0;
    }

    public int getMaxValue() {
        return this.maxValueSupplier == null ? this.maxValue : this.maxValueSupplier.getAsInt();
    }

    @Override
    public void scalePosition(int scaledGuiHeight, float scale) {
        this.scale = scale;
        this.field_146121_g = Math.round((float)this.originalHeight * scale);
        this.field_146129_i = Math.round(153.0f * scale + (float)((this.field_146121_g + 1) * this.index));
    }

    public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
        this.maxValue = this.getMaxValue();
        mc.field_71446_o.func_110577_a(field_146122_a);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        super.func_146112_a(mc, mouseX, mouseY);
        float sliderValue = this.minValue == this.maxValue ? 1.0f : (float)(this.value - this.minValue) / (float)(this.maxValue - this.minValue);
        int pos = MathHelper.func_76125_a((int)((int)((float)this.field_146128_h + sliderValue * (float)(this.field_146120_f - 8))), (int)this.field_146128_h, (int)(this.field_146128_h + this.field_146120_f - 8));
        GuiUtils.drawContinuousTexturedBox((int)pos, (int)this.field_146129_i, (int)0, (int)66, (int)8, (int)this.field_146121_g, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)0.0f);
        BRUtil.drawCenteredScaledString(this.getText(mc.field_71466_p), (double)this.field_146128_h + (double)this.field_146120_f / 2.0, (float)(this.field_146129_i - 1 + this.field_146121_g) - (float)mc.field_71466_p.field_78288_b * this.scale, this.isMouseOver(mouseX, mouseY) ? 0xFFFFA0 : 0xE0E0E0, this.scale);
    }

    public void setValue(int newValue) {
        this.setValue(newValue, true);
    }

    public void setValue(int newValue, boolean notify) {
        this.value = MathHelper.func_76125_a((int)newValue, (int)this.minValue, (int)this.maxValue);
        if (notify && this.valueListener != null) {
            this.valueListener.accept(this.value);
        }
    }

    public void setValueFromMouse(int mouseX) {
        this.setValue(Math.round((float)this.minValue + (float)(this.maxValue - this.minValue) * (float)(mouseX - this.field_146128_h + 4) / (float)(this.field_146120_f - 8)));
    }

    public String getText(FontRenderer font) {
        String val = ": " + (this.valueStringSupplier == null ? this.value + "" : (String)this.valueStringSupplier.apply(this.value));
        String trimmed = font.func_78269_a(this.name, (int)((float)this.field_146120_f / this.scale) - font.func_78256_a(val));
        return trimmed + val;
    }

    @Override
    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        this.setValueFromMouse(mouseX);
        this.dragging = true;
        GuiSlider.playClickSound();
        return true;
    }

    @Override
    public void mouseDragged(int mousePosX, int mousePosY) {
        if (this.dragging) {
            this.setValueFromMouse(mousePosX);
        }
    }

    @Override
    public boolean mouseScrolled(int mouseX, int mouseY, int scroll) {
        if (scroll == 0 || !this.isMouseOver(mouseX, mouseY) && !this.dragging) {
            return false;
        }
        if (scroll > 0) {
            this.setValue(this.value + 1);
        } else {
            this.setValue(this.value - 1);
        }
        return true;
    }

    public void func_146118_a(int mouseX, int mouseY) {
        this.dragging = false;
    }
}

