/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.load.gui;

import alexiil.mods.load.BetterLoadingScreen;
import alexiil.mods.load.git.Commit;
import alexiil.mods.load.git.Release;
import alexiil.mods.load.gui.BaseConfig;
import alexiil.mods.load.gui.TextGuiScrollingList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;

public class CommitScrollingList
extends TextGuiScrollingList {
    public final List<Commit> commitList = new ArrayList<Commit>();
    public final BaseConfig parent;

    public CommitScrollingList(BaseConfig parent, int width, int height, int top, int bottom, int left) {
        super(Minecraft.func_71410_x(), width, height, top, bottom, left);
        this.parent = parent;
        this.populateStrings();
    }

    private void populateStrings() {
        this.clearLines();
        List<Commit> commitList = BetterLoadingScreen.getCommits();
        for (Commit c : commitList) {
            boolean thisOne = c == BetterLoadingScreen.getCurrentCommit();
            Release release = null;
            for (Release rel : BetterLoadingScreen.getReleases()) {
                if (!rel.commit.sha.equals(c.sha)) continue;
                release = rel;
            }
            String date = c.commit.committer.date.split("T")[0];
            String[] dates = date.split("-");
            date = dates[2] + "/" + dates[1] + "/" + dates[0];
            String text = c.author.login + " " + date;
            TextGuiScrollingList.LineInfo line0 = new TextGuiScrollingList.LineInfo(text, thisOne ? 12563002 : 51967);
            TextGuiScrollingList.LineInfo line1 = release == null ? null : new TextGuiScrollingList.LineInfo(release.name, 0x11FF44, this.parent.getFontRenderer().func_78256_a(text) + 10);
            this.addLine(line0, line1);
            String message = c.commit.message;
            String[] strings = message.split("\n");
            for (int i = 0; i < strings.length; ++i) {
                String s;
                String nextLine = "";
                for (s = strings[i]; this.parent.getFontRenderer().func_78256_a(s) > this.listWidth - 10 && s != null && s.length() > 10; s = s.substring(0, s.length() - 1)) {
                    nextLine = s.substring(s.length() - 1) + nextLine;
                }
                if (nextLine.length() <= 0) continue;
                strings = Arrays.copyOf(strings, strings.length + 1);
                strings[i] = s;
                strings[i + 1] = nextLine;
            }
            for (String s : strings) {
                this.addLine(new TextGuiScrollingList.LineInfo(s, thisOne ? 16768329 : 0xFFFFFF, 4));
            }
            this.addLine(new TextGuiScrollingList.LineInfo(""));
        }
    }
}

