/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.states;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.stacks.BooleanStateStack;
import com.gtnewhorizons.angelica.glsm.stacks.TextureBindingStack;
import lombok.Generated;
import org.joml.Matrix4fStack;

public class TextureUnitArray {
    private final TextureBindingStack[] bindings = new TextureBindingStack[GLStateManager.MAX_TEXTURE_UNITS];
    private final BooleanStateStack[] states = new BooleanStateStack[GLStateManager.MAX_TEXTURE_UNITS];
    public final Matrix4fStack[] textureMatricies = new Matrix4fStack[GLStateManager.MAX_TEXTURE_UNITS];

    public TextureUnitArray() {
        for (int i = 0; i < GLStateManager.MAX_TEXTURE_UNITS; ++i) {
            this.bindings[i] = new TextureBindingStack();
            this.states[i] = new BooleanStateStack(3553);
            this.textureMatricies[i] = new Matrix4fStack(GLStateManager.MAX_TEXTURE_STACK_DEPTH);
        }
    }

    public TextureBindingStack getTextureUnitBindings(int index) {
        return this.bindings[index];
    }

    public BooleanStateStack getTextureUnitStates(int index) {
        return this.states[index];
    }

    public Matrix4fStack getTextureUnitMatrix(int index) {
        return this.textureMatricies[index];
    }

    public boolean equals(Object state) {
        if (this == state) {
            return true;
        }
        if (!(state instanceof TextureUnitArray)) {
            return false;
        }
        TextureUnitArray textureUnitArray = (TextureUnitArray)state;
        for (int i = 0; i < GLStateManager.MAX_TEXTURE_UNITS; ++i) {
            if (!this.bindings[i].sameAs(textureUnitArray.bindings[i])) {
                return false;
            }
            if (this.states[i].sameAs(textureUnitArray.states[i])) continue;
            return false;
        }
        return true;
    }

    @Generated
    public Matrix4fStack[] getTextureMatricies() {
        return this.textureMatricies;
    }
}

