/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render;

import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.littletiles.client.LittleTilesClient;
import com.creativemd.littletiles.client.render.ITilesRenderer;
import com.creativemd.littletiles.client.render.LittleTilesBlockRenderHelper;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import com.creativemd.littletiles.utils.TileList;
import com.gtnewhorizons.angelica.api.ThreadSafeISBRH;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
@ThreadSafeISBRH(perThread=true)
public class SpecialBlockTilesRenderer
extends TileEntitySpecialRenderer
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityLittleTiles) {
            TileEntityLittleTiles little = (TileEntityLittleTiles)tileEntity;
            TileList<LittleTile> tiles = little.getTiles();
            for (LittleTile tile : tiles) {
                ArrayList<CubeObject> cubes = tile.getRenderingCubes();
                LittleTilesBlockRenderHelper.renderCubes(world, cubes, x, y, z, block, renderer, null);
            }
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return LittleTilesClient.modelID;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return item.func_77973_b() instanceof ITilesRenderer && item.field_77990_d != null;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (item.func_77973_b() instanceof ITilesRenderer) {
            Minecraft mc = Minecraft.func_71410_x();
            GL11.glAlphaFunc((int)516, (float)0.1f);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
            if (type == IItemRenderer.ItemRenderType.INVENTORY) {
                if (((ITilesRenderer)item.func_77973_b()).hasBackground(item)) {
                    RenderItem.getInstance().func_77015_a(mc.field_71466_p, mc.field_71446_o, item, 0, 0);
                }
                GL11.glTranslatef((float)7.5f, (float)7.5f, (float)10.0f);
                GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
                GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
                GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
            }
            mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            ArrayList<CubeObject> cubes = ((ITilesRenderer)item.func_77973_b()).getRenderingCubes(item);
            Vec3 size = CubeObject.getSizeOfCubes(cubes);
            double largestSide = Math.max(size.field_72450_a, Math.max(size.field_72448_b, size.field_72449_c));
            if (largestSide > 1.0) {
                double scaler = 1.0 / largestSide;
                GL11.glScaled((double)scaler, (double)scaler, (double)scaler);
                GL11.glTranslated((double)(0.5 - largestSide / 2.0), (double)(0.5 - largestSide / 2.0), (double)(0.5 - largestSide / 2.0));
            }
            LittleTilesBlockRenderHelper.renderInventoryCubes((RenderBlocks)data[0], cubes, Block.func_149634_a((Item)item.func_77973_b()), item.func_77960_j());
        }
    }

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float partialTime) {
        if (tileEntity instanceof TileEntityLittleTiles) {
            TileEntityLittleTiles te = (TileEntityLittleTiles)tileEntity;
            for (int i = 0; i < te.customRenderingTiles.size(); ++i) {
                LittleTileVec cornerVec = te.customRenderingTiles.get((int)i).cornerVec;
                te.customRenderingTiles.get(i).renderTick(x + cornerVec.getPosX(), y + cornerVec.getPosY(), z + cornerVec.getPosZ(), partialTime);
            }
        }
    }
}

