/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui.teams;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import serverutils.lib.EnumTeamColor;
import serverutils.lib.client.ClientUtils;
import serverutils.lib.gui.Button;
import serverutils.lib.gui.GuiBase;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.gui.SimpleTextButton;
import serverutils.lib.gui.TextBox;
import serverutils.lib.gui.Theme;
import serverutils.lib.icon.Icon;
import serverutils.lib.math.MathUtils;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.misc.MouseButton;

public class GuiCreateTeam
extends GuiBase {
    private EnumTeamColor color;
    private final Button buttonAccept;
    private final Button buttonCancel;
    private final List<Button> colorButtons;
    private final TextBox textBoxId;

    public GuiCreateTeam() {
        this.setSize(162, 118);
        this.color = EnumTeamColor.NAME_MAP.getRandom(MathUtils.RAND);
        int bwidth = this.width / 2 - 10;
        this.buttonAccept = new SimpleTextButton(this, I18n.func_135052_a((String)"gui.accept", (Object[])new Object[0]), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                if (!GuiCreateTeam.this.textBoxId.getText().isEmpty()) {
                    this.getGui().closeGui(false);
                    ClientUtils.execClientCommand("/team create " + GuiCreateTeam.this.textBoxId.getText() + " " + GuiCreateTeam.this.color.getName());
                }
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonAccept.setPosAndSize(this.width - bwidth - 9, this.height - 24, bwidth, 16);
        this.buttonCancel = new SimpleTextButton(this, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                this.getGui().closeGui();
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonCancel.setPosAndSize(8, this.height - 24, bwidth, 16);
        this.textBoxId = new TextBox(this){

            @Override
            public void onTextChanged() {
                this.setText(StringUtils.getID(this.getText(), 14), false);
            }
        };
        this.textBoxId.setPosAndSize(8, 8, this.width - 16, 16);
        this.textBoxId.writeText(Minecraft.func_71410_x().field_71439_g.func_146103_bH().getName().toLowerCase());
        this.textBoxId.ghostText = "Enter ID";
        this.textBoxId.textColor = this.color.getColor();
        this.textBoxId.setFocused(true);
        this.textBoxId.charLimit = 35;
        this.colorButtons = new ArrayList<Button>();
        int i = 0;
        for (final EnumTeamColor col : EnumTeamColor.NAME_MAP) {
            Button b = new Button(this){

                @Override
                public void onClicked(MouseButton button) {
                    GuiCreateTeam.this.color = col;
                    ((GuiCreateTeam)GuiCreateTeam.this).textBoxId.textColor = GuiCreateTeam.this.color.getColor();
                }

                @Override
                public void drawBackground(Theme theme, int x, int y, int w, int h) {
                    theme.drawPanelBackground(x, y, w, h);
                    col.getColor().withAlpha(GuiCreateTeam.this.color == col || this.isMouseOver() ? 200 : 100).draw(x, y, w, h);
                }
            };
            b.setPosAndSize(8 + i % 5 * 30, 32 + i / 5 * 30, 25, 25);
            b.setTitle(col.getEnumChatFormatting() + I18n.func_135052_a((String)col.getLangKey(), (Object[])new Object[0]));
            this.colorButtons.add(b);
            ++i;
        }
    }

    @Override
    public void addWidgets() {
        this.add(this.buttonAccept);
        this.add(this.buttonCancel);
        this.addAll(this.colorButtons);
        this.add(this.textBoxId);
    }
}

