/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.items;

import cpw.mods.fml.common.registry.GameRegistry;
import eu.usrv.yamcore.YAMCore;
import eu.usrv.yamcore.auxiliary.LogHelper;
import eu.usrv.yamcore.creativetabs.CreativeTabsManager;
import eu.usrv.yamcore.iface.IExtendedModItem;
import eu.usrv.yamcore.items.ModSimpleBaseItem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;

public class ModItemManager {
    public Map<String, ModSimpleBaseItem> ItemCollection = null;
    private final LogHelper _mLog = YAMCore.instance.getLogger();
    private final String _mModID;

    public ModItemManager(String pModID) {
        this.ItemCollection = new HashMap<String, ModSimpleBaseItem>();
        this._mModID = pModID;
    }

    public Item GetModItem(ModSimpleBaseItem pModItem) {
        return this.GetModItem(pModItem.getUnlocItemName());
    }

    public Item GetModItem(String pModItemName) {
        if (this.ItemCollection.containsKey(pModItemName)) {
            return this.ItemCollection.get(pModItemName).getConstructedItem();
        }
        return null;
    }

    public boolean AddItemToManagedRegistry(ModSimpleBaseItem pModItem) {
        if (this.GetModItem(pModItem) == null) {
            this.ItemCollection.put(pModItem.getUnlocItemName(), pModItem);
            return true;
        }
        return false;
    }

    public boolean RegisterItems(CreativeTabsManager pTabManager) {
        try {
            for (ModSimpleBaseItem modItem : this.ItemCollection.values()) {
                try {
                    CreativeTabs tTargetTab = pTabManager.GetCreativeTabInstance(modItem.getCreativeTabName());
                    if (tTargetTab == null) {
                        this._mLog.warn(String.format("CreativeTab name %s requested, but not registered in TabManager. Adding item %s to Tab 'Misc'", modItem.getCreativeTabName(), modItem.getConstructedItem().func_77658_a()));
                        modItem.setCreativeTab(CreativeTabs.field_78026_f);
                    } else {
                        modItem.setCreativeTab(tTargetTab);
                    }
                    Item modItemItem = modItem.getConstructedItem();
                    String unlocName = modItemItem.func_77658_a();
                    this._mLog.debug(String.format("Item: %s ItemName: %s", modItemItem, unlocName));
                    GameRegistry.registerItem((Item)modItem.getConstructedItem(), (String)modItem.getConstructedItem().func_77658_a());
                }
                catch (Exception e) {
                    this._mLog.error(String.format("Error while registering item %s, skipping", modItem.getUnlocItemName()));
                    this._mLog.DumpStack(e);
                }
            }
            return true;
        }
        catch (Exception e) {
            this._mLog.error(String.format("Error while registering items", new Object[0]));
            this._mLog.DumpStack(e);
            return false;
        }
    }

    public <T extends Item> boolean RegisterNonEnumItem(CreativeTabsManager pTabManager, IExtendedModItem<T> pModItem) {
        try {
            CreativeTabs tTargetTab = pTabManager.GetCreativeTabInstance(pModItem.getCreativeTabName());
            if (tTargetTab == null) {
                this._mLog.warn(String.format("CreativeTab name %s requested, but not registered in TabManager. Adding item %s to Tab 'Misc'", pModItem.getCreativeTabName(), pModItem.getConstructedItem().func_77658_a()));
                tTargetTab = CreativeTabs.field_78026_f;
            }
            pModItem.getConstructedItem().func_77637_a(tTargetTab);
            GameRegistry.registerItem(pModItem.getConstructedItem(), (String)pModItem.getUnlocalizedNameForRegistration());
            return true;
        }
        catch (Exception e) {
            this._mLog.error(String.format("Error while registering item %s", pModItem.getUnlocalizedNameForRegistration()));
            this._mLog.DumpStack(e);
            return false;
        }
    }
}

