/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.config;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.layout.ILayoutWidget;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.DrawableStack;
import com.cleanroommc.modularui.drawable.GuiTextures;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntConsumer;
import org.jetbrains.annotations.NotNull;

public class AvailableListItem<T>
extends Widget<AvailableListItem<T>>
implements ILayoutWidget {
    private final T value;
    private final Widget<?> content;
    private IWidget moveButton;
    private IDrawable unavailableTexture;
    private IDrawable availableTexture;
    private IntConsumer moveConsumer;
    private boolean available = true;
    private final List<IWidget> children = new ArrayList<IWidget>();

    public AvailableListItem(T value, Widget<?> content) {
        this.value = value;
        this.content = content;
    }

    public void onInit() {
        this.moveButton = new ButtonWidget().onMousePressed(mouseButton -> {
            if (this.isAvailable()) {
                this.moveConsumer.accept(mouseButton);
                this.setAvailable(false);
                return true;
            }
            return false;
        }).background(new IDrawable[]{GuiTextures.BUTTON_CLEAN});
        this.children.add((IWidget)this.content);
        this.children.add(this.moveButton);
        if (this.unavailableTexture == null && this.content.getBackground() != null) {
            this.unavailableTexture = this.content.getBackground();
        }
        if (this.availableTexture == null && this.content.getBackground() != null) {
            this.availableTexture = this.content.getBackground();
        }
        this.content.background(new IDrawable[]{this.available ? this.availableTexture : this.unavailableTexture});
    }

    public void layoutWidgets() {
        this.moveButton.getArea().setSize(10, Math.max(this.content.getArea().height, 20));
        this.moveButton.getArea().rx = this.content.getArea().width;
        this.moveButton.getArea().ry = this.content.getArea().height / 2 - this.moveButton.getArea().height / 2;
    }

    @NotNull
    public List<IWidget> getChildren() {
        return this.children;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public IDrawable getBackground() {
        return this.available ? this.availableTexture : this.unavailableTexture;
    }

    public AvailableListItem<T> setUnavailableBackground(IDrawable ... unavailableTexture) {
        this.unavailableTexture = unavailableTexture.length == 0 ? null : (unavailableTexture.length == 1 ? unavailableTexture[0] : new DrawableStack(unavailableTexture));
        return this;
    }

    public AvailableListItem<T> setAvailableBackground(IDrawable ... availableTexture) {
        this.availableTexture = availableTexture.length == 0 ? null : (availableTexture.length == 1 ? availableTexture[0] : new DrawableStack(availableTexture));
        return this;
    }

    public AvailableListItem<T> setMoveConsumer(IntConsumer moveConsumer) {
        this.moveConsumer = moveConsumer;
        return this;
    }

    public AvailableListItem<T> setAvailable(boolean available) {
        this.available = available;
        if (this.isValid()) {
            this.content.background(new IDrawable[]{available ? this.availableTexture : this.unavailableTexture});
        }
        return this;
    }
}

