/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.transport;

import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.pipe.PipeFluidUpdate;
import logisticspipes.pipes.basic.fluid.FluidRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.transport.PipeTransportLogistics;
import logisticspipes.utils.SafeTimeTracker;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class PipeFluidTransportLogistics
extends PipeTransportLogistics
implements IFluidHandler {
    public FluidTank[] sideTanks = new FluidTank[ForgeDirection.VALID_DIRECTIONS.length];
    public FluidTank internalTank = new FluidTank(this.getInnerCapacity());
    public FluidStack[] renderCache = new FluidStack[7];
    private final SafeTimeTracker tracker = new SafeTimeTracker(10L);
    private long clientSyncCounter = 30L;
    public byte initClient = 0;
    private static final ForgeDirection[] orientations = ForgeDirection.values();

    public PipeFluidTransportLogistics() {
        super(true);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.sideTanks[dir.ordinal()] = new FluidTank(this.getSideCapacity());
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (from.ordinal() < ForgeDirection.VALID_DIRECTIONS.length && this.getFluidPipe().canReceiveFluid()) {
            return this.sideTanks[from.ordinal()].fill(resource, doFill);
        }
        return 0;
    }

    private FluidRoutedPipe getFluidPipe() {
        return (FluidRoutedPipe)this.getPipe();
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.getPipe().isFluidPipe() && this.getFluidPipe().canReceiveFluid();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from.ordinal() < ForgeDirection.VALID_DIRECTIONS.length) {
            return this.sideTanks[from.ordinal()].drain(maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.sideTanks[from.ordinal()].getFluid() == null || !this.sideTanks[from.ordinal()].getFluid().isFluidEqual(resource)) {
            return new FluidStack(resource.getFluid(), 0);
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (from.ordinal() < ForgeDirection.VALID_DIRECTIONS.length) {
            return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.sideTanks[from.ordinal()])};
        }
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (!nbttagcompound.func_74764_b("tank[" + direction.ordinal() + "]")) continue;
            this.sideTanks[direction.ordinal()].readFromNBT(nbttagcompound.func_74775_l("tank[" + direction.ordinal() + "]"));
        }
        if (nbttagcompound.func_74764_b("tank[middle]")) {
            this.internalTank.readFromNBT(nbttagcompound.func_74775_l("tank[middle]"));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            NBTTagCompound subTag = new NBTTagCompound();
            this.sideTanks[direction.ordinal()].writeToNBT(subTag);
            nbttagcompound.func_74782_a("tank[" + direction.ordinal() + "]", (NBTBase)subTag);
        }
        NBTTagCompound subTag = new NBTTagCompound();
        this.internalTank.writeToNBT(subTag);
        nbttagcompound.func_74782_a("tank[middle]", (NBTBase)subTag);
    }

    public int getInnerCapacity() {
        return 10000;
    }

    public int getSideCapacity() {
        return 5000;
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            FluidStack stack;
            if (MainProxy.checkPipesConnections(this.container, this.container.getTile(orientations[direction.ordinal()]), orientations[direction.ordinal()])) continue;
            if (MainProxy.isServer(this.getWorld()) && (stack = this.sideTanks[direction.ordinal()].getFluid()) != null) {
                this.sideTanks[direction.ordinal()].setFluid(null);
                this.internalTank.fill(stack, true);
            }
            if (this.renderCache[direction.ordinal()] == null) continue;
            this.renderCache[direction.ordinal()].amount = 1;
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        this.updateFluid();
    }

    private void updateFluid() {
        if (MainProxy.isClient(this.getWorld())) {
            return;
        }
        if (this.tracker.markTimeIfDelay(this.getWorld())) {
            ModernPacket packet;
            boolean init = false;
            if (++this.clientSyncCounter > 40L) {
                this.clientSyncCounter = 0L;
                init = true;
            }
            if (this.clientSyncCounter < 0L) {
                this.clientSyncCounter = 0L;
            }
            if ((packet = this.computeFluidUpdate(init, true)) != null) {
                MainProxy.sendPacketToAllWatchingChunk(this.container.field_145851_c, this.container.field_145849_e, MainProxy.getDimensionForWorld(this.getWorld()), packet);
            }
        }
    }

    private ModernPacket computeFluidUpdate(boolean initPacket, boolean persistChange) {
        boolean changed = false;
        if (this.initClient > 0) {
            this.initClient = (byte)(this.initClient - 1);
            if (this.initClient == 1) {
                changed = true;
            }
        }
        FluidStack[] renderCache = (FluidStack[])this.renderCache.clone();
        for (ForgeDirection dir : orientations) {
            FluidStack current = dir != ForgeDirection.UNKNOWN ? this.sideTanks[dir.ordinal()].getFluid() : this.internalTank.getFluid();
            FluidStack prev = renderCache[dir.ordinal()];
            if (prev == null && current == null) continue;
            if (prev == null && current != null) {
                changed = true;
                renderCache[dir.ordinal()] = current.copy();
                continue;
            }
            if (prev != null && current == null) {
                changed = true;
                renderCache[dir.ordinal()] = null;
                continue;
            }
            if (prev.getFluidID() != current.getFluidID() || initPacket) {
                changed = true;
                renderCache[dir.ordinal()] = new FluidStack(current.getFluid(), renderCache[dir.ordinal()].amount);
            }
            if (prev.amount == current.amount && !initPacket) continue;
            changed = true;
            renderCache[dir.ordinal()].amount = current.amount;
        }
        if (persistChange) {
            this.renderCache = renderCache;
        }
        if (changed || initPacket) {
            return PacketHandler.getPacket(PipeFluidUpdate.class).setRenderCache(renderCache).setPosX(this.container.field_145851_c).setPosY(this.container.field_145848_d).setPosZ(this.container.field_145849_e).setChunkDataPacket(initPacket);
        }
        return null;
    }

    @Override
    protected boolean isItemExitable(ItemIdentifierStack stack) {
        return true;
    }
}

