/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.core.impl.screen;

import com.gitlab.cdagaming.unilib.core.impl.screen.ScreenRectangle;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;
import unilib.jvmdg.api.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_SequencedCollection;

public class ScissorStack {
    private final Deque<ScreenRectangle> stack = new ArrayDeque<ScreenRectangle>();

    public ScreenRectangle push(ScreenRectangle scissor) {
        ScreenRectangle last = this.stack.peekLast();
        if (last != null) {
            ScreenRectangle intersection = scissor.intersection(last);
            ScreenRectangle lv2 = intersection != null ? intersection : ScreenRectangle.empty();
            J_U_SequencedCollection.addLast(this.stack, lv2);
            return lv2;
        }
        J_U_SequencedCollection.addLast(this.stack, scissor);
        return scissor;
    }

    @Nullable
    public ScreenRectangle pop() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Scissor stack underflow");
        }
        J_U_SequencedCollection.removeLast(this.stack);
        return this.stack.peekLast();
    }
}

