/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world.mapgen.village;

import de.katzenpapst.amunra.helper.CoordHelper;
import de.katzenpapst.amunra.mob.entity.EntityRobotVillager;
import de.katzenpapst.amunra.world.mapgen.village.GridVillageComponent;
import de.katzenpapst.amunra.world.mapgen.village.GridVillageStart;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class DomedHouseComponent
extends GridVillageComponent {
    protected int houseHeight = 5;

    @Override
    public boolean generateChunk(int chunkX, int chunkZ, Block[] blocks, byte[] metas) {
        StructureBoundingBox chunkBB = CoordHelper.getChunkBB(chunkX, chunkZ);
        int fallbackGround = this.parent.getWorldGroundLevel();
        if (this.groundLevel == -1) {
            this.groundLevel = DomedHouseComponent.getAverageGroundLevel(blocks, metas, this.getStructureBoundingBox(), chunkBB, fallbackGround);
            if (this.groundLevel == -1) {
                this.groundLevel = fallbackGround;
            }
        }
        StructureBoundingBox myBB = this.getStructureBoundingBox();
        BlockMetaPair wall = ((GridVillageStart)this.parent).getWallMaterial();
        BlockMetaPair floor = ((GridVillageStart)this.parent).getFloorMaterial();
        BlockMetaPair padding = ((GridVillageStart)this.parent).getFillMaterial();
        BlockMetaPair path = ((GridVillageStart)this.parent).getPathMaterial();
        BlockMetaPair glassPane = new BlockMetaPair(Blocks.field_150410_aZ, 0);
        BlockMetaPair air = new BlockMetaPair(Blocks.field_150350_a, 0);
        boolean startX = true;
        int stopX = myBB.func_78883_b() - 2;
        boolean startZ = true;
        int stopZ = myBB.func_78880_d() - 2;
        int xCenter = (int)Math.ceil((stopX - 1) / 2 + 1);
        int zCenter = (int)Math.ceil((stopZ - 1) / 2 + 1);
        int houseRadius = xCenter - 1;
        int houseRadiusSq = (int)Math.pow(houseRadius, 2.0);
        int wallHeight = this.houseHeight - houseRadius;
        for (int x = 1; x <= stopX; ++x) {
            for (int z = 1; z <= stopZ; ++z) {
                int y;
                double wallRadiusSq;
                int highestGroundBlock = this.getHighestSolidBlockInBB(blocks, metas, chunkX, chunkZ, x, z);
                if (highestGroundBlock == -1 || !((double)(houseRadiusSq + 1) >= (wallRadiusSq = Math.pow(xCenter - x, 2.0) + Math.pow(zCenter - z, 2.0)))) continue;
                for (y = highestGroundBlock - 1; y < this.groundLevel; ++y) {
                    this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, y, z, padding);
                }
                this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel - 1, z, floor);
                if (x == xCenter && z == zCenter) {
                    this.spawnVillager(x, this.groundLevel, z);
                }
                for (y = 0; y < wallHeight; ++y) {
                    if ((double)(houseRadiusSq - 1) <= wallRadiusSq) {
                        if (x == xCenter && z == 1 && (y == 0 || y == 1)) {
                            this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel + y, z, air);
                            continue;
                        }
                        if (((x == 1 || x == stopX) && z == zCenter || z == stopZ && x == xCenter) && y == 1) {
                            this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel + y, z, glassPane);
                            continue;
                        }
                        this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel + y, z, wall);
                        continue;
                    }
                    this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel + y, z, air);
                }
                for (y = 0; y < houseRadius; ++y) {
                    double roofRadiusSq = Math.pow(xCenter - x, 2.0) + Math.pow(zCenter - z, 2.0) + Math.pow(y + 1, 2.0) - 1.0;
                    if ((double)(houseRadiusSq + 1) >= roofRadiusSq && (double)(houseRadiusSq - 2) <= roofRadiusSq) {
                        this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel + y + wallHeight, z, wall);
                        continue;
                    }
                    if (x == 2 && z == zCenter && y == 0) {
                        this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel + y + wallHeight, z, GCBlocks.glowstoneTorch, DomedHouseComponent.rotateTorchMetadata(1, this.coordMode));
                        continue;
                    }
                    if (x == stopX - 1 && z == zCenter && y == 0) {
                        this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel + y + wallHeight, z, GCBlocks.glowstoneTorch, DomedHouseComponent.rotateTorchMetadata(2, this.coordMode));
                        continue;
                    }
                    if (z == 2 && x == xCenter && y == 0) {
                        this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel + y + wallHeight, z, GCBlocks.glowstoneTorch, DomedHouseComponent.rotateTorchMetadata(3, this.coordMode));
                        continue;
                    }
                    if (z == stopZ - 1 && x == xCenter && y == 0) {
                        this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel + y + wallHeight, z, GCBlocks.glowstoneTorch, DomedHouseComponent.rotateTorchMetadata(4, this.coordMode));
                        continue;
                    }
                    this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel + y + wallHeight, z, air);
                }
            }
            int highestGroundBlock = this.getHighestSolidBlockInBB(blocks, metas, chunkX, chunkZ, xCenter, 0);
            if (highestGroundBlock == -1) continue;
            if (highestGroundBlock >= this.groundLevel) {
                this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, xCenter, this.groundLevel, 0, air);
                this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, xCenter, this.groundLevel + 1, 0, air);
            }
            this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, xCenter, this.groundLevel - 1, 0, path);
            this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, xCenter, this.groundLevel - 2, 0, padding);
        }
        return true;
    }

    protected void spawnVillager(int x, int y, int z) {
        EntityRobotVillager villager = new EntityRobotVillager(this.parent.getWorld());
        villager.func_110161_a(null);
        int xOffset = this.getXWithOffset(x, z);
        int zOffset = this.getZWithOffset(x, z);
        this.parent.spawnLater((Entity)villager, xOffset, y, zOffset);
    }
}

