/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.util;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class NameMetaPair {
    private String name;
    private int meta;

    public NameMetaPair(Item item, int meta) {
        this(Item.field_150901_e.func_148750_c((Object)item), meta);
    }

    public NameMetaPair(Block block, int meta) {
        this(Block.field_149771_c.func_148750_c((Object)block), meta);
    }

    public NameMetaPair(String name, int meta) {
        this.name = name;
        this.meta = meta;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Block getBlock() {
        return (Block)Block.field_149771_c.func_82594_a(this.name);
    }

    public Item getItem() {
        return (Item)Item.field_150901_e.func_82594_a(this.name);
    }

    public int getMetadata() {
        return this.meta;
    }

    public void setMeta(int meta) {
        this.meta = meta;
    }

    public ItemStack getStack() {
        if (this.isValidBlock()) {
            return new ItemStack(this.getBlock(), 1, this.getMetadata());
        }
        if (this.isValidItem()) {
            return new ItemStack(this.getItem(), 1, this.getMetadata());
        }
        return null;
    }

    public boolean isValidBlock() {
        return this.getBlock() != null && this.meta >= 0 && this.meta < 65536;
    }

    public boolean isValidItem() {
        return this.getItem() != null && this.meta >= 0 && this.meta < 65536;
    }

    public int hashCode() {
        return this.name.hashCode() | this.meta;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof NameMetaPair)) {
            return false;
        }
        NameMetaPair imp = (NameMetaPair)o;
        return this.name.equals(imp.name) && this.meta == imp.meta;
    }

    public boolean equals(NameMetaPair o) {
        return this.name.equals(o.name) && this.meta == o.meta;
    }

    public String toString() {
        return this.name + "@" + this.meta;
    }
}

