/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.grid;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridStorage;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPostCacheConstruction;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.grid.IEssentiaGrid;
import thaumicenergistics.api.grid.IEssentiaWatcherHost;
import thaumicenergistics.common.grid.CraftingAspect_ItemWatcher;
import thaumicenergistics.common.grid.EssentiaMonitor;
import thaumicenergistics.common.grid.EssentiaWatcher;
import thaumicenergistics.common.grid.EssentiaWatcherManager;
import thaumicenergistics.common.items.ItemCraftingAspect;
import thaumicenergistics.common.items.ItemEnum;

public class GridEssentiaCache
extends EssentiaMonitor
implements IEssentiaGrid {
    final IGrid internalGrid;
    private final EssentiaWatcherManager essentiaWatcherManger;
    private final ItemStack craftingAspectItem;
    private final CraftingAspect_ItemWatcher craftingWatcher;

    public GridEssentiaCache(IGrid grid) {
        this.internalGrid = grid;
        this.essentiaWatcherManger = new EssentiaWatcherManager(this);
        this.craftingAspectItem = ItemEnum.CRAFTING_ASPECT.getStack();
        this.craftingWatcher = new CraftingAspect_ItemWatcher(this);
    }

    void markForUpdate() {
        this.cacheNeedsUpdate = true;
    }

    @Override
    protected void updateCacheToMatchNetwork() {
        super.updateCacheToMatchNetwork();
        if (!this.energyGrid.isNetworkPowered()) {
            return;
        }
        IStorageGrid storage = (IStorageGrid)this.internalGrid.getCache(IStorageGrid.class);
        IMEMonitor itemMonitor = storage.getItemInventory();
        IItemList storedItems = itemMonitor.getStorageList();
        if (storedItems == null || storedItems.size() == 0) {
            return;
        }
        HashSet<Aspect> craftableAspects = new HashSet<Aspect>();
        for (IAEItemStack stack : storedItems) {
            Aspect aspect;
            if (stack == null || !stack.isCraftable() || !stack.hasTagCompound() || !(stack.getItem() instanceof ItemCraftingAspect) || (aspect = ItemCraftingAspect.getAspect(stack.getTagCompound().getNBTTagCompoundCopy())) == null) continue;
            craftableAspects.add(aspect);
        }
        if (craftableAspects.size() > 0) {
            this.setCraftableAspects(craftableAspects);
        }
    }

    public void addNode(IGridNode gridNode, IGridHost machine) {
        if (machine instanceof IEssentiaWatcherHost) {
            IEssentiaWatcherHost host = (IEssentiaWatcherHost)machine;
            EssentiaWatcher watcher = new EssentiaWatcher(this.essentiaWatcherManger, host);
            this.essentiaWatcherManger.addWatcher(gridNode, watcher);
            host.updateWatcher(watcher);
        }
    }

    @Override
    public long injectEssentia(Aspect aspect, long amount, Actionable mode, BaseActionSource source, boolean powered) {
        ICraftingGrid craftingGrid;
        ImmutableSet cpus;
        long amountRejected = super.injectEssentia(aspect, amount, mode, source, powered);
        if (mode == Actionable.MODULATE && amountRejected < amount && (cpus = (craftingGrid = (ICraftingGrid)this.internalGrid.getCache(ICraftingGrid.class)).getCpus()).size() > 0) {
            ItemCraftingAspect.setAspect(this.craftingAspectItem, aspect);
            IAEItemStack aspectAEItem = null;
            long amountToInject = amount - amountRejected;
            for (ICraftingCPU cpu : cpus) {
                CraftingCPUCluster cluster;
                if (!cpu.isBusy() || !(cpu instanceof CraftingCPUCluster)) continue;
                if (aspectAEItem == null) {
                    aspectAEItem = AEApi.instance().storage().createItemStack(this.craftingAspectItem);
                    aspectAEItem.setStackSize(1L);
                }
                if (!(cluster = (CraftingCPUCluster)cpu).isMaking(aspectAEItem)) continue;
                while (amountToInject > 0L && cluster.isBusy()) {
                    cluster.injectItems((IAEStack)aspectAEItem, mode, source);
                    --amountToInject;
                }
                if (amountToInject != 0L) continue;
                break;
            }
        }
        return amountRejected;
    }

    @MENetworkEventSubscribe
    public void onGridCacheReady(MENetworkPostCacheConstruction event) {
        IStorageGrid storage = (IStorageGrid)this.internalGrid.getCache(IStorageGrid.class);
        this.wrap((IMEMonitor<IAEFluidStack>)storage.getFluidInventory(), (IEnergyGrid)this.internalGrid.getCache(IEnergyGrid.class), this.internalGrid);
        storage.getItemInventory().addListener((IMEMonitorHandlerReceiver)this.craftingWatcher, (Object)this.internalGrid);
    }

    public void onJoin(IGridStorage sourceStorage) {
        this.cacheNeedsUpdate = true;
    }

    public void onSplit(IGridStorage destinationStorage) {
    }

    public void onUpdateTick() {
        try {
            if (this.cacheNeedsUpdate && this.listeners.size() > 0) {
                this.updateCacheToMatchNetwork();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void populateGridStorage(IGridStorage destinationStorage) {
    }

    public void removeNode(IGridNode gridNode, IGridHost machine) {
        if (machine instanceof IEssentiaWatcherHost) {
            this.essentiaWatcherManger.removeWatcher(gridNode);
        }
    }
}

