/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.net;

import com.gtnewhorizon.structurelib.SortedRegistry;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class RegistryOrderSyncMessage
implements IMessage {
    private String name;
    private List<String> order;
    private List<String> disabled;

    public RegistryOrderSyncMessage() {
    }

    public RegistryOrderSyncMessage(String name, List<String> order, List<String> disabled) {
        this.name = name;
        this.order = order;
        this.disabled = disabled;
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        int size = ByteBufUtils.readVarInt((ByteBuf)buf, (int)2);
        this.order = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.order.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
        size = ByteBufUtils.readVarInt((ByteBuf)buf, (int)2);
        this.disabled = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.disabled.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.order.size(), (int)2);
        for (String s : this.order) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s);
        }
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.disabled.size(), (int)2);
        for (String s : this.disabled) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s);
        }
    }

    public static class Handler
    implements IMessageHandler<RegistryOrderSyncMessage, IMessage> {
        private static ConcurrentHashMap<String, WeakReference<SortedRegistry<?>>> ALL_REGISTRIES;

        public static void setAllRegistries(ConcurrentHashMap<String, WeakReference<SortedRegistry<?>>> r) {
            if (ALL_REGISTRIES == null) {
                ALL_REGISTRIES = r;
            }
        }

        public IMessage onMessage(RegistryOrderSyncMessage message, MessageContext ctx) {
            if (ALL_REGISTRIES == null) {
                return null;
            }
            WeakReference<SortedRegistry<?>> ref = ALL_REGISTRIES.get(message.name);
            if (ref == null) {
                return null;
            }
            SortedRegistry r = (SortedRegistry)ref.get();
            if (r == null) {
                return null;
            }
            r.registerOrdering(ctx.getServerHandler().field_147369_b, (List<String>)message.order, (List<String>)message.disabled);
            return null;
        }
    }
}

