/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.sodium.shader_overrides;

import com.gtnewhorizons.angelica.compat.toremove.MatrixStack;
import com.gtnewhorizons.angelica.glsm.RenderSystem;
import java.nio.FloatBuffer;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkProgram;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderFogComponent;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.BufferUtils;

public class IrisChunkProgram
extends ChunkProgram {
    private final int uModelViewMatrix = this.getUniformLocation("iris_ModelViewMatrix");
    private final int uNormalMatrix = this.getUniformLocation("iris_NormalMatrix");
    @Nullable
    private final ProgramUniforms irisProgramUniforms;
    @Nullable
    private final ProgramSamplers irisProgramSamplers;
    @Nullable
    private final ProgramImages irisProgramImages;

    public IrisChunkProgram(RenderDevice owner, ResourceLocation name, int handle, @Nullable ProgramUniforms irisProgramUniforms, @Nullable ProgramSamplers irisProgramSamplers, @Nullable ProgramImages irisProgramImages) {
        super(owner, name, handle, ChunkShaderFogComponent.None::new);
        this.irisProgramUniforms = irisProgramUniforms;
        this.irisProgramSamplers = irisProgramSamplers;
        this.irisProgramImages = irisProgramImages;
    }

    @Override
    public void setup(MatrixStack matrixStack, float modelScale, float textureScale) {
        super.setup(matrixStack, modelScale, textureScale);
        if (this.irisProgramUniforms != null) {
            this.irisProgramUniforms.update();
        }
        if (this.irisProgramSamplers != null) {
            this.irisProgramSamplers.update();
        }
        if (this.irisProgramImages != null) {
            this.irisProgramImages.update();
        }
        Matrix4f modelViewMatrix = matrixStack.peek().getModel();
        Matrix4f normalMatrix = new Matrix4f((Matrix4fc)matrixStack.peek().getModel());
        normalMatrix.invert();
        normalMatrix.transpose();
        this.uniformMatrix(this.uModelViewMatrix, modelViewMatrix);
        this.uniformMatrix(this.uNormalMatrix, normalMatrix);
    }

    @Override
    public int getUniformLocation(String name) {
        if ("iris_BlockTex".equals(name) || "iris_LightTex".equals(name)) {
            return -1;
        }
        try {
            return super.getUniformLocation(name);
        }
        catch (NullPointerException e) {
            return -1;
        }
    }

    private void uniformMatrix(int location, Matrix4f matrix) {
        if (location == -1) {
            return;
        }
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);
        matrix.get(buffer);
        RenderSystem.uniformMatrix4fv(location, false, buffer);
    }
}

