/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.ctm;

import com.prupe.mcpatcher.ctm.CTMUtils;
import java.util.Arrays;
import jss.notfine.config.MCPatcherForgeConfig;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class GlassPaneRenderer {
    private static final boolean enable = MCPatcherForgeConfig.instance().ctmGlassPane;
    public static boolean skipPaneRendering;
    public static boolean skipTopEdgeRendering;
    public static boolean skipBottomEdgeRendering;
    private static final IIcon[] icons;
    private static double uLeft;
    private static double uLeftThin;
    private static double uRightThin;
    private static double uRight;
    private static double vTop;
    private static double vBottom;
    private static double u1Scaled;
    private static double u2Scaled;

    public static void renderThin(RenderBlocks renderBlocks, Block blockPane, IIcon origIcon, int x, int y, int z, boolean connectNorth, boolean connectSouth, boolean connectWest, boolean connectEast) {
        if (GlassPaneRenderer.setupIcons(renderBlocks, blockPane, origIcon, x, y, z)) {
            GlassPaneRenderer.render(x, y, z, connectNorth, connectSouth, connectWest, connectEast, 0.0, 0.0, 0.0, false);
        }
    }

    public static void renderThick(RenderBlocks renderBlocks, Block blockPane, IIcon origIcon, int x, int y, int z, boolean connectNorth, boolean connectSouth, boolean connectWest, boolean connectEast) {
        if (GlassPaneRenderer.setupIcons(renderBlocks, blockPane, origIcon, x, y, z)) {
            GlassPaneRenderer.setupPaneEdges(renderBlocks.field_147845_a, blockPane, x, y, z);
            GlassPaneRenderer.render(x, y, z, connectNorth, connectSouth, connectWest, connectEast, 0.0625, 1.0, 0.001, true);
        }
    }

    private static boolean setupIcons(RenderBlocks renderBlocks, Block blockPane, IIcon origIcon, int x, int y, int z) {
        skipTopEdgeRendering = false;
        skipBottomEdgeRendering = false;
        skipPaneRendering = false;
        if (!enable) {
            return false;
        }
        for (int face = 2; face <= 5; ++face) {
            GlassPaneRenderer.icons[face] = CTMUtils.getBlockIcon(origIcon, blockPane, renderBlocks.field_147845_a, x, y, z, face);
            if (icons[face] == null) {
                skipPaneRendering = false;
                return false;
            }
            if (icons[face] == origIcon) continue;
            skipPaneRendering = true;
        }
        return skipPaneRendering;
    }

    private static void setupPaneEdges(IBlockAccess blockAccess, Block blockPane, int x, int y, int z) {
        int metadata = blockAccess.func_72805_g(x, y, z);
        skipBottomEdgeRendering = blockAccess.func_147439_a(x, y - 1, z) == blockPane && blockAccess.func_72805_g(x, y - 1, z) == metadata;
        skipTopEdgeRendering = blockAccess.func_147439_a(x, y + 1, z) == blockPane && blockAccess.func_72805_g(x, y + 1, z) == metadata;
    }

    private static void render(int x, int y, int z, boolean connectNorth, boolean connectSouth, boolean connectWest, boolean connectEast, double thickness, double uOffset, double yOffset, boolean edges) {
        double west = x;
        double westThin = (double)x + 0.5 - thickness;
        double eastThin = (double)x + 0.5 + thickness;
        double east = (double)x + 1.0;
        double down = (double)y + yOffset;
        double up = (double)y + 1.0 - yOffset;
        double north = z;
        double northThin = (double)z + 0.5 - thickness;
        double southThin = (double)z + 0.5 + thickness;
        double south = (double)z + 1.0;
        u1Scaled = 8.0 - uOffset;
        u2Scaled = 8.0 + uOffset;
        if (!(connectNorth || connectSouth || connectWest || connectEast)) {
            connectEast = true;
            connectWest = true;
            connectSouth = true;
            connectNorth = true;
            if (edges) {
                GlassPaneRenderer.setupTileCoords(5);
                GlassPaneRenderer.drawFace(east, up, southThin, uLeftThin, vTop, east, down, northThin, uRightThin, vBottom);
                GlassPaneRenderer.setupTileCoords(4);
                GlassPaneRenderer.drawFace(west, up, northThin, uLeftThin, vTop, west, down, southThin, uRightThin, vBottom);
                GlassPaneRenderer.setupTileCoords(3);
                GlassPaneRenderer.drawFace(westThin, up, south, uLeftThin, vTop, eastThin, down, south, uRightThin, vBottom);
                GlassPaneRenderer.setupTileCoords(2);
                GlassPaneRenderer.drawFace(eastThin, up, north, uLeftThin, vTop, westThin, down, north, uRightThin, vBottom);
            }
        }
        if (connectEast && connectWest) {
            GlassPaneRenderer.setupTileCoords(3);
            GlassPaneRenderer.drawFace(west, up, southThin, uLeft, vTop, east, down, southThin, uRight, vBottom);
            GlassPaneRenderer.setupTileCoords(2);
            GlassPaneRenderer.drawFace(east, up, northThin, uLeft, vTop, west, down, northThin, uRight, vBottom);
        } else if (connectWest) {
            GlassPaneRenderer.setupTileCoords(3);
            if (connectSouth) {
                GlassPaneRenderer.drawFace(west, up, southThin, uRightThin, vTop, westThin, down, southThin, uRight, vBottom);
            } else {
                GlassPaneRenderer.drawFace(west, up, southThin, uLeftThin, vTop, eastThin, down, southThin, uRight, vBottom);
            }
            GlassPaneRenderer.setupTileCoords(2);
            if (connectNorth) {
                GlassPaneRenderer.drawFace(westThin, up, northThin, uLeft, vTop, west, down, northThin, uLeftThin, vBottom);
            } else {
                GlassPaneRenderer.drawFace(eastThin, up, northThin, uLeft, vTop, west, down, northThin, uRightThin, vBottom);
            }
            if (edges && !connectNorth && !connectSouth) {
                GlassPaneRenderer.setupTileCoords(5);
                GlassPaneRenderer.drawFace(eastThin, up, southThin, uLeftThin, vTop, eastThin, down, northThin, uRightThin, vBottom);
            }
        } else if (connectEast) {
            GlassPaneRenderer.setupTileCoords(3);
            if (connectSouth) {
                GlassPaneRenderer.drawFace(eastThin, up, southThin, uLeft, vTop, east, down, southThin, uLeftThin, vBottom);
            } else {
                GlassPaneRenderer.drawFace(westThin, up, southThin, uLeft, vTop, east, down, southThin, uRightThin, vBottom);
            }
            GlassPaneRenderer.setupTileCoords(2);
            if (connectNorth) {
                GlassPaneRenderer.drawFace(east, up, northThin, uRightThin, vTop, eastThin, down, northThin, uRight, vBottom);
            } else {
                GlassPaneRenderer.drawFace(east, up, northThin, uLeftThin, vTop, westThin, down, northThin, uRight, vBottom);
            }
            if (edges && !connectNorth && !connectSouth) {
                GlassPaneRenderer.setupTileCoords(4);
                GlassPaneRenderer.drawFace(westThin, up, northThin, uLeftThin, vTop, westThin, down, southThin, uRightThin, vBottom);
            }
        }
        if (connectNorth && connectSouth) {
            GlassPaneRenderer.setupTileCoords(4);
            GlassPaneRenderer.drawFace(westThin, up, north, uLeft, vTop, westThin, down, south, uRight, vBottom);
            GlassPaneRenderer.setupTileCoords(5);
            GlassPaneRenderer.drawFace(eastThin, up, south, uLeft, vTop, eastThin, down, north, uRight, vBottom);
        } else if (connectNorth) {
            GlassPaneRenderer.setupTileCoords(4);
            if (connectWest) {
                GlassPaneRenderer.drawFace(westThin, up, north, uRightThin, vTop, westThin, down, northThin, uRight, vBottom);
            } else {
                GlassPaneRenderer.drawFace(westThin, up, north, uLeftThin, vTop, westThin, down, southThin, uRight, vBottom);
            }
            GlassPaneRenderer.setupTileCoords(5);
            if (connectEast) {
                GlassPaneRenderer.drawFace(eastThin, up, northThin, uLeft, vTop, eastThin, down, north, uLeftThin, vBottom);
            } else {
                GlassPaneRenderer.drawFace(eastThin, up, southThin, uLeft, vTop, eastThin, down, north, uRightThin, vBottom);
            }
            if (edges && !connectWest && !connectEast) {
                GlassPaneRenderer.setupTileCoords(3);
                GlassPaneRenderer.drawFace(westThin, up, southThin, uLeftThin, vTop, eastThin, down, southThin, uRightThin, vBottom);
            }
        } else if (connectSouth) {
            GlassPaneRenderer.setupTileCoords(4);
            if (connectWest) {
                GlassPaneRenderer.drawFace(westThin, up, southThin, uLeft, vTop, westThin, down, south, uLeftThin, vBottom);
            } else {
                GlassPaneRenderer.drawFace(westThin, up, northThin, uLeft, vTop, westThin, down, south, uRightThin, vBottom);
            }
            GlassPaneRenderer.setupTileCoords(5);
            if (connectEast) {
                GlassPaneRenderer.drawFace(eastThin, up, south, uRightThin, vTop, eastThin, down, southThin, uRight, vBottom);
            } else {
                GlassPaneRenderer.drawFace(eastThin, up, south, uLeftThin, vTop, eastThin, down, northThin, uRight, vBottom);
            }
            if (edges && !connectWest && !connectEast) {
                GlassPaneRenderer.setupTileCoords(2);
                GlassPaneRenderer.drawFace(eastThin, up, northThin, uLeftThin, vTop, westThin, down, northThin, uRightThin, vBottom);
            }
        }
    }

    private static void setupTileCoords(int face) {
        IIcon icon = icons[face];
        uLeft = icon.func_94209_e();
        uLeftThin = icon.func_94214_a(u1Scaled);
        uRightThin = icon.func_94214_a(u2Scaled);
        uRight = icon.func_94212_f();
        vTop = icon.func_94206_g();
        vBottom = icon.func_94210_h();
    }

    private static void drawFace(double x0, double y0, double z0, double u0, double v0, double x1, double y1, double z1, double u1, double v1) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78374_a(x0, y0, z0, u0, v0);
        tessellator.func_78374_a(x0, y1, z0, u0, v1);
        tessellator.func_78374_a(x1, y1, z1, u1, v1);
        tessellator.func_78374_a(x1, y0, z1, u1, v0);
    }

    protected static void clear() {
        Arrays.fill(icons, null);
        skipPaneRendering = false;
    }

    static {
        icons = new IIcon[6];
    }
}

