/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.transform;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.io.FileUtils;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.Opcodes;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.transformers.MixinClassWriter;

public class HUDCachingTransformer
implements IClassTransformer,
Opcodes {
    static final String HUDCaching = "com/gtnewhorizons/angelica/hudcaching/HUDCaching$HUDCachingHooks";
    private static final boolean DUMP_CLASSES = Boolean.parseBoolean(System.getProperty("angelica.dumpClass", "false"));
    static final Map<String, List<String>> ReturnEarlyMethods = ImmutableMap.of((Object)"thaumcraft.client.lib.RenderEventHandler", (Object)ImmutableList.of((Object)"renderOverlay"), (Object)"com.kentington.thaumichorizons.client.lib.RenderEventHandler", (Object)ImmutableList.of((Object)"renderOverlay"));
    private File outputDir = null;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (ReturnEarlyMethods.containsKey(transformedName)) {
            ClassReader cr = new ClassReader(basicClass);
            ClassNode cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            for (String targetMethod : ReturnEarlyMethods.get(transformedName)) {
                for (MethodNode method : cn.methods) {
                    if (!method.name.equals(targetMethod)) continue;
                    InsnList list = new InsnList();
                    LabelNode exitLabel = new LabelNode();
                    AngelicaTweaker.LOGGER.info("Injecting HUDCaching Conditional Return: " + transformedName + "#" + method.name);
                    list.add((AbstractInsnNode)new MethodInsnNode(184, HUDCaching, "shouldReturnEarly", "()Z", false));
                    list.add((AbstractInsnNode)new JumpInsnNode(153, exitLabel));
                    if (method.desc.endsWith("Z") || method.desc.endsWith("I")) {
                        list.add((AbstractInsnNode)new InsnNode(3));
                        list.add((AbstractInsnNode)new InsnNode(172));
                    } else if (method.desc.endsWith("V")) {
                        list.add((AbstractInsnNode)new InsnNode(177));
                    } else {
                        AngelicaTweaker.LOGGER.warn("HUDCaching Conditional Return - Unknown return type: " + transformedName + "#" + method.name + ":" + method.desc);
                        return basicClass;
                    }
                    list.add((AbstractInsnNode)exitLabel);
                    method.instructions.insert(list);
                }
            }
            MixinClassWriter cw = new MixinClassWriter(3);
            cn.accept((ClassVisitor)cw);
            byte[] bytes = cw.toByteArray();
            this.saveTransformedClass(bytes, transformedName);
            return bytes;
        }
        return basicClass;
    }

    private void saveTransformedClass(byte[] data, String transformedName) {
        String fileName;
        File classFile;
        File outDir;
        if (!DUMP_CLASSES) {
            return;
        }
        if (this.outputDir == null) {
            this.outputDir = new File(Launch.minecraftHome, "ASM_HUD_CACHING");
            try {
                FileUtils.deleteDirectory((File)this.outputDir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!this.outputDir.exists()) {
                this.outputDir.mkdirs();
            }
        }
        if (!(outDir = (classFile = new File(this.outputDir, (fileName = transformedName.replace('.', File.separatorChar)) + ".class")).getParentFile()).exists()) {
            outDir.mkdirs();
        }
        if (classFile.exists()) {
            classFile.delete();
        }
        try (OutputStream output = Files.newOutputStream(classFile.toPath(), new OpenOption[0]);){
            output.write(data);
        }
        catch (IOException e) {
            AngelicaTweaker.LOGGER.error("Could not save transformed class (byte[]) " + transformedName, (Throwable)e);
        }
    }
}

