/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.block;

import binnie.core.block.BlockMetadata;
import binnie.core.block.IBlockMetadata;
import binnie.core.block.TileEntityMetadata;
import binnie.core.util.I18N;
import binnie.extratrees.block.ILogType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockETLog
extends BlockLog
implements IBlockMetadata {
    public BlockETLog() {
        this.func_149647_a(Tabs.tabArboriculture);
        this.func_149663_c("log");
        this.func_149752_b(5.0f);
        this.func_149711_c(2.0f);
        this.func_149672_a(Block.field_149766_f);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < ILogType.ExtraTreeLog.values().length; ++i) {
            list.add(TileEntityMetadata.getItemStack((Block)this, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityMetadata tile = TileEntityMetadata.getTile(world, x, y, z);
        if (tile != null) {
            return this.getIcon(side, tile.getTileMetadata(), world.func_72805_g(x, y, z));
        }
        return super.func_149673_e(world, x, y, z, side);
    }

    public IIcon getIcon(int side, int tileMeta, int blockMeta) {
        int oriented = blockMeta & 0xC;
        ILogType.ExtraTreeLog log = ILogType.ExtraTreeLog.values()[tileMeta];
        switch (oriented) {
            case 4: {
                if (side > 3) {
                    return log.getTrunk();
                }
                return log.getBark();
            }
            case 8: {
                if (side == 2 || side == 3) {
                    return log.getTrunk();
                }
                return log.getBark();
            }
        }
        if (side < 2) {
            return log.getTrunk();
        }
        return log.getBark();
    }

    public IIcon func_149691_a(int side, int tileMeta) {
        return this.getIcon(side, tileMeta, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        ILogType.ExtraTreeLog.registerIcons(register);
    }

    @Override
    public void dropAsStack(World world, int x, int y, int z, ItemStack itemStack) {
        this.func_149642_a(world, x, y, z, itemStack);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int blockMeta, int fortune) {
        return BlockMetadata.getBlockDropped(this, world, x, y, z, blockMeta);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        return BlockMetadata.breakBlock(this, player, world, x, y, z);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityMetadata();
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public boolean func_149696_a(World world, int x, int y, int z, int eventId, int eventType) {
        super.func_149696_a(world, x, y, z, eventId, eventType);
        TileEntity tileentity = world.func_147438_o(x, y, z);
        return tileentity != null && tileentity.func_145842_c(eventId, eventType);
    }

    @Override
    public int getDroppedMeta(int blockMeta, int tileMeta) {
        return tileMeta;
    }

    @Override
    public String getBlockName(ItemStack itemStack) {
        int meta = TileEntityMetadata.getItemDamage(itemStack);
        ILogType.ExtraTreeLog[] logs = ILogType.ExtraTreeLog.values();
        if (meta < 0 || meta >= logs.length) {
            meta = 0;
        }
        return I18N.localise("extratrees.block.log.name", logs[meta].getName());
    }

    @Override
    public void addBlockTooltip(ItemStack itemStack, List<String> tooltip) {
    }

    @Override
    public int getPlacedMeta(ItemStack itemStack, World world, int x, int y, int z, ForgeDirection direction) {
        return TileEntityMetadata.getItemDamage(itemStack);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float par6, float par7, float par8, int meta) {
        int n;
        switch (side) {
            case 2: 
            case 3: {
                n = 8;
                break;
            }
            case 4: 
            case 5: {
                n = 4;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int side) {
        super.func_149749_a(world, x, y, z, block, side);
        world.func_147475_p(x, y, z);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 20;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return true;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 5;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return BlockMetadata.getPickBlock(world, x, y, z);
    }
}

