/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.util;

import com.github.lunatrius.schematica.reference.Reference;
import java.io.File;
import java.io.IOException;

public class FileUtils {
    public static String humanReadableByteCount(long bytes) {
        int unit = 1024;
        if (bytes < 1024L) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        String pre = "KMGTPE".charAt(exp - 1) + "i";
        return String.format("%3.0f %sB", (double)bytes / Math.pow(1024.0, exp), pre);
    }

    public static boolean contains(File root, String filename) {
        return FileUtils.contains(root, new File(root, filename));
    }

    public static boolean contains(File root, File file) {
        try {
            return file.getCanonicalPath().startsWith(root.getCanonicalPath() + File.separator);
        }
        catch (IOException e) {
            Reference.logger.error("", (Throwable)e);
            return false;
        }
    }
}

