/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui;

import appeng.container.implementations.ContainerPriority;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.localization.GuiText;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.IPriorityHost;
import appeng.util.calculators.ArithHelper;
import appeng.util.calculators.Calculator;
import com.glodblock.github.client.gui.base.FCGuiAmount;
import com.glodblock.github.common.parts.PartFluidStorageBus;
import com.glodblock.github.inventory.IDualHost;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.loader.ItemAndBlockHolder;
import java.io.IOException;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;

public class GuiFCPriority
extends FCGuiAmount {
    public GuiFCPriority(InventoryPlayer inventoryPlayer, IPriorityHost te) {
        super((Container)new ContainerPriority(inventoryPlayer, te));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.submit.field_146124_l = false;
        this.submit.field_146125_m = false;
        this.field_146292_n.remove(this.submit);
        ((ContainerPriority)this.field_147002_h).setTextField(this.amountBox);
    }

    @Override
    protected int getIncrementQuantity(int i) {
        return AEConfig.instance.priorityByStacksAmounts(i);
    }

    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(GuiText.Priority.getLocal(), 8, 6, 0x404040);
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawBG(offsetX, offsetY, mouseX, mouseY);
        this.amountBox.func_146194_f();
    }

    @Override
    protected void addQty(int i) {
        try {
            this.amountBox.func_146180_a(Long.toString(this.getAmount() + i));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            NetworkHandler.instance.sendToServer((AppEngPacket)new PacketValueConfig("PriorityHost.Priority", String.valueOf(this.getAmount())));
        }
        catch (IOException e) {
            AELog.debug((Throwable)e);
        }
    }

    @Override
    protected void setOriginGUI(Object target) {
        if (target instanceof IDualHost) {
            this.myIcon = ItemAndBlockHolder.INTERFACE.stack();
            this.originalGui = GuiType.DUAL_INTERFACE;
        } else if (target instanceof PartFluidStorageBus) {
            this.myIcon = ItemAndBlockHolder.FLUID_STORAGE_BUS.stack();
            this.originalGui = GuiType.FLUID_STORAGE_BUS;
        }
    }

    @Override
    protected void func_73869_a(char character, int key) {
        super.func_73869_a(character, key);
        try {
            NetworkHandler.instance.sendToServer((AppEngPacket)new PacketValueConfig("PriorityHost.Priority", String.valueOf(this.getAmount())));
        }
        catch (IOException e) {
            AELog.debug((Throwable)e);
        }
    }

    @Override
    protected int getAmount() {
        try {
            String out = this.amountBox.func_146179_b();
            double result = Calculator.conversion((String)out);
            if (Double.isNaN(result)) {
                return 0;
            }
            return (int)ArithHelper.round((double)result, (int)0);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    protected String getBackground() {
        return "guis/priority.png";
    }
}

