/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.map;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import journeymap.client.JourneymapClient;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.log.StatTimer;
import journeymap.client.model.BlockCoordIntPair;
import journeymap.client.model.GridSpec;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionImageCache;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.Tile;
import journeymap.client.render.map.TileDrawStepCache;
import journeymap.client.render.map.TilePos;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.util.MathHelper;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class GridRenderer {
    private static boolean enabled = true;
    private static HashMap<String, String> messages = new HashMap();
    private final TilePos centerPos = new TilePos(0, 0);
    private final Logger logger = Journeymap.getLogger();
    private final boolean debug = this.logger.isDebugEnabled();
    private final TreeMap<TilePos, Tile> grid = new TreeMap();
    private final Point2D.Double centerPixelOffset = new Point2D.Double();
    private final int maxGlErrors = 20;
    StatTimer updateTilesTimer1 = StatTimer.get("GridRenderer.updateTiles(1)", 5, 500);
    StatTimer updateTilesTimer2 = StatTimer.get("GridRenderer.updateTiles(2)", 5, 500);
    private int glErrors = 0;
    private int gridSizeHeight;
    private int gridSizeWidth;
    private double srcSizeHeight;
    private double srcSizeWidth;
    private Rectangle2D.Double viewPort = null;
    private Rectangle2D.Double screenBounds = null;
    private int lastHeight = -1;
    private int lastWidth = -1;
    private MapType mapType;
    private String centerTileKey = "";
    private int zoom;
    private double centerBlockX;
    private double centerBlockZ;
    private File worldDir;
    private double currentRotation;
    private IntBuffer viewportBuf = BufferUtils.createIntBuffer((int)16);
    private FloatBuffer modelMatrixBuf = BufferUtils.createFloatBuffer((int)16);
    private FloatBuffer projMatrixBuf = BufferUtils.createFloatBuffer((int)16);
    private FloatBuffer winPosBuf = BufferUtils.createFloatBuffer((int)16);
    private FloatBuffer objPosBuf = BufferUtils.createFloatBuffer((int)16);

    public static void addDebugMessage(String key, String message) {
        messages.put(key, message);
    }

    public static void removeDebugMessage(String key, String message) {
        messages.remove(key);
    }

    public static void clearDebugMessages() {
        messages.clear();
    }

    public static void setEnabled(boolean enabled) {
        GridRenderer.enabled = enabled;
        if (!enabled) {
            TileDrawStepCache.clear();
        }
    }

    public void setViewPort(Rectangle2D.Double viewPort) {
        this.viewPort = viewPort;
        this.screenBounds = null;
        this.updateBounds(this.lastWidth, this.lastHeight);
    }

    private void populateGrid(Tile centerTile) {
        int endRow = (this.gridSizeHeight - 1) / 2;
        int endCol = (this.gridSizeWidth - 1) / 2;
        int startRow = -endRow;
        int startCol = -endCol;
        for (int z = startRow; z <= endRow; ++z) {
            for (int x = startCol; x <= endCol; ++x) {
                TilePos pos = new TilePos(x, z);
                Tile tile = this.findNeighbor(centerTile, pos);
                this.grid.put(pos, tile);
            }
        }
    }

    public void move(int deltaBlockX, int deltaBlockZ) {
        this.center(this.mapType, this.centerBlockX + (double)deltaBlockX, this.centerBlockZ + (double)deltaBlockZ, this.zoom);
    }

    public boolean center() {
        return this.center(this.mapType, this.centerBlockX, this.centerBlockZ, this.zoom);
    }

    public boolean hasUnloadedTile() {
        return this.hasUnloadedTile(false);
    }

    private void setGridSizes(int gridSizeHeight, int gridSizeWidth) {
        if (this.gridSizeHeight == gridSizeHeight && this.gridSizeWidth == gridSizeWidth) {
            return;
        }
        if (gridSizeHeight % 2 == 0) {
            ++gridSizeHeight;
        }
        if (gridSizeWidth % 2 == 0) {
            ++gridSizeWidth;
        }
        this.gridSizeHeight = gridSizeHeight;
        this.gridSizeWidth = gridSizeWidth;
        this.srcSizeHeight = gridSizeHeight * 512;
        this.srcSizeWidth = gridSizeWidth * 512;
        this.clear();
    }

    public boolean hasUnloadedTile(boolean preview) {
        for (Map.Entry<TilePos, Tile> entry : this.grid.entrySet()) {
            Tile tile;
            if (!this.isOnScreen(entry.getKey()) || (tile = entry.getValue()) != null && tile.hasTexture(this.mapType)) continue;
            return true;
        }
        return false;
    }

    public boolean center(MapType mapType, double blockX, double blockZ, int zoom) {
        int tileZ;
        boolean mapTypeChanged;
        boolean bl = mapTypeChanged = !Objects.equals(mapType, this.mapType);
        if (blockX == this.centerBlockX && blockZ == this.centerBlockZ && zoom == this.zoom && !mapTypeChanged && !this.grid.isEmpty()) {
            return false;
        }
        this.centerBlockX = blockX;
        this.centerBlockZ = blockZ;
        this.zoom = zoom;
        int tileX = Tile.blockPosToTile((int)Math.floor(this.centerBlockX), this.zoom);
        String newCenterKey = Tile.toCacheKey(tileX, tileZ = Tile.blockPosToTile((int)Math.floor(this.centerBlockZ), this.zoom), zoom);
        boolean centerTileChanged = !newCenterKey.equals(this.centerTileKey);
        this.centerTileKey = newCenterKey;
        if (mapTypeChanged || centerTileChanged || this.grid.isEmpty()) {
            Tile newCenterTile = this.findTile(tileX, tileZ, zoom);
            this.populateGrid(newCenterTile);
            if (this.debug) {
                this.logger.debug("Centered on " + newCenterTile + " with pixel offsets of " + this.centerPixelOffset.x + "," + this.centerPixelOffset.y);
                Minecraft mc = ForgeHelper.INSTANCE.getClient();
                BufferedImage tmp = new BufferedImage(mc.field_71443_c, mc.field_71440_d, 2);
                Graphics2D g = tmp.createGraphics();
                g.setStroke(new BasicStroke(1.0f));
                g.setColor(Color.GREEN);
                g.drawLine(mc.field_71443_c / 2, 0, mc.field_71443_c / 2, mc.field_71440_d);
                g.drawLine(0, mc.field_71440_d / 2, mc.field_71443_c, mc.field_71440_d / 2);
            }
        }
        return true;
    }

    public void updateTiles(MapType mapType, int zoom, boolean highQuality, int width, int height, boolean fullUpdate, double xOffset, double yOffset) {
        this.updateTilesTimer1.start();
        this.mapType = mapType;
        this.zoom = zoom;
        this.updateBounds(width, height);
        this.updateGridSize();
        Tile centerTile = this.grid.get(this.centerPos);
        if (centerTile == null || centerTile.zoom != this.zoom) {
            int tileX = Tile.blockPosToTile((int)Math.floor(this.centerBlockX), this.zoom);
            int tileZ = Tile.blockPosToTile((int)Math.floor(this.centerBlockZ), this.zoom);
            centerTile = this.findTile(tileX, tileZ, this.zoom);
            this.populateGrid(centerTile);
        }
        Point2D blockPixelOffset = centerTile.blockPixelOffsetInTile(this.centerBlockX, this.centerBlockZ);
        double blockSizeOffset = Math.pow(2.0, zoom) / 2.0;
        int extraOffsetX = this.gridSizeWidth / 2 * 512;
        double displayOffsetX = xOffset + (double)extraOffsetX - (this.srcSizeWidth - (double)this.lastWidth) / 2.0;
        displayOffsetX = this.centerBlockX < 0.0 ? (displayOffsetX -= blockSizeOffset) : (displayOffsetX += blockSizeOffset);
        int extraOffsetY = this.gridSizeHeight / 2 * 512;
        double displayOffsetY = yOffset + (double)extraOffsetY - (this.srcSizeHeight - (double)this.lastHeight) / 2.0;
        displayOffsetY = this.centerBlockZ < 0.0 ? (displayOffsetY -= blockSizeOffset) : (displayOffsetY += blockSizeOffset);
        this.centerPixelOffset.setLocation(displayOffsetX + blockPixelOffset.getX(), displayOffsetY + blockPixelOffset.getY());
        this.updateTilesTimer1.stop();
        if (!fullUpdate) {
            return;
        }
        this.updateTilesTimer2.start();
        for (Map.Entry<TilePos, Tile> entry : this.grid.entrySet()) {
            TilePos pos = entry.getKey();
            Tile tile = entry.getValue();
            if (tile == null) {
                tile = this.findNeighbor(centerTile, pos);
                this.grid.put(pos, tile);
            }
            if (tile.hasTexture(this.mapType)) continue;
            tile.updateTexture(this.worldDir, this.mapType, highQuality);
        }
        this.updateTilesTimer2.stop();
    }

    public Point2D.Double getCenterPixelOffset() {
        return this.centerPixelOffset;
    }

    public BlockCoordIntPair getBlockUnderMouse(double mouseX, double mouseY, int screenWidth, int screenHeight) {
        double centerPixelX = (double)screenWidth / 2.0;
        double centerPixelZ = (double)screenHeight / 2.0;
        double blockSize = (int)Math.pow(2.0, this.zoom);
        double deltaX = (centerPixelX - mouseX) / blockSize;
        double deltaZ = (centerPixelZ - mouseY) / blockSize;
        int x = MathHelper.func_76128_c((double)(this.centerBlockX - deltaX));
        int z = MathHelper.func_76128_c((double)(this.centerBlockZ + deltaZ));
        return new BlockCoordIntPair(x, z);
    }

    public Point2D.Double getBlockPixelInGrid(double x, double z) {
        double localBlockX = x - this.centerBlockX;
        double localBlockZ = z - this.centerBlockZ;
        int blockSize = (int)Math.pow(2.0, this.zoom);
        double pixelOffsetX = (double)(this.lastWidth / 2) + localBlockX * (double)blockSize;
        double pixelOffsetZ = (double)(this.lastHeight / 2) + localBlockZ * (double)blockSize;
        return new Point2D.Double(pixelOffsetX, pixelOffsetZ);
    }

    public void draw(List<? extends DrawStep> drawStepList, double xOffset, double yOffset, float drawScale, double fontScale, double rotation) {
        if (!enabled || drawStepList == null || drawStepList.isEmpty()) {
            return;
        }
        this.draw(xOffset, yOffset, drawScale, fontScale, rotation, drawStepList.toArray(new DrawStep[drawStepList.size()]));
    }

    public void draw(double xOffset, double yOffset, float drawScale, double fontScale, double rotation, DrawStep ... drawSteps) {
        if (enabled) {
            for (DrawStep drawStep : drawSteps) {
                drawStep.draw(xOffset, yOffset, this, drawScale, fontScale, rotation);
            }
        }
    }

    public void draw(float alpha, double offsetX, double offsetZ, boolean showGrid) {
        double centerZ;
        double centerX;
        if (enabled && !this.grid.isEmpty()) {
            centerX = offsetX + this.centerPixelOffset.x;
            centerZ = offsetZ + this.centerPixelOffset.y;
            GridSpec gridSpec = showGrid ? JourneymapClient.getCoreProperties().gridSpecs.getSpec(this.mapType) : null;
            boolean somethingDrew = false;
            for (Map.Entry<TilePos, Tile> entry : this.grid.entrySet()) {
                TilePos pos = entry.getKey();
                Tile tile = entry.getValue();
                if (tile == null || !tile.draw(pos, centerX, centerZ, alpha, gridSpec)) continue;
                somethingDrew = true;
            }
            if (!somethingDrew) {
                RegionImageCache.instance().clear();
            }
        }
        if (!messages.isEmpty()) {
            centerX = offsetX + this.centerPixelOffset.x + (this.centerPos.endX - this.centerPos.startX) / 2.0;
            centerZ = offsetZ + this.centerPixelOffset.y + (this.centerPos.endZ - this.centerPos.startZ) / 2.0 - 60.0;
            for (String message : messages.values()) {
                DrawUtil.drawLabel(message, centerX, centerZ += 20.0, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 255, 0xFFFFFF, 255, 1.0, true);
            }
        }
    }

    public void clearGlErrors(boolean report) {
        int err;
        while ((err = GL11.glGetError()) != 0) {
            if (!report || this.glErrors > 20) continue;
            ++this.glErrors;
            if (this.glErrors < 20) {
                this.logger.warn("GL Error occurred during JourneyMap draw: " + err);
                continue;
            }
            this.logger.warn("GL Error reporting during JourneyMap will be suppressed after max errors: 20");
        }
    }

    public Point2D.Double getPixel(double blockX, double blockZ) {
        Point2D.Double pixel = this.getBlockPixelInGrid(blockX, blockZ);
        if (this.isOnScreen(pixel)) {
            return pixel;
        }
        return null;
    }

    public void ensureOnScreen(Point2D pixel) {
        if (this.screenBounds == null) {
            return;
        }
        double x = pixel.getX();
        if (x < this.screenBounds.x) {
            x = this.screenBounds.x;
        } else if (x > this.screenBounds.getMaxX()) {
            x = this.screenBounds.getMaxX();
        }
        double y = pixel.getY();
        if (y < this.screenBounds.y) {
            y = this.screenBounds.y;
        } else if (y > this.screenBounds.getMaxY()) {
            y = this.screenBounds.getMaxY();
        }
        pixel.setLocation(x, y);
    }

    private boolean isOnScreen(TilePos pos) {
        return true;
    }

    public boolean isOnScreen(Point2D.Double pixel) {
        return this.screenBounds.contains(pixel);
    }

    public boolean isOnScreen(double x, double y) {
        return this.screenBounds.contains(x, y);
    }

    public boolean isOnScreen(double startX, double startY, int width, int height) {
        if (this.screenBounds == null) {
            return false;
        }
        return this.screenBounds.intersects(startX, startY, width, height);
    }

    private void updateBounds(int width, int height) {
        if (this.screenBounds == null || this.lastWidth != width || this.lastHeight != height) {
            this.lastWidth = width;
            this.lastHeight = height;
            this.screenBounds = this.viewPort == null ? new Rectangle2D.Double(0.0, 0.0, width, height) : new Rectangle2D.Double(((double)width - this.viewPort.width) / 2.0, ((double)height - this.viewPort.height) / 2.0, this.viewPort.width, this.viewPort.height);
        }
    }

    private void updateGridSize() {
        int newGridSizeHeight = (int)Math.ceil(this.screenBounds.height / 512.0 + 0.5);
        int newGridSizeWidth = (int)Math.ceil(this.screenBounds.width / 512.0 + 0.5);
        this.setGridSizes(newGridSizeHeight, newGridSizeWidth);
    }

    private Tile findNeighbor(Tile tile, TilePos pos) {
        if (pos.deltaX == 0 && pos.deltaZ == 0) {
            return tile;
        }
        return this.findTile(tile.tileX + pos.deltaX, tile.tileZ + pos.deltaZ, tile.zoom);
    }

    private Tile findTile(int tileX, int tileZ, int zoom) {
        return Tile.create(tileX, tileZ, zoom, this.worldDir, this.mapType, JourneymapClient.getCoreProperties().tileHighDisplayQuality.get());
    }

    public void setContext(File worldDir, MapType mapType) {
        this.worldDir = worldDir;
        this.mapType = mapType;
    }

    public void updateRotation(double rotation) {
        this.currentRotation = rotation;
        GL11.glGetInteger((int)2978, (IntBuffer)this.viewportBuf);
        GL11.glGetFloat((int)2982, (FloatBuffer)this.modelMatrixBuf);
        GL11.glGetFloat((int)2983, (FloatBuffer)this.projMatrixBuf);
    }

    public Point2D shiftWindowPosition(double x, double y, int shiftX, int shiftY) {
        if (this.currentRotation % 360.0 == 0.0) {
            return new Point2D.Double(x + (double)shiftX, y + (double)shiftY);
        }
        GLU.gluProject((float)((float)x), (float)((float)y), (float)0.0f, (FloatBuffer)this.modelMatrixBuf, (FloatBuffer)this.projMatrixBuf, (IntBuffer)this.viewportBuf, (FloatBuffer)this.winPosBuf);
        GLU.gluUnProject((float)(this.winPosBuf.get(0) + (float)shiftX), (float)(this.winPosBuf.get(1) + (float)shiftY), (float)0.0f, (FloatBuffer)this.modelMatrixBuf, (FloatBuffer)this.projMatrixBuf, (IntBuffer)this.viewportBuf, (FloatBuffer)this.objPosBuf);
        return new Point2D.Float(this.objPosBuf.get(0), this.objPosBuf.get(1));
    }

    public Point2D.Double getWindowPosition(Point2D.Double matrixPixel) {
        if (this.currentRotation % 360.0 == 0.0) {
            return matrixPixel;
        }
        GLU.gluProject((float)((float)matrixPixel.getX()), (float)((float)matrixPixel.getY()), (float)0.0f, (FloatBuffer)this.modelMatrixBuf, (FloatBuffer)this.projMatrixBuf, (IntBuffer)this.viewportBuf, (FloatBuffer)this.winPosBuf);
        return new Point2D.Double(this.winPosBuf.get(0), this.winPosBuf.get(1));
    }

    public Point2D.Double getMatrixPosition(Point2D.Double windowPixel) {
        GLU.gluUnProject((float)((float)windowPixel.x), (float)((float)windowPixel.y), (float)0.0f, (FloatBuffer)this.modelMatrixBuf, (FloatBuffer)this.projMatrixBuf, (IntBuffer)this.viewportBuf, (FloatBuffer)this.objPosBuf);
        return new Point2D.Double(this.objPosBuf.get(0), this.objPosBuf.get(1));
    }

    public double getCenterBlockX() {
        return this.centerBlockX;
    }

    public double getCenterBlockZ() {
        return this.centerBlockZ;
    }

    public File getWorldDir() {
        return this.worldDir;
    }

    public MapType getMapType() {
        return this.mapType;
    }

    public int getZoom() {
        return this.zoom;
    }

    public boolean setZoom(int zoom) {
        return this.center(this.mapType, this.centerBlockX, this.centerBlockZ, zoom);
    }

    public void clear() {
        this.grid.clear();
        messages.clear();
    }

    public int getWidth() {
        return this.lastWidth;
    }

    public int getHeight() {
        return this.lastHeight;
    }
}

