/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.events;

import ca.wescook.nutrition.Nutrition;
import ca.wescook.nutrition.data.PlayerDataHandler;
import ca.wescook.nutrition.effects.EffectsManager;
import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.nutrients.NutrientList;
import ca.wescook.nutrition.nutrients.NutrientUtils;
import ca.wescook.nutrition.proxy.ClientProxy;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBucketMilk;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import squeek.applecore.api.food.FoodEvent;

public class EventEatFood {
    @SubscribeEvent
    public void onFoodStatsChanged(FoodEvent.FoodStatsAddition event) {
        if (Nutrition.proxy.isClient()) {
            int hungerValue = event.foodValuesToBeAdded.hunger;
            if (hungerValue <= 0) {
                return;
            }
            ClientProxy.pushHungerChange(hungerValue);
        }
    }

    @SubscribeEvent
    public void onFoodEaten(FoodEvent.FoodEaten event) {
        List<Nutrient> foundNutrients = NutrientUtils.getFoodNutrients(event.food);
        float nutritionValue = NutrientUtils.calculateNutrition(event.foodValues, foundNutrients);
        if (!event.player.func_130014_f_().field_72995_K) {
            PlayerDataHandler.getForPlayer(event.player).add(foundNutrients, nutritionValue);
        }
        if (Nutrition.proxy.isClient()) {
            ClientProxy.localNutrition.add(foundNutrients, nutritionValue);
            ClientProxy.popHungerChange();
        }
    }

    @SubscribeEvent
    public void finishUsingItem(PlayerUseItemEvent.Finish event) {
        Entity entity = event.entity;
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (event.item.func_77973_b() instanceof ItemBucketMilk) {
            if (!player.func_130014_f_().field_72995_K) {
                EffectsManager.reapplyEffects(player);
                PlayerDataHandler.getForPlayer(player).add(NutrientList.getByName("dairy"), 1.5f);
            } else {
                ClientProxy.localNutrition.add(NutrientList.getByName("dairy"), 1.5f);
            }
        }
    }
}

