/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.vec;

import cofh.repack.codechicken.lib.vec.Matrix4;
import cofh.repack.codechicken.lib.vec.Transformation;
import cofh.repack.codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.lwjgl.opengl.GL11;

public class Scale
extends Transformation {
    public Vector3 factor;

    public Scale(Vector3 vector3) {
        this.factor = vector3;
    }

    public Scale(double d) {
        this(new Vector3(d, d, d));
    }

    public Scale(double d, double d2, double d3) {
        this(new Vector3(d, d2, d3));
    }

    @Override
    public void apply(Vector3 vector3) {
        vector3.multiply(this.factor);
    }

    @Override
    public void applyN(Vector3 vector3) {
    }

    @Override
    public void apply(Matrix4 matrix4) {
        matrix4.scale(this.factor);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void glApply() {
        GL11.glScaled((double)this.factor.x, (double)this.factor.y, (double)this.factor.z);
    }

    @Override
    public Transformation inverse() {
        return new Scale(1.0 / this.factor.x, 1.0 / this.factor.y, 1.0 / this.factor.z);
    }

    @Override
    public Transformation merge(Transformation transformation) {
        if (transformation instanceof Scale) {
            return new Scale(this.factor.copy().multiply(((Scale)transformation).factor));
        }
        return null;
    }

    @Override
    public boolean isRedundant() {
        return this.factor.equalsT(Vector3.one);
    }

    public String toString() {
        MathContext mathContext = new MathContext(4, RoundingMode.HALF_UP);
        return "Scale(" + new BigDecimal(this.factor.x, mathContext) + ", " + new BigDecimal(this.factor.y, mathContext) + ", " + new BigDecimal(this.factor.z, mathContext) + ")";
    }
}

