/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.transport;

import cofh.lib.network.ByteBufHelper;
import cofh.lib.transport.IEnderChannelRegistry;
import gnu.trove.map.hash.TIntObjectHashMap;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClientEnderChannelRegistry
implements IEnderChannelRegistry {
    private TIntObjectHashMap<String> channel = new TIntObjectHashMap();
    private ArrayList<IEnderChannelRegistry.Frequency> list = new ArrayList();
    private int modCount;
    protected String hostedChannel = "";

    public void readFrequencyData(ByteBuf byteBuf) {
        ++this.modCount;
        this.channel.clear();
        this.list.clear();
        int n = ByteBufHelper.readVarInt(byteBuf);
        this.hostedChannel = ByteBufHelper.readString(byteBuf);
        for (int i = 0; i < n; ++i) {
            int n2 = ByteBufHelper.readVarInt(byteBuf);
            String string = ByteBufHelper.readString(byteBuf);
            this.channel.put(n2, (Object)string);
            this.list.add(new IEnderChannelRegistry.Frequency(n2, string));
        }
        Collections.sort(this.list);
    }

    public String getChannelName() {
        return this.hostedChannel;
    }

    @Override
    public List<IEnderChannelRegistry.Frequency> getFrequencyList(String string) {
        return this.list;
    }

    @Override
    public String getFrequency(String string, int n) {
        return (String)this.channel.get(n);
    }

    @Override
    public String setFrequency(String string, int n, String string2) {
        ++this.modCount;
        IEnderChannelRegistry.Frequency frequency = new IEnderChannelRegistry.Frequency(n, string2);
        int n2 = this.list.indexOf(frequency);
        if (n2 < 0) {
            this.list.add(frequency);
            Collections.sort(this.list);
        } else {
            this.list.set(n2, frequency);
        }
        return (String)this.channel.put(n, (Object)string2);
    }

    @Override
    public String removeFrequency(String string, int n) {
        ++this.modCount;
        this.list.remove(new IEnderChannelRegistry.Frequency(n, ""));
        return (String)this.channel.remove(n);
    }

    @Override
    public int updated() {
        return this.modCount;
    }
}

