/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.block.tileentity;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import team.chisel.block.tileentity.IDoubleChest;
import team.chisel.init.ChiselBlocks;
import team.chisel.network.PacketHandler;
import team.chisel.network.message.MessagePresentConnect;

public class TileEntityPresent
extends TileEntity
implements IInventory,
IDoubleChest {
    private TileEntityPresent connection = null;
    private ForgeDirection cachedDir = null;
    private boolean isParent;
    private final ItemStack[] inventory = new ItemStack[27];
    private int rotation;
    private boolean autoSearch = true;

    public void func_145845_h() {
        if (!this.isConnected() && this.autoSearch && this.field_145850_b != null) {
            if (this.cachedDir != null) {
                this.connectTo(this.cachedDir);
            } else if (!this.field_145850_b.field_72995_K) {
                this.findConnections();
            }
            this.autoSearch = false;
        }
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    private boolean connectTo(TileEntityPresent present, ForgeDirection dir) {
        if (!(present.func_145832_p() != this.func_145832_p() || present.isConnected() || present.cachedDir != null && present.cachedDir != dir.getOpposite() || Math.abs(present.field_145851_c - this.field_145851_c + present.field_145848_d - this.field_145848_d + present.field_145849_e - this.field_145849_e) != 1)) {
            this.connection = present;
            this.connection.connection = this;
            this.connection.cachedDir = dir.getOpposite();
            this.connection.func_70296_d();
            this.cachedDir = dir;
            this.isParent = !present.isParent;
            this.func_70296_d();
            PacketHandler.INSTANCE.sendToDimension((IMessage)new MessagePresentConnect(this, dir, true), this.field_145850_b.field_73011_w.field_76574_g);
            return true;
        }
        return false;
    }

    public boolean connectTo(ForgeDirection dir) {
        int x = this.field_145851_c + dir.offsetX;
        int y = this.field_145848_d + dir.offsetY;
        int z = this.field_145849_e + dir.offsetZ;
        TileEntity te = this.getTileSafe(x, y, z);
        if (te instanceof TileEntityPresent) {
            return this.connectTo((TileEntityPresent)te, dir);
        }
        return !this.exists(x, y, z);
    }

    public void disconnect(boolean preserveDir) {
        if (this.isConnected()) {
            if (!preserveDir) {
                this.connection.cachedDir = null;
                this.cachedDir = null;
            }
            this.connection.connection = null;
            this.connection.func_70296_d();
            this.connection = null;
            this.func_70296_d();
            PacketHandler.INSTANCE.sendToDimension((IMessage)new MessagePresentConnect(this, ForgeDirection.UNKNOWN, false, preserveDir), this.field_145850_b.field_73011_w.field_76574_g);
        }
    }

    public TileEntityPresent getConnection() {
        return this.connection;
    }

    public ForgeDirection getConnectionDir() {
        return this.cachedDir == null ? ForgeDirection.UNKNOWN : this.cachedDir;
    }

    public boolean isParent() {
        return this.isParent || !this.isConnected();
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rot) {
        this.rotation = rot;
    }

    public void findConnections() {
        if (!this.isConnected()) {
            if (this.cachedDir != null && this.connectTo(this.cachedDir)) {
                return;
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (dir == ForgeDirection.UP || dir == ForgeDirection.DOWN || !this.connectTo(dir)) continue;
                return;
            }
        }
    }

    public TileEntityPresent getParent() {
        return this.isParent || this.connection == null ? this : this.connection;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return ChiselBlocks.present.getBoundingBox(this);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.getTrueSizeInventory(); ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        tag.func_74782_a("Items", (NBTBase)nbttaglist);
        tag.func_74757_a("isParent", this.isParent);
        tag.func_74768_a("rotation", this.rotation);
        if (this.cachedDir != null) {
            tag.func_74768_a("conDir", this.cachedDir.ordinal());
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList nbttaglist = tag.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.getTrueSizeInventory()) continue;
            this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.isParent = tag.func_74767_n("isParent");
        this.rotation = tag.func_74762_e("rotation");
        if (tag.func_74764_b("conDir")) {
            this.cachedDir = ForgeDirection.values()[tag.func_74762_e("conDir")];
        }
        this.autoSearch = true;
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldBlock != newBlock;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.isConnected()) {
            this.disconnect(false);
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.isConnected()) {
            this.disconnect(true);
        }
    }

    private int getAdjustedSlot(int slot) {
        slot %= this.func_70302_i_();
        if (this.isConnected() && !this.isParent) {
            slot = (slot + this.getTrueSizeInventory()) % this.func_70302_i_();
        }
        return slot;
    }

    private TileEntity getTileSafe(int x, int y, int z) {
        if (this.exists(x, y, z)) {
            return this.field_145850_b.func_147438_o(x, y, z);
        }
        return null;
    }

    private boolean exists(int x, int y, int z) {
        return this.field_145850_b.func_72899_e(x, y, z);
    }

    public int func_70302_i_() {
        return this.isConnected() ? this.getTrueSizeInventory() + this.connection.getTrueSizeInventory() : this.getTrueSizeInventory();
    }

    public ItemStack func_70301_a(int slot) {
        if ((slot = this.getAdjustedSlot(slot)) >= this.getTrueSizeInventory()) {
            return this.isConnected() ? this.connection.inventory[slot % this.getTrueSizeInventory()] : null;
        }
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        slot = this.getAdjustedSlot(slot);
        ItemStack[] inv = this.inventory;
        if (this.isConnected() && slot >= this.getTrueSizeInventory()) {
            inv = this.connection.inventory;
            slot %= this.getTrueSizeInventory();
            this.connection.func_70296_d();
        }
        if (inv[slot] != null) {
            if (inv[slot].field_77994_a <= amount) {
                ItemStack itemstack = inv[slot];
                inv[slot] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = inv[slot].func_77979_a(amount);
            if (inv[slot].field_77994_a == 0) {
                inv[slot] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return this.func_70301_a(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if ((slot = this.getAdjustedSlot(slot)) < this.getTrueSizeInventory()) {
            this.inventory[slot] = stack;
        } else if (this.isConnected()) {
            this.connection.inventory[slot % this.getTrueSizeInventory()] = stack;
            this.connection.func_70296_d();
        }
    }

    public String func_145825_b() {
        return "chisel.present";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }

    @Override
    public int getTrueSizeInventory() {
        return this.inventory.length;
    }

    @Override
    public ItemStack getTrueStackInSlot(int slot) {
        return this.inventory[slot % this.getTrueSizeInventory()];
    }

    @Override
    public void putStackInTrueSlot(int slot, ItemStack stack) {
        this.inventory[slot % this.getTrueSizeInventory()] = stack;
    }
}

