/*
 * Decompiled with CFR 0.152.
 */
package com.gtnh.findit.handler;

import codechicken.nei.recipe.StackInfo;
import com.gtnh.findit.IStackFilter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MinecraftProvider
implements IStackFilter.IStackFilterProvider {
    @Override
    public IStackFilter getFilter(EntityPlayer player, TileEntity tileEntity) {
        IStackFilter.AnyMultiItemFilter anyFilter = new IStackFilter.AnyMultiItemFilter();
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            anyFilter.add(new IStackFilter.InventoryStackFilter(player, inventory));
        }
        if (tileEntity instanceof IFluidTank) {
            IFluidTank tank = (IFluidTank)tileEntity;
            anyFilter.add(new IStackFilter.FluidStackFilter(tank.getFluid()));
        }
        if (tileEntity instanceof IFluidHandler) {
            IFluidHandler handler = (IFluidHandler)tileEntity;
            FluidTankInfo[] tankInfo = handler.getTankInfo(ForgeDirection.UNKNOWN);
            IStackFilter.FluidStackFilter filter = new IStackFilter.FluidStackFilter();
            for (FluidTankInfo info : tankInfo) {
                filter.add(info.fluid);
            }
            anyFilter.add(filter);
        }
        return anyFilter.isEmpty() ? null : anyFilter;
    }

    @Override
    public IStackFilter getFilter(EntityPlayer player, ItemStack stack) {
        IStackFilter.AnyMultiItemFilter filter = new IStackFilter.AnyMultiItemFilter();
        FluidStack fluid = StackInfo.getFluid((ItemStack)stack);
        if (fluid != null) {
            filter.add(new IStackFilter.FluidStackFilter(fluid));
        }
        filter.add(request -> StackInfo.equalItemAndNBT((ItemStack)request.getStackToFind(), (ItemStack)stack, (boolean)true));
        return filter.isEmpty() ? null : filter;
    }
}

