/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi.godforge_modules;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.fluids.FluidTanksHandler;
import com.gtnewhorizons.modularui.api.fluids.IFluidTanksHandler;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.FluidSlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.TierEU;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.recipe.RecipeMapBuilder;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.misc.WirelessNetworkManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tectech.loader.recipe.Godforge;
import tectech.recipe.TecTechRecipeMaps;
import tectech.thing.gui.TecTechUITextures;
import tectech.thing.metaTileEntity.multi.godforge_modules.MTEBaseModule;
import tectech.util.CommonValues;
import tectech.util.GodforgeMath;

public class MTEExoticModule
extends MTEBaseModule {
    private int numberOfFluids = 0;
    private int numberOfItems = 0;
    private long ticker = 0L;
    private long EUt = 0L;
    private long actualParallel = 0L;
    private boolean recipeInProgress = false;
    private boolean recipeRegenerated = false;
    private boolean magmatterMode = false;
    private FluidStack[] randomizedFluidInput = new FluidStack[0];
    private ItemStack[] randomizedItemInput = new ItemStack[0];
    List<FluidStack> inputPlasmas = new ArrayList<FluidStack>();
    private GTRecipe plasmaRecipe = null;
    private BigInteger powerForRecipe = BigInteger.ZERO;
    private static RecipeMap<RecipeMapBackend> tempRecipeMap = RecipeMapBuilder.of("godforgeExoticTempRecipeMap").maxIO(0, 0, 7, 2).disableRegisterNEI().build();
    private static final int NUMBER_OF_INPUTS = 7;
    private static final int INPUT_LIST_WINDOW_ID = 10;

    public MTEExoticModule(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEExoticModule(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEExoticModule(this.mName);
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected Stream<GTRecipe> findRecipeMatches(@Nullable RecipeMap<?> map) {
                if (!MTEExoticModule.this.recipeInProgress) {
                    if (MTEExoticModule.this.magmatterMode) {
                        MTEExoticModule.this.plasmaRecipe = MTEExoticModule.this.generateMagmatterRecipe();
                    } else {
                        MTEExoticModule.this.plasmaRecipe = MTEExoticModule.this.generateQuarkGluonRecipe();
                    }
                    tempRecipeMap.add(MTEExoticModule.this.plasmaRecipe);
                }
                return tempRecipeMap.getAllRecipes().parallelStream();
            }

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                if (!MTEExoticModule.this.recipeInProgress || MTEExoticModule.this.recipeRegenerated) {
                    MTEExoticModule.this.powerForRecipe = BigInteger.valueOf(MTEExoticModule.this.getProcessingVoltage()).multiply(BigInteger.valueOf((long)recipe.mDuration * MTEExoticModule.this.actualParallel));
                    if (WirelessNetworkManager.getUserEU(MTEExoticModule.this.userUUID).compareTo(MTEExoticModule.this.powerForRecipe) < 0) {
                        ((RecipeMapBackend)tempRecipeMap.getBackend()).clearRecipes();
                        return CheckRecipeResultRegistry.insufficientStartupPower(MTEExoticModule.this.powerForRecipe);
                    }
                    if (MTEExoticModule.this.numberOfFluids != 0) {
                        for (FluidStack fluidStack : MTEExoticModule.this.randomizedFluidInput) {
                            MTEExoticModule.dumpFluid(MTEExoticModule.this.mOutputHatches, new FluidStack(fluidStack.getFluid(), fluidStack.amount / 1000), false);
                        }
                    }
                    if (MTEExoticModule.this.numberOfItems != 0) {
                        for (FluidStack fluidStack : MTEExoticModule.this.randomizedItemInput) {
                            MTEExoticModule.this.addOutput((ItemStack)fluidStack);
                        }
                    }
                    MTEExoticModule.this.recipeInProgress = true;
                    MTEExoticModule.this.recipeRegenerated = false;
                }
                if (new HashSet<FluidStack>(Arrays.asList(this.inputFluids)).containsAll(MTEExoticModule.this.inputPlasmas)) {
                    return CheckRecipeResultRegistry.SUCCESSFUL;
                }
                return SimpleCheckRecipeResult.ofFailure("waiting_for_inputs");
            }

            @Override
            @NotNull
            protected CheckRecipeResult onRecipeStart(@Nonnull GTRecipe recipe) {
                MTEExoticModule.this.EUt = this.calculatedEut;
                MTEExoticModule.this.powerForRecipe = BigInteger.valueOf(MTEExoticModule.this.EUt).multiply(BigInteger.valueOf((long)this.duration * MTEExoticModule.this.actualParallel));
                if (!WirelessNetworkManager.addEUToGlobalEnergyMap(MTEExoticModule.this.userUUID, MTEExoticModule.this.powerForRecipe.negate())) {
                    return CheckRecipeResultRegistry.insufficientStartupPower(MTEExoticModule.this.powerForRecipe);
                }
                MTEExoticModule.this.addToPowerTally(MTEExoticModule.this.powerForRecipe);
                MTEExoticModule.this.addToRecipeTally(this.calculatedParallels);
                this.setCalculatedEut(0L);
                ((RecipeMapBackend)tempRecipeMap.getBackend()).clearRecipes();
                MTEExoticModule.this.recipeInProgress = false;
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@Nonnull GTRecipe recipe) {
                return super.createOverclockCalculator(recipe).setEUt(MTEExoticModule.this.getProcessingVoltage()).setDurationDecreasePerOC(MTEExoticModule.this.getOverclockTimeFactor());
            }
        };
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(Long.MAX_VALUE);
        logic.setAvailableAmperage(Integer.MAX_VALUE);
        logic.setAmperageOC(false);
        logic.setSpeedBonus(this.getSpeedBonus());
        logic.setEuModifier(this.getEnergyDiscount());
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return TecTechRecipeMaps.godforgeExoticMatterRecipes;
    }

    private GTRecipe generateQuarkGluonRecipe() {
        this.actualParallel = this.getMaxParallel();
        tempRecipeMap.getBackend().clearRecipes();
        this.numberOfFluids = GodforgeMath.getRandomIntInRange(0, 7);
        this.numberOfItems = 7 - this.numberOfFluids;
        this.randomizedFluidInput = this.getRandomFluidInputs(Godforge.exoticModulePlasmaFluidMap, this.numberOfFluids);
        this.randomizedItemInput = this.getRandomItemInputs(Godforge.exoticModulePlasmaItemMap, this.numberOfItems);
        if (this.numberOfFluids != 0) {
            for (FluidStack fluidStack : this.randomizedFluidInput) {
                fluidStack.amount = 1000 * GodforgeMath.getRandomIntInRange(1, 64);
            }
        }
        if (this.numberOfItems != 0) {
            for (FluidStack fluidStack : this.randomizedItemInput) {
                fluidStack.field_77994_a = 9 * GodforgeMath.getRandomIntInRange(1, 7);
            }
        }
        this.inputPlasmas = new ArrayList<FluidStack>(Arrays.asList(this.convertItemToPlasma(this.randomizedItemInput, 1L)));
        this.inputPlasmas.addAll(Arrays.asList(this.convertFluidToPlasma(this.randomizedFluidInput, 1L)));
        return new GTRecipe(false, null, null, null, null, this.inputPlasmas.toArray(new FluidStack[0]), new FluidStack[]{MaterialsUEVplus.QuarkGluonPlasma.getFluid(1000L * this.actualParallel)}, 200, (int)TierEU.RECIPE_MAX, 0);
    }

    private GTRecipe generateMagmatterRecipe() {
        this.actualParallel = this.getMaxParallel();
        tempRecipeMap.getBackend().clearRecipes();
        this.randomizedItemInput = this.getRandomItemInputs(Godforge.exoticModuleMagmatterItemMap, 1);
        this.numberOfItems = 1;
        this.numberOfFluids = 2;
        int timeAmount = GodforgeMath.getRandomIntInRange(1, 50);
        int spaceAmount = GodforgeMath.getRandomIntInRange(51, 100);
        this.randomizedFluidInput = new FluidStack[]{MaterialsUEVplus.Time.getMolten((long)timeAmount * 1000L), MaterialsUEVplus.Space.getMolten((long)spaceAmount * 1000L)};
        this.inputPlasmas = new ArrayList<FluidStack>(Arrays.asList(this.convertItemToPlasma(this.randomizedItemInput, spaceAmount - timeAmount)));
        this.inputPlasmas.add(MaterialsUEVplus.Time.getMolten(timeAmount));
        this.inputPlasmas.add(MaterialsUEVplus.Space.getMolten(spaceAmount));
        return new GTRecipe(false, null, null, null, null, this.inputPlasmas.toArray(new FluidStack[0]), new FluidStack[]{MaterialsUEVplus.MagMatter.getMolten(576L * this.actualParallel)}, 200, (int)TierEU.RECIPE_MAX, 0);
    }

    /*
     * WARNING - void declaration
     */
    private FluidStack[] getRandomFluidInputs(HashMap<FluidStack, Integer> fluidMap, int numberOfFluids) {
        void var7_9;
        int cumulativeWeight = 0;
        ArrayList<Map.Entry<FluidStack, Integer>> fluidEntryList = new ArrayList<Map.Entry<FluidStack, Integer>>(fluidMap.entrySet());
        ArrayList<Integer> cumulativeWeights = new ArrayList<Integer>();
        for (Map.Entry entry : fluidEntryList) {
            cumulativeWeights.add(cumulativeWeight += ((Integer)entry.getValue()).intValue());
        }
        ArrayList<FluidStack> pickedFluids = new ArrayList<FluidStack>();
        boolean bl = false;
        while (var7_9 < numberOfFluids) {
            int randomWeight = GodforgeMath.getRandomIntInRange(1, cumulativeWeight);
            for (int j = 0; j < cumulativeWeights.size(); ++j) {
                if (randomWeight > (Integer)cumulativeWeights.get(j)) continue;
                FluidStack pickedFluid = (FluidStack)((Map.Entry)fluidEntryList.get(j)).getKey();
                if (pickedFluids.contains(pickedFluid)) {
                    --var7_9;
                    break;
                }
                pickedFluids.add(pickedFluid);
                break;
            }
            ++var7_9;
        }
        return pickedFluids.toArray(new FluidStack[0]);
    }

    /*
     * WARNING - void declaration
     */
    private ItemStack[] getRandomItemInputs(HashMap<ItemStack, Integer> itemMap, int numberOfItems) {
        void var7_9;
        int cumulativeWeight = 0;
        ArrayList<Map.Entry<ItemStack, Integer>> itemEntryList = new ArrayList<Map.Entry<ItemStack, Integer>>(itemMap.entrySet());
        ArrayList<Integer> cumulativeWeights = new ArrayList<Integer>();
        for (Map.Entry entry : itemEntryList) {
            cumulativeWeights.add(cumulativeWeight += ((Integer)entry.getValue()).intValue());
        }
        ArrayList<ItemStack> pickedItems = new ArrayList<ItemStack>();
        boolean bl = false;
        while (var7_9 < numberOfItems) {
            int randomWeight = GodforgeMath.getRandomIntInRange(1, cumulativeWeight);
            for (int j = 0; j < cumulativeWeights.size(); ++j) {
                if (randomWeight > (Integer)cumulativeWeights.get(j)) continue;
                ItemStack pickedItem = (ItemStack)((Map.Entry)itemEntryList.get(j)).getKey();
                if (pickedItems.contains(pickedItem)) {
                    --var7_9;
                    break;
                }
                pickedItems.add(pickedItem);
                break;
            }
            ++var7_9;
        }
        return pickedItems.toArray(new ItemStack[0]);
    }

    private FluidStack[] convertItemToPlasma(ItemStack[] items, long multiplier) {
        ArrayList<FluidStack> plasmas = new ArrayList<FluidStack>();
        for (ItemStack itemStack : items) {
            String dict = OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)itemStack)[0]);
            String strippedOreDict = dict.substring(8);
            plasmas.add(FluidRegistry.getFluidStack((String)("plasma." + strippedOreDict.toLowerCase()), (int)((int)(144L * multiplier * (long)itemStack.field_77994_a))));
        }
        return plasmas.toArray(new FluidStack[0]);
    }

    private FluidStack[] convertFluidToPlasma(FluidStack[] fluids, long multiplier) {
        ArrayList<FluidStack> plasmas = new ArrayList<FluidStack>();
        for (FluidStack fluidStack : fluids) {
            String[] fluidName = fluidStack.getUnlocalizedName().split("\\.");
            plasmas.add(FluidRegistry.getFluidStack((String)("plasma." + fluidName[fluidName.length - 1]), (int)((int)(multiplier * (long)fluidStack.amount))));
        }
        return plasmas.toArray(new FluidStack[0]);
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return false;
    }

    @Override
    public boolean supportsBatchMode() {
        return false;
    }

    @Override
    public void saveNBTData(NBTTagCompound NBT2) {
        NBT2.func_74757_a("recipeInProgress", this.recipeInProgress);
        NBT2.func_74757_a("magmatterMode", this.magmatterMode);
        NBT2.func_74772_a("maxParallel", this.actualParallel);
        NBTTagCompound fluidStackListNBTTag = new NBTTagCompound();
        fluidStackListNBTTag.func_74772_a("numberOfPlasmas", (long)this.inputPlasmas.size());
        int indexFluids = 0;
        for (FluidStack fluidStack : this.inputPlasmas) {
            fluidStackListNBTTag.func_74772_a(indexFluids + "fluidAmount", (long)fluidStack.amount);
            NBT2.func_74782_a(indexFluids + "fluidStack", (NBTBase)fluidStack.writeToNBT(new NBTTagCompound()));
            ++indexFluids;
        }
        NBT2.func_74782_a("inputPlasmas", (NBTBase)fluidStackListNBTTag);
        super.saveNBTData(NBT2);
    }

    @Override
    public void loadNBTData(NBTTagCompound NBT2) {
        this.recipeInProgress = NBT2.func_74767_n("recipeInProgress");
        this.magmatterMode = NBT2.func_74767_n("magmatterMode");
        this.actualParallel = NBT2.func_74763_f("maxParallel");
        NBTTagCompound tempFluidTag = NBT2.func_74775_l("inputPlasmas");
        int indexFluids = 0;
        while ((long)indexFluids < tempFluidTag.func_74763_f("numberOfPlasmas")) {
            int fluidAmount = tempFluidTag.func_74762_e(indexFluids + "fluidAmount");
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)NBT2.func_74775_l(indexFluids + "fluidStack"));
            this.inputPlasmas.add(new FluidStack(fluidStack, fluidAmount));
            ++indexFluids;
        }
        FluidStack outputFluid = MaterialsUEVplus.QuarkGluonPlasma.getFluid(1000L * this.actualParallel);
        if (this.magmatterMode) {
            outputFluid = MaterialsUEVplus.MagMatter.getMolten(576L * this.actualParallel);
        }
        tempRecipeMap.add(new GTRecipe(false, null, null, null, null, this.inputPlasmas.toArray(new FluidStack[0]), new FluidStack[]{outputFluid}, 200, (int)TierEU.RECIPE_MAX, 0));
        super.loadNBTData(NBT2);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        ++this.ticker;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.widget(new DrawableWidget().setPos(8, 69).setSize(16, 16).addTooltip(StatCollector.func_74838_a((String)"fog.button.exoticinputs.tooltip")).setTooltipShowUpDelay(5));
        super.addUIWidgets(builder, buildContext);
        buildContext.addSyncedWindow(10, this::createInputListWindow);
        builder.widget((Widget)this.magmatterSwitch((IWidgetBuilder<?>)builder));
        builder.widget(this.createExpectedInputsButton());
        builder.widget(new DrawableWidget().setDrawable((IDrawable)ModularUITextures.ICON_INFO).setPos(8, 69).setSize(16, 16));
    }

    protected ModularWindow createInputListWindow(EntityPlayer player) {
        int WIDTH = 100;
        int HEIGHT = 60;
        int PARENT_WIDTH = this.getGUIWidth();
        int PARENT_HEIGHT = this.getGUIHeight();
        Pos2d[] slotPositions = new Pos2d[]{new Pos2d(23, 35), new Pos2d(41, 35), new Pos2d(59, 35), new Pos2d(14, 17), new Pos2d(32, 17), new Pos2d(50, 17), new Pos2d(68, 17)};
        ModularWindow.Builder builder = ModularWindow.builder((int)100, (int)60);
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        builder.setDraggable(true);
        builder.setPos((size, window) -> Alignment.Center.getAlignedPos(size, new Size(PARENT_WIDTH, PARENT_HEIGHT)).add(Alignment.TopLeft.getAlignedPos(new Size(PARENT_WIDTH, PARENT_HEIGHT), new Size(100, 60))).subtract(100, -47));
        FluidTanksHandler tanksHandler = new FluidTanksHandler(7, 128000L);
        for (int i = 0; i < 7; ++i) {
            if (i < this.inputPlasmas.size()) {
                FluidStack plasma = this.inputPlasmas.get(i);
                tanksHandler.setFluidInTank(i, plasma.getFluid(), (long)plasma.amount);
            }
            ((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)ModularUITextures.FLUID_SLOT).setSize(18, 18).setPos(slotPositions[i]))).widget(new FluidSlotWidget((IFluidTanksHandler)tanksHandler, i).setInteraction(false, false).setSize(18, 18).setPos(slotPositions[i]).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(() -> this.recipeInProgress, val -> {
                this.recipeInProgress = val;
            }), (IWidgetBuilder)builder, (widget, val) -> widget.checkNeedsRebuild()));
        }
        builder.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.expectedinputs")).setDefaultColor(EnumChatFormatting.BLACK).setTextAlignment(Alignment.Center).setSize(100, 9).setPos(0, 6));
        builder.widget(new ButtonWidget().setOnClick((arg_0, arg_1) -> this.lambda$createInputListWindow$4((IFluidTanksHandler)tanksHandler, arg_0, arg_1)).setPlayClickSound(true).setBackground(new IDrawable[]{TecTechUITextures.OVERLAY_CYCLIC_BLUE}).dynamicTooltip(this::refreshTooltip).setTooltipShowUpDelay(5).setSize(16, 16).setPos(5, 37).attachSyncer((FakeSyncWidget)new FakeSyncWidget.LongSyncer(() -> this.ticker, val -> {
            this.ticker = val;
        }), (IWidgetBuilder)builder, (widget, val) -> widget.notifyTooltipChange()));
        return builder.build();
    }

    private Widget createExpectedInputsButton() {
        return new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(10);
            }
        }).setPlayClickSound(true).setSize(16, 16).setPos(8, 69);
    }

    protected ButtonWidget magmatterSwitch(IWidgetBuilder<?> builder) {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.isMagmatterCapable) {
                this.magmatterMode = !this.magmatterMode;
            }
        }).setPlayClickSound(this.isMagmatterCapable).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            if (this.isMagmatterModeOn()) {
                ret.add(GTUITextures.BUTTON_STANDARD_PRESSED);
                if (this.isMagmatterCapable) {
                    ret.add(GTUITextures.OVERLAY_BUTTON_CHECKMARK);
                } else {
                    ret.add(GTUITextures.OVERLAY_BUTTON_DISABLE);
                }
            } else {
                ret.add(GTUITextures.BUTTON_STANDARD);
                if (this.isMagmatterCapable) {
                    ret.add(GTUITextures.OVERLAY_BUTTON_CROSS);
                } else {
                    ret.add(GTUITextures.OVERLAY_BUTTON_DISABLE);
                }
            }
            if (!this.isMagmatterCapable) {
                ret.add(GTUITextures.OVERLAY_BUTTON_DISABLE);
            }
            return ret.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(this::isMagmatterModeOn, this::setMagmatterMode), builder).addTooltip(StatCollector.func_74838_a((String)"fog.button.magmattermode.tooltip.01")).setTooltipShowUpDelay(5).setPos(174, 91).setSize(16, 16).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(() -> this.isMagmatterCapable, this::setMagmatterCapable), builder);
        if (!this.isMagmatterCapable) {
            button.addTooltip(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"fog.button.magmattermode.tooltip.02"));
        }
        return (ButtonWidget)button;
    }

    private List<String> refreshTooltip() {
        if (this.ticker > 1200L) {
            return ImmutableList.of((Object)StatCollector.func_74838_a((String)"fog.button.reciperefresh.tooltip"));
        }
        return ImmutableList.of((Object)(StatCollector.func_74838_a((String)"fog.button.refreshtimer.tooltip") + " " + (int)Math.ceil((double)(1200L - this.ticker) / 20.0) + " " + StatCollector.func_74838_a((String)"fog.button.seconds")));
    }

    public boolean isMagmatterModeOn() {
        return this.magmatterMode;
    }

    private void setMagmatterMode(boolean enabled) {
        this.magmatterMode = enabled;
    }

    @Override
    public MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Exotic Matter Producer").addInfo("Controller block for the Heliofusion Exoticizer, a module of the Godforge.").addInfo("Must be part of a Godforge to function.").addInfo("Used for ultra high temperature matter degeneration.").addInfo(TOOLTIP_BAR).addInfo("The fourth and final module of the Godforge, this module breaks apart the very").addInfo("building blocks of matter, producing exotic mixtures in the process. Quark-Gluon Plasma").addInfo("can be manufactured right away, but production of Magnetic Monopole Matter (Magmatter)").addInfo("requires a fully upgraded Godforge.").addInfo("This module is specialized towards acquisition of unique materials.").addInfo(TOOLTIP_BAR).beginStructureBlock(7, 7, 13, false).addStructureInfo("The structure is too complex! See schematic for details.").addStructureInfo(EnumChatFormatting.GOLD + "20" + EnumChatFormatting.GRAY + " Singularity Reinforced Stellar Shielding Casing").addStructureInfo(EnumChatFormatting.GOLD + "20" + EnumChatFormatting.GRAY + " Boundless Gravitationally Severed Structure Casing").addStructureInfo(EnumChatFormatting.GOLD + "5" + EnumChatFormatting.GRAY + " Harmonic Phonon Transmission Conduit").addStructureInfo(EnumChatFormatting.GOLD + "5" + EnumChatFormatting.GRAY + " Celestial Matter Guidance Casing").addStructureInfo(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " Stellar Energy Siphon Casing").addStructureInfo("Requires " + EnumChatFormatting.GOLD + 1 + EnumChatFormatting.GRAY + " Output Hatch").addStructureInfo("Requires " + EnumChatFormatting.GOLD + 1 + EnumChatFormatting.GRAY + " Output Bus").toolTipFinisher(CommonValues.GODFORGE_MARK);
        return tt;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> str = new ArrayList<String>();
        str.add("Progress: " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s");
        str.add("Currently using: " + EnumChatFormatting.RED + (this.getBaseMetaTileEntity().isActive() ? GTUtility.formatNumbers(this.EUt * this.actualParallel) : "0") + EnumChatFormatting.RESET + " EU/t");
        str.add(EnumChatFormatting.YELLOW + "Max Parallel: " + EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getMaxParallel()));
        str.add(EnumChatFormatting.YELLOW + "Current Parallel: " + EnumChatFormatting.RESET + (this.getBaseMetaTileEntity().isActive() ? GTUtility.formatNumbers(this.getMaxParallel()) : "0"));
        str.add(EnumChatFormatting.YELLOW + "Recipe time multiplier: " + EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getSpeedBonus()));
        str.add(EnumChatFormatting.YELLOW + "Energy multiplier: " + EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getEnergyDiscount()));
        str.add(EnumChatFormatting.YELLOW + "Recipe time divisor per non-perfect OC: " + EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getOverclockTimeFactor()));
        return str.toArray(new String[0]);
    }

    private /* synthetic */ void lambda$createInputListWindow$4(IFluidTanksHandler tanksHandler, Widget.ClickData clickData, Widget widget) {
        if (!widget.isClient() && this.ticker > 1200L) {
            this.plasmaRecipe = this.magmatterMode ? this.generateMagmatterRecipe() : this.generateQuarkGluonRecipe();
            this.recipeRegenerated = true;
            tempRecipeMap.add(this.plasmaRecipe);
            for (int i = 0; i < 7; ++i) {
                if (i >= this.inputPlasmas.size()) continue;
                FluidStack plasma = this.inputPlasmas.get(i);
                tanksHandler.setFluidInTank(i, plasma.getFluid(), (long)plasma.amount);
            }
            this.ticker = 0L;
            widget.getContext().closeWindow(10);
            widget.getContext().openSyncedWindow(10);
        }
    }
}

