/*
 * Decompiled with CFR 0.152.
 */
package kubatech.tileentity.gregtech.multiblock.eigbuckets;

import gregtech.api.GregTechAPI;
import gregtech.api.enums.ItemList;
import gregtech.common.blocks.BlockOresAbstract;
import gregtech.common.blocks.ItemOres;
import gregtech.common.blocks.TileEntityOres;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropTile;
import ic2.core.Ic2Items;
import ic2.core.crop.CropStickreed;
import ic2.core.crop.IC2Crops;
import ic2.core.crop.TileEntityCrop;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import kubatech.api.eig.EIGBucket;
import kubatech.api.eig.EIGDropTable;
import kubatech.api.eig.IEIGBucketFactory;
import kubatech.tileentity.gregtech.multiblock.MTEExtremeIndustrialGreenhouse;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EIGIC2Bucket
extends EIGBucket {
    public static final IEIGBucketFactory factory = new Factory();
    private static final String NBT_IDENTIFIER = "IC2";
    private static final int REVISION_NUMBER = 0;
    private static final int NUMBER_OF_DROPS_TO_SIMULATE = 1000;
    private static final boolean IS_ON_WET_FARMLAND = true;
    private static final int WATER_STORAGE_VALUE = 200;
    private static final int NUMBER_OF_DIRT_BLOCKS_UNDER = 0;
    private static final int FERTILIZER_STORAGE_VALUE = 0;
    private static final int CROP_OBSTRUCTION_VALUE = 5;
    private static final boolean CROP_CAN_SEE_SKY = false;
    public final boolean useNoHumidity;
    private double growthTime;
    private EIGDropTable drops;
    private boolean isValid;
    private static final double SQRT2PI = Math.sqrt(Math.PI * 2);

    public EIGIC2Bucket(ItemStack seed, int count, ItemStack supportBlock, boolean useNoHumidity) {
        ItemStack[] itemStackArray;
        if (supportBlock == null) {
            itemStackArray = null;
        } else {
            ItemStack[] itemStackArray2 = new ItemStack[1];
            itemStackArray = itemStackArray2;
            itemStackArray2[0] = supportBlock;
        }
        super(seed, count, itemStackArray);
        this.growthTime = 0.0;
        this.drops = new EIGDropTable();
        this.isValid = false;
        this.useNoHumidity = useNoHumidity;
        this.isValid = false;
    }

    private EIGIC2Bucket(MTEExtremeIndustrialGreenhouse greenhouse, ItemStack seed) {
        super(seed, 1, null);
        this.growthTime = 0.0;
        this.drops = new EIGDropTable();
        this.isValid = false;
        this.useNoHumidity = greenhouse.isInNoHumidityMode();
        this.recalculateDrops(greenhouse);
    }

    private EIGIC2Bucket(NBTTagCompound nbt) {
        super(nbt);
        this.growthTime = 0.0;
        this.drops = new EIGDropTable();
        this.isValid = false;
        this.useNoHumidity = nbt.func_74767_n("useNoHumidity");
        if (!nbt.func_74764_b("invalid")) {
            this.drops = new EIGDropTable(nbt, "drops");
            this.growthTime = nbt.func_74769_h("growthTime");
            this.isValid = nbt.func_74762_e("version") == 0 && this.growthTime > 0.0 && !this.drops.isEmpty();
        }
    }

    @Override
    public NBTTagCompound save() {
        NBTTagCompound nbt = super.save();
        nbt.func_74757_a("useNoHumidity", this.useNoHumidity);
        if (this.isValid) {
            nbt.func_74782_a("drops", (NBTBase)this.drops.save());
            nbt.func_74780_a("growthTime", this.growthTime);
        } else {
            nbt.func_74757_a("invalid", true);
        }
        nbt.func_74768_a("version", 0);
        return nbt;
    }

    @Override
    protected String getNBTIdentifier() {
        return NBT_IDENTIFIER;
    }

    @Override
    public void addProgress(double multiplier, EIGDropTable tracker) {
        if (!this.isValid()) {
            return;
        }
        double growthPercent = multiplier / (this.growthTime * (double)TileEntityCrop.tickRate);
        if (this.drops != null) {
            this.drops.addTo(tracker, (double)this.seedCount * growthPercent);
        }
    }

    @Override
    protected void getAdditionalInfoData(StringBuilder sb) {
        sb.append(" | Humidity: ");
        sb.append(this.useNoHumidity ? "Off" : "On");
    }

    @Override
    public boolean revalidate(MTEExtremeIndustrialGreenhouse greenhouse) {
        this.recalculateDrops(greenhouse);
        return this.isValid();
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalculateDrops(MTEExtremeIndustrialGreenhouse greenhouse) {
        this.isValid = false;
        World world = greenhouse.getBaseMetaTileEntity().getWorld();
        int[] abc = new int[]{0, -2, 3};
        int[] xyz = new int[]{0, 0, 0};
        greenhouse.getExtendedFacing().getWorldOffset(abc, xyz);
        xyz[0] = xyz[0] + greenhouse.getBaseMetaTileEntity().getXCoord();
        xyz[1] = xyz[1] + greenhouse.getBaseMetaTileEntity().getYCoord();
        xyz[2] = xyz[2] + greenhouse.getBaseMetaTileEntity().getZCoord();
        boolean cheating = false;
        try {
            block22: {
                if (world.func_147439_a(xyz[0], xyz[1] - 2, xyz[2]) != GregTechAPI.sBlockCasings4 || world.func_72805_g(xyz[0], xyz[1] - 2, xyz[2]) != 1) {
                    cheating = true;
                    return;
                }
                FakeTileEntityCrop crop = new FakeTileEntityCrop(this, greenhouse, xyz);
                if (!crop.isValid) {
                    return;
                }
                CropCard cc = crop.getCrop();
                if (this.supportItems == null) break block22;
                if (this.supportItems.length != 1) break;
                if (this.supportItems[0] != null) {
                    if (!EIGIC2Bucket.setBlock(this.supportItems[0], xyz[0], xyz[1] - 2, xyz[2], world)) {
                        return;
                    }
                    crop.updateNutrientsForBlockUnder();
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            if (!cheating) {
                world.func_147465_d(xyz[0], xyz[1] - 2, xyz[2], GregTechAPI.sBlockCasings4, 1, 0);
            }
        }
    }

    private static boolean setBlock(ItemStack stack, int x, int y, int z, World world) {
        Item item = stack.func_77973_b();
        Block b = Block.func_149634_a((Item)item);
        if (b == Blocks.field_150350_a || !(item instanceof ItemBlock)) {
            return false;
        }
        short tDamage = (short)item.getDamage(stack);
        if (item instanceof ItemOres && tDamage > 0) {
            if (!world.func_147465_d(x, y, z, b, (int)TileEntityOres.getHarvestData(tDamage, ((BlockOresAbstract)b).getBaseBlockHarvestLevel(tDamage % 16000 / 1000)), 0)) {
                return false;
            }
            TileEntityOres tTileEntity = (TileEntityOres)world.func_147438_o(x, y, z);
            tTileEntity.mMetaData = tDamage;
            tTileEntity.mNatural = false;
        } else {
            world.func_147465_d(x, y, z, b, (int)tDamage, 0);
        }
        return true;
    }

    private static double getRealAverageDropRounds(TileEntityCrop te, CropCard cc) {
        double chance = (double)cc.dropGainChance() * Math.pow(1.03, te.getGain());
        double min = -10.0;
        double max = 10.0;
        int steps = 10000;
        double stepSize = (max - min) / (double)steps;
        double sum = 0.0;
        for (int k = 1; k <= steps - 1; ++k) {
            sum += EIGIC2Bucket.getWeightedDropChance(min + (double)k * stepSize, chance);
        }
        double minVal = EIGIC2Bucket.getWeightedDropChance(min, chance);
        double maxVal = EIGIC2Bucket.getWeightedDropChance(max, chance);
        return stepSize * ((minVal + maxVal) / 2.0 + sum);
    }

    private static double stdNormDistr(double x) {
        return Math.exp(-0.5 * (x * x)) / SQRT2PI;
    }

    private static double getWeightedDropChance(double x, double chance) {
        return (double)Math.max(0L, Math.round(x * chance * 0.6827 + chance)) * EIGIC2Bucket.stdNormDistr(x);
    }

    private static double getRealAverageDropIncrease(TileEntityCrop te, CropCard cc) {
        return (double)(te.getGain() + 1) / 100.0;
    }

    private static double calcRealAvgGrowthRate(TileEntityCrop te, CropCard cc, HashMap<Integer, Integer> sizeAfterHarvestFrequencies) {
        int[] growthSpeeds = new int[7];
        for (int i = 0; i < 7; ++i) {
            growthSpeeds[i] = EIGIC2Bucket.calcAvgGrowthRate(te, cc, i);
        }
        if (cc.getClass() == CropStickreed.class) {
            sizeAfterHarvestFrequencies.clear();
            sizeAfterHarvestFrequencies.put(1, 1);
            sizeAfterHarvestFrequencies.put(2, 1);
            sizeAfterHarvestFrequencies.put(3, 1);
        }
        int[] growthDurations = new int[cc.maxSize()];
        growthDurations[0] = 0;
        for (byte i = 1; i < growthDurations.length; i = (byte)(i + 1)) {
            te.setSize(i);
            growthDurations[i] = cc.growthDuration((ICropTile)te);
        }
        return EIGIC2Bucket.calcRealAvgGrowthRate(growthSpeeds, growthDurations, sizeAfterHarvestFrequencies);
    }

    public static double calcRealAvgGrowthRate(int[] growthSpeeds, int[] stageGoals, HashMap<Integer, Integer> startStageFrequency) {
        int[] nonZeroSpeeds = Arrays.stream(growthSpeeds).filter(x -> x > 0).toArray();
        int zeroRolls = growthSpeeds.length - nonZeroSpeeds.length;
        if (zeroRolls >= growthSpeeds.length) {
            return -1.0;
        }
        double[] avgCyclePerStage = new double[stageGoals.length];
        double[] normalizedStageFrequencies = new double[stageGoals.length];
        long frequenciesSum = startStageFrequency.values().parallelStream().mapToInt(x -> x).sum();
        for (int i = 0; i < stageGoals.length; ++i) {
            avgCyclePerStage[i] = EIGIC2Bucket.calcAvgCyclesToGoal(nonZeroSpeeds, stageGoals[i]);
            normalizedStageFrequencies[i] = (double)(startStageFrequency.getOrDefault(i, 0) * stageGoals.length) / (double)frequenciesSum;
        }
        double[] frequencyMultipliers = new double[avgCyclePerStage.length];
        Arrays.fill(frequencyMultipliers, 1.0);
        EIGIC2Bucket.conv1DAndCopyToSignal(frequencyMultipliers, normalizedStageFrequencies, new double[avgCyclePerStage.length], 0, frequencyMultipliers.length, 0);
        for (int i = 0; i < avgCyclePerStage.length; ++i) {
            int n = i;
            avgCyclePerStage[n] = avgCyclePerStage[n] * frequencyMultipliers[i];
        }
        double average = Arrays.stream(avgCyclePerStage).average().orElse(-1.0);
        if (average <= 0.0) {
            return -1.0;
        }
        if (zeroRolls > 0) {
            average = average / (double)nonZeroSpeeds.length * (double)growthSpeeds.length;
        }
        return average;
    }

    private static double calcAvgCyclesToGoal(int[] speeds, int goal) {
        double p;
        if (goal <= 0) {
            return 1.0;
        }
        double mult = 1.0;
        int goalCap = speeds[speeds.length - 1] * 1000;
        if (goal > goalCap) {
            mult = (double)goal / (double)goalCap;
            goal = goalCap;
        }
        double[] signal = new double[goal];
        Arrays.fill(signal, 0.0);
        signal[0] = 1.0;
        double[] kernel = EIGIC2Bucket.tabulate(speeds, 1.0 / (double)speeds.length);
        double[] convolutionTarget = new double[signal.length];
        LinkedList P = new LinkedList();
        double avgRolls = 1.0;
        int iterNo = 0;
        int min = speeds[0];
        int max = speeds[speeds.length - 1];
        do {
            p = EIGIC2Bucket.conv1DAndCopyToSignal(signal, kernel, convolutionTarget, min, max, iterNo);
            avgRolls += p;
            ++iterNo;
        } while (p >= 0.1 / (double)goal);
        return avgRolls * mult;
    }

    private static double[] tabulate(int[] bin, double multiplier) {
        double[] ret = new double[bin[bin.length - 1] + 1];
        Arrays.fill(ret, 0.0);
        int[] nArray = bin;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int i2;
            int n2 = i2 = nArray[i];
            ret[n2] = ret[n2] + multiplier;
        }
        return ret;
    }

    private static double conv1DAndCopyToSignal(double[] signal, double[] kernel, double[] fixedLengthTarget, int minValue, int maxValue, int iterNo) {
        int k;
        double sum = 0.0;
        int maxK = Math.min(signal.length, (iterNo + 1) * maxValue + 1);
        int startAt = Math.min(signal.length, minValue * (iterNo + 1));
        for (k = Math.max(0, startAt - kernel.length); k < startAt; ++k) {
            fixedLengthTarget[k] = 0.0;
        }
        while (k < maxK) {
            fixedLengthTarget[k] = 0.0;
            for (int i = Math.max(0, k - kernel.length + 1); i <= k; ++i) {
                double v = signal[i] * kernel[k - i];
                sum += v;
                int n = k;
                fixedLengthTarget[n] = fixedLengthTarget[n] + v;
            }
            ++k;
        }
        System.arraycopy(fixedLengthTarget, 0, signal, 0, signal.length);
        return sum;
    }

    private static int calcAvgGrowthRate(TileEntityCrop te, CropCard cc, int rngRoll) {
        int base = 3 + rngRoll + te.getGrowth();
        int need = Math.max(0, (cc.tier() - 1) * 4 + te.getGrowth() + te.getGain() + te.getResistance());
        int have = cc.weightInfluences((ICropTile)te, (float)te.getHumidity(), (float)te.getNutrients(), (float)te.getAirQuality()) * 5;
        if (have >= need) {
            return base * (100 + (have - need)) / 100;
        }
        int neg = (need - have) * 4;
        if (neg > 100) {
            return te.getResistance() >= 31 ? 0 : -1;
        }
        return Math.max(0, base * (100 - neg) / 100);
    }

    public static byte getHumidity(MTEExtremeIndustrialGreenhouse greenhouse, boolean useNoHumidity) {
        if (useNoHumidity) {
            return 0;
        }
        int value = Crops.instance.getHumidityBiomeBonus(greenhouse.getBaseMetaTileEntity().getBiome());
        value += 2;
        value += 2;
        return (byte)(value += 8);
    }

    public static byte getNutrients(MTEExtremeIndustrialGreenhouse greenhouse) {
        int value = Crops.instance.getNutrientBiomeBonus(greenhouse.getBaseMetaTileEntity().getBiome());
        value += 0;
        return (byte)(value += 0);
    }

    public static byte getAirQuality(MTEExtremeIndustrialGreenhouse greenhouse) {
        int value = Math.max(0, Math.min(4, (greenhouse.getBaseMetaTileEntity().getYCoord() - 64) / 15));
        return (byte)(value += 2);
    }

    private static class FakeTileEntityCrop
    extends TileEntityCrop {
        private boolean isValid = false;
        public Set<Block> reqBlockSet = new HashSet<Block>();
        public Set<String> reqBlockOreDict = new HashSet<String>();
        private int lightLevel = 15;

        public FakeTileEntityCrop(EIGIC2Bucket bucket, MTEExtremeIndustrialGreenhouse greenhouse, int[] xyz) {
            this.ticker = '\u0001';
            CropCard cc = Crops.instance.getCropCard(bucket.seed);
            this.setCrop(cc);
            NBTTagCompound nbt = bucket.seed.func_77978_p();
            this.setGrowth(nbt.func_74771_c("growth"));
            this.setGain(nbt.func_74771_c("gain"));
            this.setResistance(nbt.func_74771_c("resistance"));
            this.func_145834_a(greenhouse.getBaseMetaTileEntity().getWorld());
            this.field_145851_c = xyz[0];
            this.field_145848_d = xyz[1];
            this.field_145849_e = xyz[2];
            this.field_145854_h = Block.func_149634_a((Item)Ic2Items.crop.func_77973_b());
            this.field_145847_g = 0;
            this.waterStorage = bucket.useNoHumidity ? 0 : 200;
            this.humidity = EIGIC2Bucket.getHumidity(greenhouse, bucket.useNoHumidity);
            this.nutrientStorage = 0;
            this.nutrients = EIGIC2Bucket.getNutrients(greenhouse);
            this.airQuality = EIGIC2Bucket.getAirQuality(greenhouse);
            this.isValid = true;
        }

        public boolean canMature() {
            CropCard cc = this.getCrop();
            this.size = cc.maxSize() - 1;
            this.lightLevel = 15;
            if (cc.canGrow((ICropTile)this)) {
                return true;
            }
            this.lightLevel = 9;
            return cc.canGrow((ICropTile)this);
        }

        public boolean isBlockBelow(Block reqBlock) {
            this.reqBlockSet.add(reqBlock);
            return super.isBlockBelow(reqBlock);
        }

        public boolean isBlockBelow(String oreDictionaryName) {
            this.reqBlockOreDict.add(oreDictionaryName);
            return super.isBlockBelow(oreDictionaryName);
        }

        public int getLightLevel() {
            return this.lightLevel;
        }

        public byte getHumidity() {
            return this.humidity;
        }

        public byte updateHumidity() {
            return this.humidity;
        }

        public byte getNutrients() {
            return this.nutrients;
        }

        public byte updateNutrients() {
            return this.nutrients;
        }

        public byte getAirQuality() {
            return this.airQuality;
        }

        public byte updateAirQuality() {
            return this.nutrients;
        }

        public void updateNutrientsForBlockUnder() {
            if (this.getCrop().getrootslength((ICropTile)this) - 1 - 0 <= 0 && this.nutrients > 0) {
                this.nutrients = (byte)(this.nutrients - 1);
            }
        }

        public boolean hasRequestedBlockUnder() {
            return !this.reqBlockSet.isEmpty() || !this.reqBlockOreDict.isEmpty();
        }
    }

    public static class Factory
    implements IEIGBucketFactory {
        @Override
        public String getNBTIdentifier() {
            return EIGIC2Bucket.NBT_IDENTIFIER;
        }

        @Override
        public EIGBucket tryCreateBucket(MTEExtremeIndustrialGreenhouse greenhouse, ItemStack input) {
            if (!ItemList.IC2_Crop_Seeds.isStackEqual(input, true, true)) {
                return null;
            }
            if (!input.func_77942_o()) {
                return null;
            }
            NBTTagCompound nbt = input.func_77978_p();
            if (!(nbt.func_74764_b("growth") && nbt.func_74764_b("gain") && nbt.func_74764_b("resistance"))) {
                return null;
            }
            CropCard cc = IC2Crops.instance.getCropCard(input);
            if (cc == null) {
                return null;
            }
            return new EIGIC2Bucket(greenhouse, input);
        }

        @Override
        public EIGBucket restore(NBTTagCompound nbt) {
            return new EIGIC2Bucket(nbt);
        }
    }
}

