/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.redstone;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IRedstoneCircuitBlock;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.objects.GTItemStack;
import gregtech.api.objects.GTRenderedTexture;
import gregtech.api.util.CircuitryBehavior;
import gregtech.api.util.CoverBehavior;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ISerializableObject;
import gtPlusPlus.xmod.gregtech.api.gui.GTPPUITextures;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.tileentities.redstone.MTERedstoneBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class MTERedstoneCircuitBlock
extends MTERedstoneBase
implements IRedstoneCircuitBlock,
IAddUIWidgets {
    public int mGate = 0;
    public int[] mGateData = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    public boolean bOutput = true;
    public static final Map<Integer, ItemStack> sCoversItems = new HashMap<Integer, ItemStack>();

    public MTERedstoneCircuitBlock(int aID) {
        super(aID, "redstone.circuit", "Redstone Circuit Block", 1, 5, "Computes Redstone", new ITexture[0]);
    }

    public MTERedstoneCircuitBlock(String aName, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, 1, 5, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTERedstoneCircuitBlock(this.mName, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean hasSidedRedstoneOutputBehavior() {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isEnetOutput() {
        return true;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return !this.isOutputFacing(side);
    }

    @Override
    public boolean isElectric() {
        return true;
    }

    @Override
    public boolean isPneumatic() {
        return false;
    }

    @Override
    public boolean isSteampowered() {
        return false;
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getOutputFacing();
    }

    @Override
    public long getMinimumStoredEU() {
        return 512L;
    }

    @Override
    public long maxEUInput() {
        return GTValues.V[1];
    }

    @Override
    public long maxEUOutput() {
        return this.bOutput ? GTValues.V[1] : 0L;
    }

    @Override
    public long maxAmperesIn() {
        return 2L;
    }

    @Override
    public long maxAmperesOut() {
        return 1L;
    }

    @Override
    public int func_70302_i_() {
        return 5;
    }

    @Override
    public long maxEUStore() {
        return GTValues.V[3] * 1024L;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GTUIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
        return true;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mGate", this.mGate);
        aNBT.func_74783_a("mGateData", this.mGateData);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mGate = aNBT.func_74762_e("mGate");
        this.mGateData = aNBT.func_74759_k("mGateData");
        if (this.mGateData.length != 8) {
            this.mGateData = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        }
    }

    public void switchGateForward(boolean aShift) {
        try {
            Set<Integer> tKeys = GregTechAPI.sCircuitryBehaviors.keySet();
            ArrayList<Integer> tList = new ArrayList<Integer>();
            tList.addAll(tKeys);
            if (tList.size() <= 0) {
                return;
            }
            Collections.sort(tList);
            if (!GregTechAPI.sCircuitryBehaviors.containsKey(this.mGate)) {
                this.mGate = (Integer)tList.get(0);
            }
            int tIndex = Collections.binarySearch(tList, this.mGate);
            tIndex += aShift ? 16 : 1;
            while (tIndex >= tList.size()) {
                tIndex -= tList.size();
            }
            this.mGate = (Integer)tList.get(tIndex);
            this.switchGate();
        }
        catch (Throwable e) {
            GTLog.err.print(e);
        }
    }

    public void switchGateBackward(boolean aShift) {
        try {
            Set<Integer> tKeys = GregTechAPI.sCircuitryBehaviors.keySet();
            ArrayList<Integer> tList = new ArrayList<Integer>();
            tList.addAll(tKeys);
            if (tList.size() <= 0) {
                return;
            }
            Collections.sort(tList);
            if (!GregTechAPI.sCircuitryBehaviors.containsKey(this.mGate)) {
                this.mGate = (Integer)tList.get(0);
            }
            int tIndex = Collections.binarySearch(tList, this.mGate);
            tIndex -= aShift ? 16 : 1;
            while (tIndex < 0) {
                tIndex += tList.size();
            }
            this.mGate = (Integer)tList.get(tIndex);
            this.switchGate();
        }
        catch (Throwable e) {
            GTLog.err.print(e);
        }
    }

    @Override
    public void onFacingChange() {
        this.resetRedstone();
    }

    private void resetRedstone() {
        this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal(ForgeDirection.DOWN, (byte)0);
        this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal(ForgeDirection.UP, (byte)0);
        this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal(ForgeDirection.NORTH, (byte)0);
        this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal(ForgeDirection.SOUTH, (byte)0);
        this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal(ForgeDirection.WEST, (byte)0);
        this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal(ForgeDirection.EAST, (byte)0);
    }

    public void changeGateData(int aIndex, int aValue) {
        int n = aIndex;
        this.mGateData[n] = this.mGateData[n] + aValue;
        this.validateGateData();
    }

    public void stackGateData(int aIndex, ItemStack aStack) {
        this.mGateData[aIndex] = GTUtility.stackToInt(aStack);
        this.validateGateData();
    }

    private void switchGate() {
        this.resetRedstone();
        Arrays.fill(this.mGateData, 0);
        CircuitryBehavior tBehaviour = GregTechAPI.sCircuitryBehaviors.get(this.mGate);
        if (tBehaviour != null) {
            try {
                tBehaviour.initParameters(this.mGateData, this);
            }
            catch (Throwable e) {
                GTLog.err.print(e);
            }
        }
        this.validateGateData();
    }

    private void validateGateData() {
        CircuitryBehavior tBehaviour = GregTechAPI.sCircuitryBehaviors.get(this.mGate);
        if (tBehaviour != null) {
            try {
                tBehaviour.validateParameters(this.mGateData, this);
            }
            catch (Throwable e) {
                GTLog.err.print(e);
            }
        }
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.getBaseMetaTileEntity().setGenericRedstoneOutput(true);
        this.validateGateData();
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        this.getBaseMetaTileEntity().setGenericRedstoneOutput(true);
        if (this.getBaseMetaTileEntity().isAllowedToWork() && this.getBaseMetaTileEntity().isServerSide()) {
            this.mInventory[4] = null;
            this.mInventory[3] = null;
            this.mInventory[2] = null;
            this.mInventory[1] = null;
            this.mInventory[0] = null;
            if (this.getBaseMetaTileEntity().getUniversalEnergyStored() >= this.getMinimumStoredEU()) {
                CircuitryBehavior tBehaviour;
                if (this.getBaseMetaTileEntity().isActive() && (tBehaviour = GregTechAPI.sCircuitryBehaviors.get(this.mGate)) != null) {
                    try {
                        tBehaviour.onTick(this.mGateData, this);
                        if (tBehaviour.displayItemStack(this.mGateData, this, 0)) {
                            this.mInventory[1] = MTERedstoneCircuitBlock.getCoverByID(this.mGateData[0]);
                        }
                        if (tBehaviour.displayItemStack(this.mGateData, this, 1)) {
                            this.mInventory[2] = MTERedstoneCircuitBlock.getCoverByID(this.mGateData[1]);
                        }
                        if (tBehaviour.displayItemStack(this.mGateData, this, 2)) {
                            this.mInventory[3] = MTERedstoneCircuitBlock.getCoverByID(this.mGateData[2]);
                        }
                        if (tBehaviour.displayItemStack(this.mGateData, this, 3)) {
                            this.mInventory[4] = MTERedstoneCircuitBlock.getCoverByID(this.mGateData[3]);
                        }
                    }
                    catch (Throwable e) {
                        GTLog.err.print(e);
                    }
                }
                this.getBaseMetaTileEntity().setErrorDisplayID(0);
            } else {
                this.getBaseMetaTileEntity().setErrorDisplayID(1);
            }
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (!this.getBaseMetaTileEntity().isServerSide()) {
            return;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            byte aRedstone = this.getBaseMetaTileEntity().getOutputRedstoneSignal(side);
            this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal(side, aRedstone);
        }
    }

    @Override
    public final boolean hasRedstoneSignal() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (this.getBaseMetaTileEntity().getOutputRedstoneSignal(side) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allowGeneralRedstoneOutput() {
        return true;
    }

    private static void initCovers() {
        for (GTItemStack aKey : GregTechAPI.sCovers.keySet()) {
            ItemStack aStack = aKey.toStack().func_77946_l();
            if (aStack == null) continue;
            sCoversItems.put(GTUtility.stackToInt(aStack), aStack);
        }
    }

    public static ItemStack getCoverByID(int aStack) {
        if (sCoversItems.isEmpty()) {
            MTERedstoneCircuitBlock.initCovers();
        }
        return sCoversItems.get(aStack);
    }

    @Override
    public ForgeDirection getOutputFacing() {
        return this.getBaseMetaTileEntity().getBackFacing();
    }

    @Override
    public boolean setRedstone(byte aStrength, ForgeDirection side) {
        if (this.getOutputRedstone(side) != aStrength) {
            if (this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(1L, false)) {
                this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal(side, aStrength);
                this.getBaseMetaTileEntity().setErrorDisplayID(0);
                return true;
            }
            this.getBaseMetaTileEntity().setErrorDisplayID(1);
            return false;
        }
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public byte getOutputRedstone(ForgeDirection side) {
        return this.getBaseMetaTileEntity().getOutputRedstoneSignal(side);
    }

    @Override
    public byte getInputRedstone(ForgeDirection side) {
        return this.getBaseMetaTileEntity().getInternalInputRedstoneSignal(side);
    }

    @Override
    public Block getBlockAtSide(ForgeDirection side) {
        return this.getBaseMetaTileEntity().getBlockAtSide(side);
    }

    @Override
    public byte getMetaIDAtSide(ForgeDirection side) {
        return this.getBaseMetaTileEntity().getMetaIDAtSide(side);
    }

    @Override
    public TileEntity getTileEntityAtSide(ForgeDirection side) {
        return this.getBaseMetaTileEntity().getTileEntityAtSide(side);
    }

    @Override
    public int getRandom(int aRange) {
        return this.getBaseMetaTileEntity().getRandomNumber(aRange);
    }

    @Override
    public CoverBehavior getCover(ForgeDirection side) {
        return (CoverBehavior)this.getBaseMetaTileEntity().getCoverBehaviorAtSideNew(side);
    }

    @Override
    public int getCoverID(ForgeDirection side) {
        return this.getBaseMetaTileEntity().getCoverIDAtSide(side);
    }

    @Override
    public int getCoverVariable(ForgeDirection side) {
        return ((ISerializableObject.LegacyCoverData)this.getBaseMetaTileEntity().getComplexCoverDataAtSide(side)).get();
    }

    @Override
    public ICoverable getOwnTileEntity() {
        return this.getBaseMetaTileEntity();
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getSides(i);
            rTextures[1][i + 1] = this.getBack(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getSidesActive(i);
            rTextures[6][i + 1] = this.getBackActive(i);
            rTextures[7][i + 1] = this.getBottomActive(i);
            rTextures[8][i + 1] = this.getTopActive(i);
            rTextures[9][i + 1] = this.getSidesActive(i);
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[(aActive || this.hasRedstoneSignal() ? 5 : 0) + (side == facing ? 0 : (side == facing.getOpposite() ? 1 : (side == ForgeDirection.DOWN ? 2 : (side == ForgeDirection.UP ? 3 : 4))))][aColorIndex + 1];
    }

    private GTRenderedTexture getBase() {
        return new GTRenderedTexture(TexturesGtBlock.Casing_Machine_Simple_Top);
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{this.getBase(), new GTRenderedTexture(TexturesGtBlock.Casing_Redstone_Top_Off)};
    }

    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{this.getBase(), new GTRenderedTexture(TexturesGtBlock.Casing_Redstone_Top_On)};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{this.getBase(), new GTRenderedTexture(TexturesGtBlock.Casing_Redstone_Side_Off), new GTRenderedTexture(TexturesGtBlock.Casing_InventoryManagaer_Red)};
    }

    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{this.getBase(), new GTRenderedTexture(TexturesGtBlock.Casing_Redstone_Side_On), new GTRenderedTexture(TexturesGtBlock.Casing_InventoryManagaer_Red_Redstone)};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{this.getBase(), new GTRenderedTexture(TexturesGtBlock.Casing_Redstone_Bottom_Off)};
    }

    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{this.getBase(), new GTRenderedTexture(TexturesGtBlock.Casing_Redstone_Bottom_On)};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{this.getBase(), new GTRenderedTexture(TexturesGtBlock.Casing_Redstone_Side_Off)};
    }

    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{this.getBase(), new GTRenderedTexture(TexturesGtBlock.Casing_Redstone_Side_On)};
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        int index;
        int i;
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GTPPUITextures.PICTURE_REDSTONE_CIRCUIT_SCREEN).setPos(43, 5).setSize(108, 72));
        for (i = 0; i < 4; ++i) {
            index = i;
            ((ModularWindow.Builder)builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
                ItemStack tStack = widget.getContext().getPlayer().field_71071_by.func_70445_o();
                if (tStack == null) {
                    this.changeGateData(index, clickData.mouseButton == 0 ? (clickData.shift ? 128 : 1) : (clickData.shift ? -128 : -1));
                } else {
                    tStack = GTUtility.copy(tStack);
                    if (clickData.mouseButton != 0) {
                        tStack.func_77964_b(Short.MAX_VALUE);
                    }
                    this.stackGateData(index, tStack);
                }
            }).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD, GTPPUITextures.OVERLAY_BUTTON_PLUS_MINUS}).setPos(7, 5 + i * 18).setSize(18, 18))).widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)(i + 1)).disableInteraction().setPos(25, 5 + i * 18));
        }
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new CycleButtonWidget().setToggle(() -> this.bOutput, val -> {
            this.bOutput = val;
        }).setVariableBackground(new UITexture[]{GTUITextures.BUTTON_STANDARD_TOGGLE}).setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_EMIT_ENERGY).addTooltip("Toggle EU Output").setPos(151, 5).setSize(18, 18))).widget(new CycleButtonWidget().setToggle(() -> this.getBaseMetaTileEntity().isActive(), val -> this.getBaseMetaTileEntity().setActive((boolean)val)).setVariableBackground(new UITexture[]{GTUITextures.BUTTON_STANDARD_TOGGLE}).setStaticTexture((IDrawable)GTPPUITextures.OVERLAY_BUTTON_ACTIVE_STATE).addTooltip("Toggle Active State").setPos(151, 23).setSize(18, 18))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (clickData.mouseButton == 0) {
                this.switchGateForward(clickData.shift);
            } else {
                this.switchGateBackward(clickData.shift);
            }
        }).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD, GTPPUITextures.OVERLAY_BUTTON_CHANGE_MODE}).addTooltip("Change Redstone Circuit").setPos(151, 41).setSize(18, 18));
        builder.widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.mGate, val -> {
            this.mGate = val;
        }));
        i = 0;
        while (i < this.mGateData.length) {
            index = i++;
            builder.widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.mGateData[index], val -> {
                this.mGateData[index] = val;
            }));
        }
        ((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable(() -> {
            if (this.getBaseMetaTileEntity().getErrorDisplayID() > 0) {
                if (this.getBaseMetaTileEntity().getTimer() / 5L % 2L == 0L) {
                    return GTPPUITextures.PICTURE_ELECTRICITY_ERROR;
                }
                return null;
            }
            return GTPPUITextures.PICTURE_ELECTRICITY_FINE;
        }).setPos(140, 9).setSize(7, 7))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.getBaseMetaTileEntity().getErrorDisplayID(), val -> this.getBaseMetaTileEntity().setErrorDisplayID((int)val)));
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(TextWidget.dynamicString(() -> {
            CircuitryBehavior tCircuit = GregTechAPI.sCircuitryBehaviors.get(this.mGate);
            if (tCircuit != null) {
                return tCircuit.getName();
            }
            return "";
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 8))).widget(TextWidget.dynamicString(() -> {
            CircuitryBehavior tCircuit = GregTechAPI.sCircuitryBehaviors.get(this.mGate);
            if (tCircuit != null) {
                return tCircuit.getDescription();
            }
            return "";
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 19))).widget(TextWidget.dynamicString(() -> {
            CircuitryBehavior tCircuit = GregTechAPI.sCircuitryBehaviors.get(this.mGate);
            if (tCircuit != null) {
                return tCircuit.getDataDescription(this.mGateData, 0);
            }
            return "";
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 33))).widget(TextWidget.dynamicString(() -> {
            CircuitryBehavior tCircuit = GregTechAPI.sCircuitryBehaviors.get(this.mGate);
            if (tCircuit != null) {
                return tCircuit.getDataDescription(this.mGateData, 1);
            }
            return "";
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 44))).widget(TextWidget.dynamicString(() -> {
            CircuitryBehavior tCircuit = GregTechAPI.sCircuitryBehaviors.get(this.mGate);
            if (tCircuit != null) {
                return tCircuit.getDataDescription(this.mGateData, 2);
            }
            return "";
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 55))).widget(TextWidget.dynamicString(() -> {
            CircuitryBehavior tCircuit = GregTechAPI.sCircuitryBehaviors.get(this.mGate);
            if (tCircuit != null) {
                return tCircuit.getDataDescription(this.mGateData, 3);
            }
            return "";
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 66))).widget(TextWidget.dynamicString(() -> {
            CircuitryBehavior tCircuit = GregTechAPI.sCircuitryBehaviors.get(this.mGate);
            if (tCircuit != null) {
                String tString = tCircuit.getDataDisplay(this.mGateData, 0);
                return tString == null ? GTUtility.parseNumberToString(this.mGateData[0]) : tString;
            }
            return "";
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(99, 33))).widget(TextWidget.dynamicString(() -> {
            CircuitryBehavior tCircuit = GregTechAPI.sCircuitryBehaviors.get(this.mGate);
            if (tCircuit != null) {
                String tString = tCircuit.getDataDisplay(this.mGateData, 1);
                return tString == null ? GTUtility.parseNumberToString(this.mGateData[1]) : tString;
            }
            return "";
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(99, 44))).widget(TextWidget.dynamicString(() -> {
            CircuitryBehavior tCircuit = GregTechAPI.sCircuitryBehaviors.get(this.mGate);
            if (tCircuit != null) {
                String tString = tCircuit.getDataDisplay(this.mGateData, 2);
                return tString == null ? GTUtility.parseNumberToString(this.mGateData[2]) : tString;
            }
            return "";
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(99, 55))).widget(TextWidget.dynamicString(() -> {
            CircuitryBehavior tCircuit = GregTechAPI.sCircuitryBehaviors.get(this.mGate);
            if (tCircuit != null) {
                String tString = tCircuit.getDataDisplay(this.mGateData, 3);
                return tString == null ? GTUtility.parseNumberToString(this.mGateData[3]) : tString;
            }
            return "";
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(99, 66));
    }
}

