/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.basic;

import gregtech.GTMod;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GTRenderedTexture;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.core.util.minecraft.gregtech.PollutionUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMetaTileEntity;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEPollutionCreator
extends GTPPMetaTileEntity {
    int mCurrentPollution;
    int mAveragePollution;
    int[] mAveragePollutionArray = new int[10];
    private int mArrayPos = 0;
    private int mTickTimer = 0;
    private int mSecondTimer = 0;
    public int pollutionMultiplier = 1;

    public MTEPollutionCreator(int aID, String aName, String aNameRegional, int aTier, String aDescription, int aSlotCount) {
        super(aID, aName, aNameRegional, aTier, aSlotCount, aDescription, new ITexture[0]);
    }

    public MTEPollutionCreator(String aName, int aTier, String aDescription, ITexture[][][] aTextures, int aSlotCount) {
        super(aName, aTier, aSlotCount, aDescription, aTextures);
    }

    @Override
    public String[] getDescription() {
        return new String[]{this.mDescription, "A useful debug machine to create pollution.", GTPPCore.GT_Tooltip.get()};
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getBack(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFrontActive(i);
            rTextures[6][i + 1] = this.getBackActive(i);
            rTextures[7][i + 1] = this.getBottomActive(i);
            rTextures[8][i + 1] = this.getTopActive(i);
            rTextures[9][i + 1] = this.getSidesActive(i);
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[(aActive ? 5 : 0) + (side == facing ? 0 : (side == facing.getOpposite() ? 1 : (side == ForgeDirection.DOWN ? 2 : (side == ForgeDirection.UP ? 3 : 4))))][aColorIndex + 1];
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier + 3][aColor + 1], new GTRenderedTexture(TexturesGtBlock.Casing_Machine_Screen_2)};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier + 3][aColor + 1], new GTRenderedTexture(TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier + 3][aColor + 1], new GTRenderedTexture(TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier + 3][aColor + 1], new GTRenderedTexture(TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier + 3][aColor + 1], new GTRenderedTexture(TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public ITexture[] getFrontActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier + 3][aColor + 1], new GTRenderedTexture(TexturesGtBlock.Casing_Machine_Screen_2)};
    }

    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier + 3][aColor + 1], new GTRenderedTexture(TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier + 3][aColor + 1], new GTRenderedTexture(TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier + 3][aColor + 1], new GTRenderedTexture(TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier + 3][aColor + 1], new GTRenderedTexture(TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.pollutionMultiplier = this.pollutionMultiplier > 99 ? 1 : ++this.pollutionMultiplier;
        PlayerUtils.messagePlayer(aPlayer, "Pollution Mutliplier is now " + this.pollutionMultiplier + ".");
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEPollutionCreator(this.mName, (int)this.mTier, this.mDescription, this.mTextures, this.mInventory.length);
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public boolean isElectric() {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isEnetOutput() {
        return false;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return 0L;
    }

    @Override
    public long maxEUStore() {
        return 0L;
    }

    @Override
    public int getCapacity() {
        return 0;
    }

    @Override
    public long maxEUInput() {
        return 0L;
    }

    @Override
    public long maxEUOutput() {
        return 0L;
    }

    @Override
    public long maxAmperesIn() {
        return 0L;
    }

    @Override
    public long maxAmperesOut() {
        return 0L;
    }

    @Override
    public int rechargerSlotStartIndex() {
        return 0;
    }

    @Override
    public int dechargerSlotStartIndex() {
        return 0;
    }

    @Override
    public int rechargerSlotCount() {
        return 0;
    }

    @Override
    public int dechargerSlotCount() {
        return 0;
    }

    @Override
    public int getProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyStored();
    }

    @Override
    public int maxProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyCapacity();
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        this.showPollution(aPlayer.func_130014_f_(), aPlayer);
        return true;
    }

    private void showPollution(World worldIn, EntityPlayer playerIn) {
        if (!GTMod.gregtechproxy.mPollution) {
            PlayerUtils.messagePlayer(playerIn, "This block is useless, Pollution is disabled.");
        } else {
            this.addPollution();
            PlayerUtils.messagePlayer(playerIn, "This chunk now contains " + this.getCurrentChunkPollution() + " pollution.");
        }
    }

    private boolean addPollution() {
        PollutionUtils.addPollution(this.getBaseMetaTileEntity(), 100000 * this.pollutionMultiplier);
        return true;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    public int getCurrentChunkPollution() {
        return this.getCurrentChunkPollution(this.getBaseMetaTileEntity());
    }

    public int getCurrentChunkPollution(IGregTechTileEntity aBaseMetaTileEntity) {
        return PollutionUtils.getPollution(aBaseMetaTileEntity);
    }

    @Override
    public String[] getInfoData() {
        return new String[]{this.getLocalName(), "Current Pollution: " + this.mCurrentPollution, "Average/10 minutes:" + this.getAveragePollutionOverLastTen()};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return new int[0];
    }

    @Override
    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return false;
    }

    @Override
    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return false;
    }

    @Override
    public int func_70302_i_() {
        return 0;
    }

    @Override
    public ItemStack func_70301_a(int p_70301_1_) {
        return null;
    }

    @Override
    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return null;
    }

    @Override
    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    @Override
    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
    }

    @Override
    public String func_145825_b() {
        return null;
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public int func_70297_j_() {
        return 0;
    }

    @Override
    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return false;
    }

    @Override
    public void func_70295_k_() {
    }

    @Override
    public void func_70305_f() {
    }

    @Override
    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return false;
    }

    @Override
    public boolean isOverclockerUpgradable() {
        return false;
    }

    @Override
    public boolean isTransformerUpgradable() {
        return false;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mCurrentPollution", this.mCurrentPollution);
        aNBT.func_74768_a("mAveragePollution", this.mAveragePollution);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mCurrentPollution = aNBT.func_74762_e("mCurrentPollution");
        this.mAveragePollution = aNBT.func_74762_e("mAveragePollution");
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (this.mCurrentPollution == 0) {
                this.mCurrentPollution = this.getCurrentChunkPollution();
            }
            if (this.mArrayPos < 0 || this.mArrayPos > 9) {
                this.mArrayPos = 0;
            }
            this.mTickTimer = 0;
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().isServerSide()) {
            ++this.mTickTimer;
            if (this.mTickTimer % 20 == 0) {
                this.mCurrentPollution = this.getCurrentChunkPollution();
            }
        }
    }

    public int getAveragePollutionOverLastTen() {
        int counter = 0;
        int total = 0;
        for (int j : this.mAveragePollutionArray) {
            if (j == 0) continue;
            total += j;
            ++counter;
        }
        int returnValue = 0;
        if (total > 0 && counter > 0) {
            this.mAveragePollution = returnValue = total / counter;
        } else {
            returnValue = this.getCurrentChunkPollution();
        }
        return returnValue;
    }
}

