/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.forestry.bees.custom;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IAlleleBeeSpeciesCustom;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeMutationCustom;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.apiculture.genetics.BeeVariation;
import forestry.apiculture.genetics.IBeeDefinition;
import forestry.core.genetics.alleles.AlleleHelper;
import gregtech.loaders.misc.GTBeeDefinition;
import gregtech.loaders.misc.GTBranchDefinition;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.forestry.bees.custom.CustomCombs;
import gtPlusPlus.xmod.forestry.bees.custom.GTPPBees;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.text.WordUtils;

public enum GTPPBeeDefinition implements IBeeDefinition
{
    SILICON(GTBranchDefinition.ORGANIC, "Silicon", true, Utils.rgbtoHexValue(75, 75, 75), Utils.rgbtoHexValue(125, 125, 125)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GTPPBeeDefinition.getSlagComb(), Float.valueOf(0.1f));
            beeSpecies.addProduct(GTPPBees.combs.getStackForType(CustomCombs.SILICON), Float.valueOf(0.2f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)GTBeeDefinition.SLIMEBALL.getSpecies(), (IAlleleBeeSpecies)GTBeeDefinition.STICKYRESIN.getSpecies(), 10);
        }
    }
    ,
    RUBBER(GTBranchDefinition.ORGANIC, "Rubber", true, Utils.rgbtoHexValue(55, 55, 55), Utils.rgbtoHexValue(75, 75, 75)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GTPPBeeDefinition.getSlagComb(), Float.valueOf(0.1f));
            beeSpecies.addProduct(GTPPBees.combs.getStackForType(CustomCombs.RUBBER), Float.valueOf(0.3f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)GTBeeDefinition.SLIMEBALL.getSpecies(), (IAlleleBeeSpecies)GTBeeDefinition.STICKYRESIN.getSpecies(), 10);
        }
    }
    ,
    PLASTIC(GTBranchDefinition.ORGANIC, "Plastic", true, Utils.rgbtoHexValue(245, 245, 245), Utils.rgbtoHexValue(175, 175, 175)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GTPPBeeDefinition.getStoneComb(), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTPPBees.combs.getStackForType(CustomCombs.PLASTIC), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)RUBBER.species, (IAlleleBeeSpecies)GTBeeDefinition.OIL.getSpecies(), 10);
        }
    }
    ,
    PTFE(GTBranchDefinition.ORGANIC, "Ptfe", true, Utils.rgbtoHexValue(150, 150, 150), Utils.rgbtoHexValue(75, 75, 75)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GTPPBeeDefinition.getStoneComb(), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTPPBees.combs.getStackForType(CustomCombs.PTFE), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)RUBBER.species, (IAlleleBeeSpecies)PLASTIC.species, 10);
        }
    }
    ,
    PBS(GTBranchDefinition.ORGANIC, "Pbs", true, Utils.rgbtoHexValue(33, 26, 24), Utils.rgbtoHexValue(23, 16, 14)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GTPPBeeDefinition.getStoneComb(), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTPPBees.combs.getStackForType(CustomCombs.PBS), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)PTFE.species, (IAlleleBeeSpecies)PLASTIC.species, 10);
        }
    }
    ,
    BIOMASS(GTBranchDefinition.ORGANIC, "Biomass", true, Utils.rgbtoHexValue(33, 225, 24), Utils.rgbtoHexValue(23, 175, 14)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GTPPBees.combs.getStackForType(CustomCombs.SAND), Float.valueOf(0.4f));
            beeSpecies.addProduct(GTPPBees.combs.getStackForType(CustomCombs.BIOMASS), Float.valueOf(0.2f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(GTPPBeeDefinition.getSpecies("Industrious"), GTPPBeeDefinition.getSpecies("Rural"), 10);
            tMutation.restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        }
    }
    ,
    ETHANOL(GTBranchDefinition.ORGANIC, "Ethanol", true, Utils.rgbtoHexValue(255, 128, 0), Utils.rgbtoHexValue(220, 156, 32)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GTPPBees.combs.getStackForType(CustomCombs.SAND), Float.valueOf(0.4f));
            beeSpecies.addProduct(GTPPBees.combs.getStackForType(CustomCombs.ETHANOL), Float.valueOf(0.2f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)BIOMASS.species, GTPPBeeDefinition.getSpecies("Farmerly"), 5);
            tMutation.restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        }
    }
    ,
    FLUORINE(GTBranchDefinition.ORGANIC, "Fluorine", true, Utils.rgbtoHexValue(30, 230, 230), Utils.rgbtoHexValue(10, 150, 150)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GTPPBeeDefinition.getStoneComb(), Float.valueOf(0.4f));
            beeSpecies.addProduct(GTPPBees.combs.getStackForType(CustomCombs.FLUORINE), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.COLD);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)GTBeeDefinition.LAPIS.getSpecies(), (IAlleleBeeSpecies)GTBeeDefinition.SAPPHIRE.getSpecies(), 5);
            tMutation.restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.COLD});
        }
    }
    ,
    FORCE(GTBranchDefinition.METAL, "Force", true, Utils.rgbtoHexValue(250, 250, 20), Utils.rgbtoHexValue(200, 200, 5)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GTPPBeeDefinition.getStoneComb(), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTPPBees.combs.getStackForType(CustomCombs.SAND), Float.valueOf(0.25f));
            beeSpecies.addProduct(GTPPBees.combs.getStackForType(CustomCombs.FORCE), Float.valueOf(0.25f));
            beeSpecies.addProduct(GTPPBees.combs.getStackForType(CustomCombs.SALT), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)GTBeeDefinition.STEEL.getSpecies(), (IAlleleBeeSpecies)GTBeeDefinition.GOLD.getSpecies(), 10);
            tMutation.restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT});
        }
    }
    ,
    NIKOLITE(GTBranchDefinition.METAL, "Nikolite", true, Utils.rgbtoHexValue(60, 180, 200), Utils.rgbtoHexValue(40, 150, 170)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GTPPBeeDefinition.getStoneComb(), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTPPBees.combs.getStackForType(CustomCombs.NIKOLITE), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)GTBeeDefinition.ALUMINIUM.getSpecies(), (IAlleleBeeSpecies)GTBeeDefinition.SILVER.getSpecies(), 8);
            tMutation.restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT});
        }
    };

    private final GTBranchDefinition branch;
    private final IAlleleBeeSpeciesCustom species;
    private IAllele[] template;
    private IBeeGenome genome;

    private GTPPBeeDefinition(GTBranchDefinition branch, String binomial, boolean dominant, int primary, int secondary) {
        String lowercaseName = this.toString().toLowerCase(Locale.ENGLISH);
        String species = "species" + WordUtils.capitalize((String)lowercaseName);
        String uid = "forestry." + species;
        String description = "for.description." + species;
        String name = "for.bees.species." + lowercaseName;
        this.branch = branch;
        this.species = BeeManager.beeFactory.createSpecies(uid, dominant, "Sengir", name, description, branch.getBranch(), binomial, primary, secondary);
    }

    public static void initBees() {
        for (GTPPBeeDefinition bee : GTPPBeeDefinition.values()) {
            bee.init();
        }
        for (GTPPBeeDefinition bee : GTPPBeeDefinition.values()) {
            bee.registerMutations();
        }
    }

    private static IAlleleBeeSpecies getSpecies(String name) {
        return (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.species" + name);
    }

    protected abstract void setSpeciesProperties(IAlleleBeeSpeciesCustom var1);

    protected abstract void setAlleles(IAllele[] var1);

    protected abstract void registerMutations();

    private void init() {
        this.setSpeciesProperties(this.species);
        this.template = this.branch.getTemplate();
        AlleleHelper.instance.set(this.template, (Enum)EnumBeeChromosome.SPECIES, (IAllele)this.species);
        this.setAlleles(this.template);
        this.genome = BeeManager.beeRoot.templateAsGenome(this.template);
        BeeManager.beeRoot.registerTemplate(this.template);
    }

    protected final IBeeMutationCustom registerMutation(IAlleleBeeSpecies parent1, IAlleleBeeSpecies parent2, int chance) {
        IAllele[] template = this.getTemplate();
        Logger.DEBUG_BEES("parent1: " + (parent1 != null));
        Logger.DEBUG_BEES("parent2: " + (parent2 != null));
        Logger.DEBUG_BEES("chance: " + chance);
        Logger.DEBUG_BEES("template: " + (template != null));
        return BeeManager.beeMutationFactory.createMutation(parent1, parent2, template, chance);
    }

    public final IAllele[] getTemplate() {
        return Arrays.copyOf(this.template, this.template.length);
    }

    public final IBeeGenome getGenome() {
        return this.genome;
    }

    public final IBee getIndividual() {
        return new Bee(this.genome);
    }

    public final ItemStack getMemberStack(EnumBeeType beeType) {
        IBee bee = this.getIndividual();
        return BeeManager.beeRoot.getMemberStack((IIndividual)bee, beeType.ordinal());
    }

    public final IBeeDefinition getRainResist() {
        return new BeeVariation.RainResist((IBeeDefinition)this);
    }

    private static ItemStack getSlagComb() {
        return GTPPBeeDefinition.issStackValid(ItemUtils.getSimpleStack(GTPPBees.Comb_Slag, 1));
    }

    private static ItemStack getStoneComb() {
        return GTPPBeeDefinition.issStackValid(ItemUtils.getSimpleStack(GTPPBees.Comb_Stone, 1));
    }

    private static ItemStack issStackValid(ItemStack result) {
        if (result == null) {
            return ItemUtils.getErrorStack(1);
        }
        return result;
    }
}

