/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.init;

import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.item.food.BaseItemMetaFood;
import gtPlusPlus.core.util.minecraft.EntityUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemsFoods {
    public static void load() {
        ItemsFoods.run();
    }

    private static void run() {
        ModItems.itemMetaFood = new BaseItemMetaFood();
        BaseItemMetaFood.registerMetaFoods();
        BaseItemMetaFood.registerFoodsToOreDict();
        ItemsFoods.addCookingRecipes();
        ItemsFoods.addFoodDropsToMobs();
    }

    private static ItemStack getMetaFoodStack(int aID) {
        return ItemUtils.simpleMetaStack((Item)ModItems.itemMetaFood, aID, 1);
    }

    private static void addCookingRecipes() {
        RecipeUtils.addSmeltingRecipe(ItemsFoods.getMetaFoodStack(0), ItemsFoods.getMetaFoodStack(1), 0.4f);
        RecipeUtils.addSmeltingRecipe(ItemsFoods.getMetaFoodStack(2), ItemsFoods.getMetaFoodStack(3), 0.35f);
        RecipeUtils.addSmeltingRecipe(ItemsFoods.getMetaFoodStack(4), ItemsFoods.getMetaFoodStack(5), 0.35f);
        RecipeUtils.addSmeltingRecipe(ItemsFoods.getMetaFoodStack(6), ItemsFoods.getMetaFoodStack(7), 0.35f);
    }

    private static void addFoodDropsToMobs() {
        EntityUtils.registerDropsForMob(EntityVillager.class, ItemsFoods.getMetaFoodStack(0), 2, 1500);
        EntityUtils.registerDropsForMob(EntityHorse.class, ItemsFoods.getMetaFoodStack(2), 4, 4000);
        EntityUtils.registerDropsForMob(EntityWolf.class, ItemsFoods.getMetaFoodStack(4), 2, 4000);
        EntityUtils.registerDropsForMob(EntityOcelot.class, ItemsFoods.getMetaFoodStack(6), 2, 4000);
        EntityUtils.registerDropsForMob(EntityBlaze.class, ItemsFoods.getMetaFoodStack(8), 1, 500);
    }
}

