/*
 * Decompiled with CFR 0.152.
 */
package gregtech.nei.dumper;

import codechicken.nei.config.DataDumper;
import gregtech.api.GregTechAPI;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.modularui.IControllerWithOptionalFeatures;
import java.util.ArrayList;
import java.util.function.Function;

public abstract class MultiBlockFeatureSupportDumper
extends DataDumper {
    private final Function<IControllerWithOptionalFeatures, Boolean> isFeatureSupported;

    public MultiBlockFeatureSupportDumper(String name, Function<IControllerWithOptionalFeatures, Boolean> isFeatureSupported) {
        super("tools.dump.gt5u." + name);
        this.isFeatureSupported = isFeatureSupported;
    }

    public String[] header() {
        return new String[]{"className"};
    }

    public Iterable<String[]> dump(int mode) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (int i = 1; i < GregTechAPI.METATILEENTITIES.length; ++i) {
            IControllerWithOptionalFeatures controller;
            IMetaTileEntity mte = GregTechAPI.METATILEENTITIES[i];
            if (!(mte instanceof IControllerWithOptionalFeatures) || this.isFeatureSupported.apply(controller = (IControllerWithOptionalFeatures)((Object)mte)).booleanValue()) continue;
            list.add(new String[]{controller.getClass().getName()});
        }
        return list;
    }

    public int modeCount() {
        return 1;
    }
}

