/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.multitileentity.multiblock.casing.Glasses;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.blocks.BlockCasings10;
import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;

public class MTEMultiAutoclave
extends MTEExtendedPowerMultiBlockBase<MTEMultiAutoclave>
implements ISurvivalConstructable {
    private HeatingCoilLevel heatLevel;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    protected int itemPipeTier = 0;
    protected int fluidPipeTier = 0;
    private static final IStructureDefinition<MTEMultiAutoclave> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"  AAA  ", "  AFA  ", "  AFA  ", "  AFA  ", "  AFA  ", "  AFA  ", "  AFA  ", "  AFA  ", "  AAA  "}, {" ABBBA ", " A   A ", " A   A ", " A   A ", " A   A ", " A   A ", " A   A ", " A   A ", " ABBBA "}, {"ABBBBBA", "A C C A", "A C C A", "A C C A", "A C C A", "A C C A", "A C C A", "A C C A", "ABBBBBA"}, {"ABBBBBA", "ACDEDCA", "ACDEDCA", "ACDEDCA", "ACDEDCA", "ACDEDCA", "ACDEDCA", "ACDEDCA", "ABBBBBA"}, {"ABBBBBA", "A C C A", "A C C A", "A C C A", "A C C A", "A C C A", "A C C A", "A C C A", "ABBBBBA"}, {"AABBBAA", " A   A ", " A   A ", " A   A ", " A   A ", " A   A ", " A   A ", " A   A ", "AABBBAA"}, {"A A~A A", "  AAA  ", "  AAA  ", "  AAA  ", "  AAA  ", "  AAA  ", "  AAA  ", "  AAA  ", "A AAA A"}})).addElement('A', GTStructureUtility.buildHatchAdder(MTEMultiAutoclave.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.Maintenance, HatchElement.Muffler, HatchElement.Energy).casingIndex(((BlockCasings10)GregTechAPI.sBlockCasings10).getTextureIndex(3)).dot(1).buildAndChain(StructureUtility.onElementPass(MTEMultiAutoclave::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)3)))).addElement('B', Glasses.chainAllGlasses()).addElement('C', GTStructureUtility.ofFrame(Materials.Polytetrafluoroethylene)).addElement('D', StructureUtility.ofBlocksTiered(MTEMultiAutoclave::getFluidTierFromMeta, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)12), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)13), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)14), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)15)), (Object)-2, MTEMultiAutoclave::setFluidPipeTier, MTEMultiAutoclave::getFluidPipeTier)).addElement('E', StructureUtility.ofBlocksTiered(MTEMultiAutoclave::getItemPipeTierFromMeta, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)0), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)1), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)2), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)3), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)4), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)5), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)6), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)7)), (Object)-2, MTEMultiAutoclave::setItemPipeTier, MTEMultiAutoclave::getItemPipeTier)).addElement('F', StructureUtility.withChannel((String)"coil", GTStructureUtility.ofCoil(MTEMultiAutoclave::setCoilLevel, MTEMultiAutoclave::getCoilLevel))).build();
    private static final String TOOLTIP_BAR = EnumChatFormatting.GOLD + "---------------------------------------------------------------------------------------";
    private int mCasingAmount;
    private static final DecimalFormat dfTwo = new DecimalFormat("0.00");
    private static final DecimalFormat dfNone = new DecimalFormat("#");

    public MTEMultiAutoclave(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEMultiAutoclave(String aName) {
        super(aName);
    }

    private static Integer getItemPipeTierFromMeta(Block block, Integer metaID) {
        if (block != GregTechAPI.sBlockCasings11) {
            return -1;
        }
        if (metaID < 0 || metaID > 7) {
            return -1;
        }
        return metaID + 1;
    }

    private void setItemPipeTier(int tier) {
        this.itemPipeTier = tier;
    }

    private int getItemPipeTier() {
        return this.itemPipeTier;
    }

    private static Integer getFluidTierFromMeta(Block block, Integer metaID) {
        if (block != GregTechAPI.sBlockCasings2) {
            return -1;
        }
        if (metaID < 12 || metaID > 15) {
            return -1;
        }
        return metaID - 11;
    }

    private void setFluidPipeTier(int tier) {
        this.fluidPipeTier = tier;
    }

    private int getFluidPipeTier() {
        return this.fluidPipeTier;
    }

    public HeatingCoilLevel getCoilLevel() {
        return this.heatLevel;
    }

    public void setCoilLevel(HeatingCoilLevel aCoilLevel) {
        this.heatLevel = aCoilLevel;
    }

    public Integer getCoilTier() {
        return this.getCoilLevel().getTier() + 1;
    }

    @Override
    public IStructureDefinition<MTEMultiAutoclave> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Autoclave").addInfo(TOOLTIP_BAR).addInfo("Controller Block for the Industrial Autoclave.").addInfo(TOOLTIP_BAR).addInfo("Processes 12 items per Item Pipe Casing Tier.").addInfo("Energy consumption is reduced with higher fluid pipe tiers.").addInfo(EnumChatFormatting.BLUE + "Energy consumption = Recipe Consumption * (12 - Pipe Casing Tier) / 12.").addInfo("Each coil level makes the machine 25% faster than singleblock machines of the same voltage.").addInfo(GTValues.AuthorVolence).addSeparator().beginStructureBlock(7, 7, 9, true).addController("Front Center").addCasingInfoMin("Pressure Containment Casings", 128, false).addCasingInfoExactly("Item Pipe Casings", 7, true).addCasingInfoExactly("Pipe Casings", 14, true).addCasingInfoExactly("Heating Coils", 7, true).addCasingInfoExactly("PTFE Frame", 42, false).addInputBus("Any of the Pressure Containment Casings", 1).addOutputBus("Any of the Pressure Containment Casings", 1).addEnergyHatch("Any of the Pressure Containment Casings", 1).addMaintenanceHatch("Any of the Pressure Containment Casings", 1).addMufflerHatch("Any of the Pressure Containment Casings", 1).toolTipFinisher("GregTech");
        return tt;
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.fluidPipeTier = -2;
        this.itemPipeTier = -2;
        this.mCasingAmount = 0;
        this.mEnergyHatches.clear();
        this.setCoilLevel(HeatingCoilLevel.None);
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 3, 6, 0)) {
            return false;
        }
        return this.mMaintenanceHatches.size() == 1 && this.fluidPipeTier >= 0 && this.mCasingAmount >= 128 && this.itemPipeTier >= 0 && this.mEnergyHatches.size() >= 1 && this.mMufflerHatches.size() == 1;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        ITexture[] rTexture = side == aFacing ? (aActive ? new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 3)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_AUTOCLAVE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_AUTOCLAVE_ACTIVE_GLOW).extFacing().glow().build()} : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 3)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_AUTOCLAVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_AUTOCLAVE_GLOW).extFacing().glow().build()}) : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 3))};
        return rTexture;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 3, 6, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int build = this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 3, 6, 0, elementBudget, env, false, true);
        return build;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_MULTI_AUTOCLAVE_LOOP;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEMultiAutoclave(this.mName);
    }

    public float euModifier(int fluidPipeTier) {
        return (float)(12 - fluidPipeTier) / 12.0f;
    }

    public float speedBoost(int coilTier) {
        return 1.0f / (1.0f + 0.25f * (float)coilTier);
    }

    public int getMaxParallelRecipes() {
        return this.itemPipeTier * 12;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)new ProcessingLogic(){

            @Override
            @Nonnull
            public CheckRecipeResult process() {
                this.euModifier = MTEMultiAutoclave.this.euModifier(MTEMultiAutoclave.this.fluidPipeTier);
                this.speedBoost = MTEMultiAutoclave.this.speedBoost(MTEMultiAutoclave.this.getCoilTier());
                return super.process();
            }
        }.setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("fluidPipeTier", this.getFluidPipeTier());
        tag.func_74768_a("itemPipeTier", this.getItemPipeTier());
        tag.func_74768_a("coilTier", this.getCoilTier().intValue());
        tag.func_74776_a("getMaxParallelRecipes", (float)this.getMaxParallelRecipes());
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.fluidPipeTier") + ": " + EnumChatFormatting.WHITE + Math.max(0, tag.func_74762_e("fluidPipeTier")));
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.euModifier") + ": " + EnumChatFormatting.WHITE + dfTwo.format(Math.max(0.0f, this.euModifier(tag.func_74762_e("fluidPipeTier")) * 100.0f)) + "%");
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.itemPipeTier") + ": " + EnumChatFormatting.WHITE + Math.max(0, tag.func_74762_e("itemPipeTier")));
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.parallelism") + ": " + EnumChatFormatting.WHITE + dfNone.format(Math.max(0.0f, tag.func_74760_g("getMaxParallelRecipes"))));
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.coilLevel") + ": " + EnumChatFormatting.WHITE + Math.max(0, tag.func_74762_e("coilTier")));
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.speed") + ": " + EnumChatFormatting.WHITE + dfNone.format(Math.max(0.0f, 100.0f / this.speedBoost(tag.func_74762_e("coilTier")))) + "%");
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.autoclaveRecipes;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(GTUtility.roundUpVoltage(this.getMaxInputVoltage()));
        logic.setAvailableAmperage(1L);
    }
}

